<?php


if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}



function eliides_init_venipak() {
	if ( ! class_exists( 'Veebiekspert_Transport_Venipak' ) && class_exists( 'WC_Shipping_Method' ) ) :

		class Veebiekspert_Transport_Venipak extends WC_Shipping_Method {

			const SHIPPING_METHOD = '_eliides_shipping_method';
			const SEND_TO_SERVER = 'venipak_send_to_server';

			const LAST_NO = '_eliides_venipak_last_no';

			const PRINT_LABEL = 'venipak_print_label';

			const META_BILL_NO = '_eliides_venipak_bill_no';
			const META_PACK_NO = '_eliides_venipak_pack_no';

            //public $supports = array('settings', 'shipping-zones');

			public function __construct() {

				$this->id                 = 'eliides_venipak';

				$this->method_title       = 'Venipak';
				$this->method_description = null;

				$this->title       = __('Venipak', ELIIDES_TD);

                $this->enabled = 'yes';

				add_filter( 'woocommerce_shipping_methods', array(&$this, 'add_shipping_method'));

				$this->init();

				add_action('woocommerce_checkout_update_order_meta', array($this, 'checkout_update_order_meta'), 10, 2);

				if (is_admin()) {

					add_filter('woocommerce_admin_order_actions', array($this, 'send_to_server_btn'), 10, 2);

					add_action('wp_ajax_' . self::PRINT_LABEL, array($this, 'print_label_action'));
				}


			}

            function init() {
                // Load the settings API
                $this->init_form_fields();
                $this->init_settings();

                add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_admin_options' ) );
            }

            function get_admin_options_html() {
                $veebiekspert_active_module = (array) get_option('veebiekspert_active_module');
                $countries = Veebiekspert_Modules()->getCountries();
                $eu_countries = Veebiekspert_Modules()->getEuCountries();
                $venipak = (array) get_option('veebiekspert_module_venipak_params');
                ?>
                <div class="veebiekspert-setting-block">

                    <input type="hidden" name="is_module_active" value="0" />
                    <h2><label><input type="checkbox" name="is_module_active"<?php if (in_array('venipak', $veebiekspert_active_module)): ?> checked<?php endif; ?> value="1" /> Aktiivne</label></h2>

                    <div class="settings-block-inner">

                        <div class="ve-form-group">
                            <label>E-liides litsentsi võti</label>
                            <input type="text" id="veebiekspert_module_venipak_api_key" name="veebiekspert_module_venipak_api_key" value="<?php echo get_option('veebiekspert_module_venipak_api_key'); ?>" />
                            <a href="https://www.e-liides.ee" target="_blank">Registreeri võti (7 päeva tasuta)</a>
                        </div>

                        <div class="ve-form-group">
                            <label>Venipak konto id</label>
                            <input type="text" name="veebiekspert_module_venipak_params[login_id]" value="<?php echo @esc_html(eliides_arr_get($venipak, 'login_id')); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Venipak kasutaja</label>
                            <input type="text" name="veebiekspert_module_venipak_params[user]" value="<?php echo @esc_html(eliides_arr_get($venipak, ['user'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Venipak parool</label>
                            <input type="password" name="veebiekspert_module_venipak_params[password]" value="<?php echo @esc_html(eliides_arr_get($venipak, ['password'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Hinnad</label>

                            <?php

                            $prices = array();

                            foreach (array('EE', 'LT', 'LV') as $country) {
                                $prices[$country] = array(
                                    'price' => 2.49,
                                    'free_from' => '',
                                );
                            }

                            if ($venipakPrices = eliides_arr_get($venipak, ['prices'])) {
                                if (!empty($venipakPrices)) {
                                    $prices = $venipakPrices;
                                }
                            }

                            ?>

                            <table class="widefat fixed" style="margin-top: 20px;">
                                <thead>
                                <tr>
                                    <th>Riik</th>
                                    <th>Hind km-ta</th>
                                    <th>Tasuta tarne alates EUR, km-ta</th>
                                </tr>
                                </thead>
                                <tbody id="venipak-prices-table">
                                <?php foreach ($prices as $country => $price): ?>
                                    <tr>
                                        <td><?php echo $countries[$country]; ?></td>
                                        <td><input style="width: 100%;" type="text" name="veebiekspert_module_venipak_params[prices][<?php echo $country; ?>][price]" value="<?php echo @esc_html(eliides_arr_get($prices, [$country, 'price'])); ?>" /></td>
                                        <td><input style="width: 100%;" type="text" name="veebiekspert_module_venipak_params[prices][<?php echo $country; ?>][free_from]" value="<?php echo @esc_html(eliides_arr_get($prices, [$country, 'free_from'])); ?>" /></td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>

                        </div>

                    </div>

                </div>
                <?php
            }

            public function process_admin_options()
            {
                $this->init_settings();

                $post_data = $this->get_post_data();
                update_option('veebiekspert_module_venipak_api_key', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_venipak_api_key']));
                update_option('veebiekspert_module_venipak_params', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_venipak_params']));

                $activeModules = (array) get_option('veebiekspert_active_module', []);
                $module = 'venipak';

                if (!empty($post_data['is_module_active'])) {
                    if (!in_array($module, $activeModules)) {
                        $activeModules[] = $module;
                        update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
                    }
                }
                else {
                    $key = array_search($module, $activeModules);
                    if (false !== $key) {
                        unset($activeModules[$key]);
                        update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
                    }
                }

            }

			public function send_to_server_btn($actions, $order) {

				$method_id = get_post_meta($order->get_id(), self::SHIPPING_METHOD, true);

				if ($method_id !== $this->id) {
					return $actions;
				}

				if ($order) {
					$actions[self::PRINT_LABEL] = array(
						'action' => self::PRINT_LABEL,
						'url' => wp_nonce_url(admin_url('admin-ajax.php?action=' . self::PRINT_LABEL . '&order_id=' . $order->get_id()), 'eliides-itella-print'),
						'name' => __('Prindi pakisilt', ELIIDES_TD)
					);
				}

				return $actions;

			}

			public function print_label_action() {
				$order_id = absint($_GET['order_id']);

				$pack_no = get_post_meta($order_id, self::META_BILL_NO, true);
				$bill_no = get_post_meta($order_id, self::META_PACK_NO, true);

				$venipak = get_option('veebiekspert_module_venipak_params');

				if (empty($pack_no) || empty($bill_no)) {

					$order = wc_get_order($order_id);

					if ($order) {

						$lastNr = (int) get_option(self::LAST_NO, 0);
						$lastNr ++;

						$firstname = $order->get_billing_first_name();
						$lastname = $order->get_billing_last_name();

						if (!empty($order->get_shipping_first_name()) && !empty($order->get_shipping_last_name())) {
							$firstname = $order->get_shipping_first_name();
							$lastname = $order->get_shipping_last_name();
						}

						$company = $name = trim(implode(' ', array($firstname, $lastname)));

						if ($order->shipping_company) {
							$company = $order->shipping_company;
						}

						$phone = $order->get_billing_phone();
						if ($order->shipping_phone) {
							$phone = $order->shipping_phone;
						}

						$email = $order->get_billing_email();
						if ($order->shipping_email) {
							$email = $order->shipping_email;
						}

						$country = strtoupper(Veebiekspert_Modules()->getOrderShippingCountry($order));

						$venipak['company'] = $company;
						$venipak['phone'] = $phone;
						$venipak['email'] = $email;
						$venipak['country'] = $country;
						$venipak['city'] = $order->get_shipping_city();
						$venipak['address_1'] = $order->get_shipping_address_1();
						$venipak['zipcode'] = $order->get_shipping_postcode();
						$venipak['order_id'] = $lastNr;


						$result = $this->sendRequest('create-label', $venipak);

						if ($result['status'] == 1) {

							update_option(self::LAST_NO, eliides_sanitize_text_or_array_field($lastNr));

							$bill_no = $result['data']['bill_no'];
							$pack_no = $result['data']['pack_no'];

							update_post_meta($order_id, self::META_BILL_NO, eliides_sanitize_text_or_array_field($pack_no));
							update_post_meta($order_id, self::META_PACK_NO, eliides_sanitize_text_or_array_field($bill_no));

							$info = sprintf(__('Venipak paki nr: %s', ELIIDES_TD), (string) $pack_no);

							$order->add_order_note($info, false);
						}
					}

				}

				$result = $this->sendRequest('print-label', array(
					'user' => $venipak['user'],
					'password' => $venipak['password'],
					'pack_no' => $pack_no,
					'bill_no' => $bill_no,
				));

				header("Content-type:application/pdf");
				header("Content-Disposition:attachment;filename=pakisilt_$order_id.pdf");
				echo base64_decode($result['data']);
				exit;
			}

			public function checkout_update_order_meta($order_id, $post) {

				$shipping_method = eliides_arr_get($post, 'shipping_method');

				if (in_array($this->id, (array) $shipping_method)) {

					update_post_meta($order_id, self::SHIPPING_METHOD, $this->id);

				}
			}

			public function add_shipping_method( $methods ) {
				$methods[$this->id] = $this;
				return $methods;
			}


			public function sendRequest($action, $params = array()) {
				$apiKey = get_option('veebiekspert_module_venipak_api_key');

				$params['software'] = 'venipak';

				return Veebiekspert_Modules()->getApi()->sendRequest($apiKey, 'venipak', $action, $params);
			}


			/**
			 * This function is used to calculate the shipping cost. Within this function we can check for weights, dimensions and other parameters.
			 *
			 * @access public
			 * @param mixed $package
			 * @return void
			 */
			public function calculate_shipping( $package = array() ) {

                if (!apply_filters('veebiekspert_shipping_method_is_active', true, 'venipak')) {
                    return false;
                }
                if (!eliides_is_module_active('venipak')) {
                    return false;
                }
				if (get_option('veebiekspert_module_venipak_api_key') == '4337a95454ff615b65c26acb4be9255522373a403669d4e4de1fec77c6e37fd9'){
					return $this->calc_4337a95454ff615b65c26acb4be9255522373a403669d4e4de1fec77c6e37fd9($package);
				}

				$country = strtoupper(eliides_arr_get($package, ['destination', 'country']));

				$venipak = get_option('veebiekspert_module_venipak_params');
				$prices = $venipak['prices'];

				if (strlen($prices[$country]['price']) == 0) {
					return false;
				}

				$price = $prices[$country];

				$items = array();

				$cartTotal = 0;

				foreach ($package['contents'] as $content) {
					$cartTotal += $content['line_subtotal'];
				}

				$hasCoupon = false;

				if (WC()->cart->applied_coupons) {
					foreach (WC()->cart->applied_coupons as $code) {
						$coupon = new WC_Coupon($code);
                        if ($coupon->is_valid_for_cart() && $coupon->get_free_shipping()) {
							$hasCoupon = true;
							break;
						}
					}
				}

				if ($hasCoupon || (strlen($price['free_from']) > 0 && $price['free_from'] <= $cartTotal)) {

					$price = 0;

				}
				else {

					$price = $price['price'];

				}

				$rate = array(
					'id' => $this->id,
					'label' => $this->title,
					'cost' =>  $price
				);

				$this->add_rate( $rate );
			}

			function calc_4337a95454ff615b65c26acb4be9255522373a403669d4e4de1fec77c6e37fd9($package) {

				$city = strtolower($package['destination']['city']);
				if (strtolower(eliides_arr_get($package, ['destination', 'country'])) !== 'lv') {
					return false;
				}

				$venipak = get_option('veebiekspert_module_venipak_params');
				$prices = $venipak['prices'];

				if (in_array($city, array('riga','riia', 'rīga'))) {
					$price = $prices['Riia'];
				}
				else {
					$price = $prices['Muu'];
				}

                $hasFreeShipping = false;

				$items = array();

				$cartTotal = 0;
				$weight = 0;

				foreach ($package['contents'] as $content) {
					$cartTotal += $content['line_subtotal'];

					$product = $content['data'];
					if ($product->needs_shipping()) {

                        $productId = $product->get_id();
                        if ($parentId = $product->get_parent_id()) {
                            $productId = $parentId;
                        }
                        if (get_post_meta($productId, '_no_shipping_cost', true) == 'yes') {
                            $hasFreeShipping = true;
                        }

						for ($qty = 1; $qty <= $content['quantity']; $qty ++) {

							$weight += (int) $product->weight;

						}
					}
				}

				$hasCoupon = false;

				if (WC()->cart->applied_coupons) {
					foreach (WC()->cart->applied_coupons as $code) {
						$coupon = new WC_Coupon($code);
						if ($coupon->is_valid() && $coupon->enable_free_shipping()) {
							$hasCoupon = true;
							break;
						}
					}
				}

				if ($hasFreeShipping || $hasCoupon || (strlen($price['free_from']) > 0 && $price['free_from'] <= $cartTotal)) {

					$price = 0;

				}
				else {
					$finalPrice = $price[200];
					unset($price['free_from']);
					foreach ($price as $k => $i) {
						if ($weight < $k) {
							$finalPrice = $i;
							break;
						}
					}
					$price = $finalPrice;

				}

				$rate = array(
					'id' => $this->id,
					'label' => $this->title,
					'cost' =>  $price
				);

				$this->add_rate( $rate );

			}

		}

        new Veebiekspert_Transport_Venipak();

	endif;
}




add_action('plugins_loaded', 'eliides_init_venipak');


