<?php


if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}



function eliides_init_smartpost_courier_eu() {

    if ( ! class_exists( 'Veebiekspert_Transport_ItellaSmartpostCourierEu' ) && class_exists( 'WC_Shipping_Method' )) :

        class Veebiekspert_Transport_ItellaSmartpostCourierEu extends WC_Shipping_Method {

            const SHIPPING_METHOD = '_eliides_shipping_method';
            const PARCEL = '_eliides_parcel';
            const PICKUP_TIME = '_eliides_pickup_time';
            const SEND_TO_SERVER = 'itella_courier_eu_send_to_server';
            const PARCEL_SIZE = '_eliides_itella_parcel_size';
            const PACKAGE_BARCODE = '_eliides_itella_barcode';
            const PRINT_LABEL = 'itella_courier_eu_print_label';

            protected $_parcels = array();

            public function __construct() {

                $this->id                 = 'eliides_smartpost_courier_eu';

                $this->method_title       = __('Itella kuller Euroopas', ELIIDES_TD);
                $this->method_description = null;

                $this->title       = __('Itella kuller', ELIIDES_TD);

                $this->enabled = 'yes';

                add_filter( 'woocommerce_shipping_methods', array(&$this, 'add_shipping_method'));

                Veebiekspert_Modules()->setSmartpostCourierEu($this);

                $this->init();

                add_action('woocommerce_checkout_update_order_meta', array($this, 'checkout_update_order_meta'), 10, 2);
                add_action('woocommerce_review_order_after_shipping', array(&$this, 'pickup_time'));
                add_action('woocommerce_after_checkout_validation', array($this, 'after_checkout_validation'));

                if (is_admin()) {

                    add_action('woocommerce_process_shop_order_meta', array($this, 'process_shop_order_meta'), 99, 2);
                    add_action('woocommerce_admin_order_data_after_shipping_address', array($this, 'admin_order_pickup_time'));

                    add_filter('woocommerce_admin_order_actions', array($this, 'send_to_server_btn'), 10, 2);

                    add_action('wp_ajax_' . self::SEND_TO_SERVER, array($this, 'send_to_server_action'));
                    add_action('wp_ajax_' . self::PRINT_LABEL, array($this, 'print_label_action'));
                }
                if (eliides_is_module_active('smartpost_courier_eu')) {
                    add_action('woocommerce_order_status_on-hold', array($this, 'check_if_send_to_server_automatic'));
                    add_action('woocommerce_order_status_processing', array($this, 'check_if_send_to_server_automatic'));
                    add_action('woocommerce_order_status_completed', array($this, 'check_if_send_to_server_automatic'));
                }

            }

            function init() {
                // Load the settings API
                $this->init_form_fields();
                $this->init_settings();

                add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_admin_options' ) );
            }

            function get_admin_options_html() {
                $veebiekspert_active_module = (array) get_option('veebiekspert_active_module');
                $countries = Veebiekspert_Modules()->getCountries();
                $eu_countries = Veebiekspert_Modules()->getEuCountries();
                ?>
                <div class="veebiekspert-setting-block">

                    <?php
                    $smartpost = (array) get_option('veebiekspert_module_smartpost_courier_eu_params');
                    if (!isset($smartpost['allowed_countries'])) {
                        $smartpost['allowed_countries'] = array('ee');
                    }
                    $smartpost['allowed_countries'] = (array) eliides_arr_get($smartpost, ['allowed_countries'], array());
                    ?>

                    <input type="hidden" name="is_module_active" value="0" />
                    <h2><label><input type="checkbox" name="is_module_active"<?php if (in_array('smartpost_courier_eu', $veebiekspert_active_module)): ?> checked<?php endif; ?> value="1" /> Aktiivne</label></h2>

                    <div class="settings-block-inner">

                        <div class="ve-form-group">
                            <label>E-liides litsentsi võti</label>
                            <input type="text" id="veebiekspert_module_smartpost_courier_eu_api_key" name="veebiekspert_module_smartpost_courier_eu_api_key" value="<?php echo get_option('veebiekspert_module_smartpost_courier_eu_api_key'); ?>" />
                            <a href="https://www.e-liides.ee" target="_blank">Registreeri võti (7 päeva tasuta)</a>
                        </div>

                        <div class="ve-form-group">
                            <label>Itella API võti</label>
                            <input type="text" name="veebiekspert_module_smartpost_courier_eu_params[itella_api_key]" value="<?php echo @esc_html(eliides_arr_get($smartpost, ['itella_api_key'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label style="color: red;">Itella iseteeninduse kasutaja - see väli kaob alates aprill 2023</label>
                            <input type="text" name="veebiekspert_module_smartpost_courier_eu_params[username]" value="<?php echo @esc_html(eliides_arr_get($smartpost, ['username'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label style="color: red;">Itella iseteeninduse parool - see väli kaob alates aprill 2023</label>
                            <input type="password" name="veebiekspert_module_smartpost_courier_eu_params[password]" value="<?php echo @esc_html(eliides_arr_get($smartpost, ['password'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Saatja nimi</label>
                            <input type="text" name="veebiekspert_module_smartpost_courier_eu_params[sender][name]" value="<?php echo @esc_html(eliides_arr_get($smartpost, ['sender','name'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Saatja telefon</label>
                            <input type="text" name="veebiekspert_module_smartpost_courier_eu_params[sender][phone]" value="<?php echo @esc_html(eliides_arr_get($smartpost, ['sender','phone'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Saatja email</label>
                            <input type="text" name="veebiekspert_module_smartpost_courier_eu_params[sender][email]" value="<?php echo @esc_html(eliides_arr_get($smartpost, ['sender','email'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Pakisildi mõõt</label>
                            <select name="veebiekspert_module_smartpost_courier_eu_params[format]">
                                <?php foreach (array('A4/4','A4-4', 'A4-8', 'A4/8', 'A5', 'A6', 'A7') as $format): ?>
                                    <option value="<?php echo $format; ?>"<?php if ($format == eliides_arr_get($smartpost, 'format')): ?> selected<?php endif; ?>><?php echo $format; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="ve-form-group">
                            <label>Paki andmed saadetakse automaatselt</label>

                            <?php

                            $options = array(
                                '' => 'Automaatselt ei saadeta, pakisildi saab ainult käsitsi tellimuste nimekirjast',
                                'woocommerce_order_status_on-hold' => 'Kui tellimus on vähemalt ootel olekus',
                                'woocommerce_order_status_processing' => 'Kui tellimus on vähemalt töötluses olekus',
                                'woocommerce_order_status_completed' => 'Kui tellimus on täidetud',
                            );

                            $selected = eliides_arr_get($smartpost, ['send_to_server_automatic']);
                            ?>

                            <select name="veebiekspert_module_smartpost_courier_eu_params[send_to_server_automatic]">
                                <?php foreach ($options as $k => $i): ?>
                                    <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="ve-form-group">
                            <label>Muuda tellimuse olek peale pakisildi printimist valitud olekusse</label>

                            <?php
                            $options = array(
                                '' => 'Ei muuda tellimuse olekut',
                            );
                            foreach (wc_get_order_statuses() as $orderStatus => $orderStatusValue) {
                                $options[esc_html(str_replace('wc-', '', $orderStatus))] = esc_html($orderStatusValue);
                            }
                            $selected = eliides_arr_get($smartpost, ['mark_order_completed_after_packing_split_print']);
                            ?>

                            <select name="veebiekspert_module_smartpost_courier_eu_params[mark_order_completed_after_packing_split_print]">
                                <?php foreach ($options as $k => $i): ?>
                                    <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="ve-form-group">
                            <label>Saada pakisildi koopia e-mailile</label>
                            <input type="text" name="veebiekspert_module_smartpost_courier_eu_params[send_pdf_copy]" value="<?php echo @esc_html(eliides_arr_get($smartpost, ['send_pdf_copy'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Hinnad</label>

                            <?php

                            $all = array(
                                'xs' => 2.15,
                                's' => 2.49,
                                'm' => 3.32,
                                'l' => 4.07,
                                'xl'  => 5.40,
                                'free_from' => '',
                            );

                            $defaultPrices = array(
                                'all' => $all,
                            );

                            $prices = eliides_arr_get($smartpost, ['prices'], array());
                            if (empty($prices)) {
                                $prices = $defaultPrices;
                            }

                            if (!isset($prices['all'])) {
                                $prices['all'] = $all;
                            }
                            ?>

                            <table class="widefat fixed" style="margin-top: 20px;">
                                <thead>
                                <tr>
                                    <th>Hinnad km-ta</th>
                                    <th>XS hind</th>
                                    <th>S hind</th>
                                    <th>M hind</th>
                                    <th>L hind</th>
                                    <th>XL hind</th>
                                    <th>Tasuta alates</th>
                                    <th></th>
                                </tr>
                                </thead>
                                <tbody id="smarpost-courier-eu-table">
                                <?php foreach ($prices as $country => $sizes): ?>
                                    <tr>
                                        <td><?php if ($country == 'all'): ?>Kõik ülejäänud riigid<?php else: ?><?php echo @esc_html($countries[$country]); ?><?php endif; ?></td>
                                        <?php foreach ($sizes as $size => $price): ?>
                                            <td><input style="width: 100%;" type="number" step="0.01" name="veebiekspert_module_smartpost_courier_eu_params[prices][<?php echo $country; ?>][<?php echo $size; ?>]" value="<?php echo eliides_number_format($price, 2, '.', ''); ?>" /></td>
                                        <?php endforeach; ?>
                                        <td><?php if ($country !== 'all'): ?><span style="color: red; cursor: pointer;" onclick="jQuery(this).closest('tr').remove();">Kustuta</span><?php endif; ?></td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                                <tfoot>
                                <tr>
                                    <td colspan="5">
                                        <select id="smartpost-courier-eu-new-country">
                                            <?php foreach ($eu_countries as $countryCode => $name): ?>
                                                <option value="<?php echo @esc_html($countryCode); ?>"><?php echo @esc_html($name); ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <button class="button" onclick="return addNewSmartpostCourierEuRow();">Lisa</button>
                                    </td>
                                </tr>
                                </tfoot>
                            </table>

                            <script type="text/javascript">
                                function addNewSmartpostCourierEuRow() {
                                    var html = jQuery('#new-smartpost-courier-eu-row-template').html();

                                    html = html.replace(new RegExp('country_name', 'g'), jQuery('#smartpost-courier-eu-new-country option:selected').text());
                                    html = html.replace(new RegExp('country', 'g'), jQuery('#smartpost-courier-eu-new-country').val());

                                    jQuery('#smarpost-courier-eu-table').append(html);
                                    return false;
                                }
                            </script>

                            <script type="text/template" id="new-smartpost-courier-eu-row-template">
                                <tr>
                                    <td>country_name</td>
                                    <?php foreach ($sizes as $size => $price): ?>
                                        <td><input style="width: 100%;" type="number" step="0.01" name="veebiekspert_module_smartpost_courier_eu_params[prices][country][<?php echo $size; ?>]" value="6" /></td>
                                    <?php endforeach; ?>
                                    <td><span style="color: red; cursor: pointer;" onclick="$(this).closest('tr').remove();">Kustuta</span></td>
                                <tr>
                            </script>

                        </div>

                    </div>

                </div>
                <?php
            }

            public function process_admin_options()
            {
                $this->init_settings();

                $post_data = $this->get_post_data();
                update_option('veebiekspert_module_smartpost_courier_eu_api_key', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_smartpost_courier_eu_api_key']));
                update_option('veebiekspert_module_smartpost_courier_eu_params', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_smartpost_courier_eu_params']));

                $activeModules = (array) get_option('veebiekspert_active_module', []);
                $module = 'smartpost_courier_eu';

                if (!empty($post_data['is_module_active'])) {
                    if (!in_array($module, $activeModules)) {
                        $activeModules[] = $module;
                        update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
                    }
                }
                else {
                    $key = array_search($module, $activeModules);
                    if (false !== $key) {
                        unset($activeModules[$key]);
                        update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
                    }
                }

            }

            public function check_if_send_to_server_automatic($order_id) {
                $smartpost = get_option('veebiekspert_module_smartpost_courier_eu_params');
                $trigger = eliides_arr_get($smartpost, 'send_to_server_automatic');

                if ($order = wc_get_order($order_id)) {

                    if ($trigger == 'woocommerce_order_status_on-hold') {

                        if ($order->has_status(array('on-hold', 'processing', 'completed'))) {
                            $this->send_order_to_server_final($order_id);
                        }
                    }
                    elseif ($trigger == 'woocommerce_order_status_processing') {

                        if ($order->has_status(array('processing', 'completed'))) {
                            $this->send_order_to_server_final($order_id);
                        }
                    }
                    elseif ($trigger == 'woocommerce_order_status_completed') {

                        if ($order->has_status(array('completed'))) {
                            $this->send_order_to_server_final($order_id);
                        }
                    }

                }

            }

            public static function getPickupTimes() {
                return array(
                    1 => __('Igal ajal', ELIIDES_TD),
                    2 => __('09:00 – 17:00', ELIIDES_TD),
                    3 => __('17:00 – 21:00', ELIIDES_TD),
                );
            }

            public function process_shop_order_meta($post_id, $post) {

                if (isset($_POST['change_eliides_pickup_time'])) {

                    if (!$order = wc_get_order($post_id)) {
                        return;
                    }

                    $smartpostTimes = $this->getPickupTimes();

                    $oldTime = get_post_meta($post_id, self::PICKUP_TIME, true);

                    if ($oldTime !== $_POST['change_eliides_pickup_time']) {

                        $old = $smartpostTimes[$oldTime];
                        $new = $smartpostTimes[$_POST['change_eliides_pickup_time']];

                        update_post_meta($post_id, self::PICKUP_TIME, eliides_sanitize_text_or_array_field($_POST['change_eliides_pickup_time']));
                        $order->add_order_note(sprintf(__("Kohaletoomise ajavahemikku muudeti: \nAlgne: %s \nUus: %s", ELIIDES_TD), $old, $new));

                    }

                }

            }

            public function admin_order_pickup_time() {
                global $post;

                if (empty($post)) {
                    return;
                }

                if (!$order = wc_get_order($post->ID)) {
                    return;
                }

                $method_id = get_post_meta($order->get_id(), self::SHIPPING_METHOD, true);
                $currentTime = get_post_meta($order->get_id(), self::PICKUP_TIME, true);

                if ($method_id == $this->id) {

                    $smartpostTimes = $this->getPickupTimes();

                    ?>
                    <div class="eliides_pickup_time">
                        <div><h3><?php _e('Valitud kohaletoimetamise aeg', ELIIDES_TD); ?></h3></div>
                        <div><span style="color: #999;"><?php echo esc_html($smartpostTimes[$currentTime]); ?></span> <a href="#" onclick="jQuery('#eliides_pickup_time-change').show(); return false;"><?php _e('Muuda', ELIIDES_TD); ?></a></div>

                        <div id="eliides_pickup_time-change" style="display: none; margin-top: 15px;">
                            <select name="change_eliides_pickup_time">
                                <?php foreach ($smartpostTimes as $k => $i): ?>
                                    <option value="<?php echo $k; ?>"<?php if ($k == $currentTime): ?> selected<?php endif; ?>><?php echo esc_html($i); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <?php

                }

            }

            public function print_label_action($order) {
                $order_id = absint($_GET['order_id']);

                $smartpost = get_option('veebiekspert_module_smartpost_courier_eu_params');

                if ($newStatus = eliides_arr_get($smartpost, ['mark_order_completed_after_packing_split_print'])) {
                    if ($order = wc_get_order($order_id)) {
                        if (!$order->has_status(array($newStatus))) {
                            $order->update_status($newStatus);
                        }
                    }
                }

                $data = $this->sendRequest('print-label', array(
                    'username' => $smartpost['username'],
                    'password' => $smartpost['password'],
                    'barcode' => get_post_meta($order_id, self::PACKAGE_BARCODE, true),
                    'format' => eliides_arr_get($smartpost, 'format'),
                ));

                $pdf = base64_decode($data['data']);

                header("Content-type:application/pdf");
                header("Content-Disposition:attachment;filename=pakisilt_$order_id.pdf");
                echo $pdf;
                exit;
            }

            public function send_to_server_action($order) {
                $order_id = absint($_GET['order_id']);

                $this->send_order_to_server_final($order_id);

                wp_safe_redirect(wp_get_referer() ? wp_get_referer() : admin_url('edit.php?post_type=shop_order') );
                exit;
            }

            public function send_to_server_btn($actions, $order) {

                $method_id = get_post_meta($order->get_id(), self::SHIPPING_METHOD, true);

                if ($method_id !== $this->id) {
                    return $actions;
                }

                if ($order) {
                    if (!get_post_meta($order->get_id(), self::PACKAGE_BARCODE, true)) {
                        $actions[self::SEND_TO_SERVER] = array(
                            'action' => self::SEND_TO_SERVER,
                            'url' => wp_nonce_url(admin_url('admin-ajax.php?action=' . self::SEND_TO_SERVER . '&order_id=' . $order->get_id()), 'eliides-itella-send'),
                            'name' => __('Saada serverisse', ELIIDES_TD)
                        );
                    }
                    else {
                        $actions[self::PRINT_LABEL] = array(
                            'action' => self::PRINT_LABEL,
                            'url' => wp_nonce_url(admin_url('admin-ajax.php?action=' . self::PRINT_LABEL . '&order_id=' . $order->get_id()), 'eliides-itella-print'),
                            'name' => __('Prindi pakisilt', ELIIDES_TD)
                        );
                    }
                }

                return $actions;

            }

            protected function send_order_to_server_final($order_id) {
                if (!$order = wc_get_order($order_id)) {
                    return;
                }

                if (get_post_meta($order_id, self::PACKAGE_BARCODE, true)) {
                    return;
                }

                $method_id = get_post_meta($order_id, self::SHIPPING_METHOD, true);

                if ($method_id !== $this->id) {
                    return;
                }

                if ($order) {

                    $smartpost = get_option('veebiekspert_module_smartpost_courier_eu_params');

                    $firstname = $order->get_billing_first_name();
                    $lastname = $order->get_billing_last_name();

                    if (!empty($order->get_shipping_first_name()) && !empty($order->get_shipping_last_name())) {
                        $firstname = $order->get_shipping_first_name();
                        $lastname = $order->get_shipping_last_name();
                    }

                    $name = trim(implode(' ', array($firstname, $lastname)));

                    if ($order->get_billing_company()) {
                        $name = $order->get_billing_company();
                    }

                    $phone = $order->get_billing_phone();
                    if ($order->shipping_phone) {
                        $phone = $order->shipping_phone;
                    }

                    $email = $order->get_billing_email();
                    if ($order->shipping_email) {
                        $email = $order->shipping_email;
                    }

                    $size = get_post_meta($order_id, self::PARCEL_SIZE, true);
                    if (empty($size)) {
                        $size = 'xs';
                    }

                    $finalData = apply_filters('eliides_before_send_itella_smartpost_courier_eu', array(
                        'username' => $smartpost['username'],
                        'password' => $smartpost['password'],
                        'reference' => $order_id,
                        'size' => $size,
                        'sender' => $smartpost['sender'],
                        'recipient' => array(
                            'name' => $name,
                            'phone' => $phone,
                            'email' => $email,
                        ),
                        'destination' => array(
                            'time' => get_post_meta($order_id, self::PICKUP_TIME, true),
                            'zipcode' => $order->get_shipping_postcode(),
                            'city' => $order->get_shipping_city(),
                            'state' => $order->get_shipping_state(),
                            'country' => $order->get_shipping_country(),
                            'address_1' => $order->get_shipping_address_1(),
                            'address_2' => $order->get_shipping_address_2(),
                        ),
                    ), $order_id);

                    $data = $this->sendRequest('send-package', $finalData);

                    if (isset($data['data']['item']) && !is_array($data['data']['item'])) {
                        $data['data']['item'] = [$data['data']['item']];
                    }
                    if (isset($data['data']['item'])) {
                        foreach ($data['data']['item'] as $item) {
                            if (!isset($item['barcode'])) {
                                continue;
                            }
                            update_post_meta($order_id, self::PACKAGE_BARCODE, $item['barcode']);

                            if ($email = eliides_arr_get($smartpost, 'send_pdf_copy')) {

                                $pdfResponse = $this->sendRequest('print-label', array(
                                    'username' => eliides_arr_get($smartpost, ['username']),
                                    'password' => eliides_arr_get($smartpost, ['password']),
                                    'barcode' => get_post_meta($order_id, self::PACKAGE_BARCODE, true),
                                    'format' => eliides_arr_get($smartpost, ['format']),
                                ));

                                $pdf = base64_decode($pdfResponse['data']);
                                $dest = VE_ABS_PATH . 'tmp/' . uniqid() . '.pdf';
                                file_put_contents($dest, $pdf);
                                eliides_send_email_with_attachment($email, 'Pakisilt tellimusele #' . $order_id, '', $dest);
                                unlink($dest);
                            }
                        }
                    }

                }
            }

            public function checkout_update_order_meta($order_id, $post) {

                $shipping_method = eliides_arr_get($post, 'shipping_method');

                if (in_array($this->id, (array) $shipping_method)) {

                    update_post_meta($order_id, self::SHIPPING_METHOD, $this->id);

                    $size = 'xs';
                    if (isset(WC()->session->_eliides_smartpost_size)) {
                        $size = WC()->session->_eliides_smartpost_size;
                    }
                    if (empty($size)) {
                        $size = 'xs';
                    }

                    update_post_meta($order_id, self::PARCEL_SIZE, eliides_sanitize_text_or_array_field($size));

                    WC()->session->_eliides_smartpost_courier_time = $_POST['eliides_smartpost_courier_time'];
                    update_post_meta($order_id, self::PICKUP_TIME, eliides_sanitize_text_or_array_field($_POST['eliides_smartpost_courier_time']));
                    update_post_meta($order_id, self::SHIPPING_METHOD, $this->id);

                }
            }

            public function after_checkout_validation() {

                if (in_array($this->id, (array) $_POST['shipping_method'])) {

                    if (!isset($_POST['eliides_smartpost_courier_time']) || empty((int) $_POST['eliides_smartpost_courier_time'])) {
                        wc_add_notice(__('Kohaletoimetamise ajavahemik puudub', ELIIDES_TD), 'error');
                        WC()->session->_eliides_smartpost_courier_time = '';
                        return;
                    }

                }
            }

            public function pickup_time() {

                $chosenMethods = WC()->session->get('chosen_shipping_methods');

                if (!in_array($this->id, (array) $chosenMethods)) {
                    return false;
                }
                $current = WC()->session->get('_eliides_smartpost_courier_time');

                $smartpost = get_option('veebiekspert_module_smartpost_courier_eu_params');

                $smartpostTimes = $this->getPickupTimes();
                ?>
                <tr class="smartpost-courier-shipping-row">
                    <th><?php _e('Sobiv kohaletoimetamise vahemik', ELIIDES_TD); ?></th>
                    <td>
                        <select id="eliides-smartpost-courier-time" name="eliides_smartpost_courier_time">
                            <option value=""><?php _e('Sobiv kohaletoimetamise vahemik', ELIIDES_TD); ?></option>
                            <?php foreach ($smartpostTimes as $k => $i): ?>
                                <option value="<?php echo $k; ?>"<?php if ($k == $current): ?> selected<?php endif; ?>><?php echo esc_html($i); ?></option>
                            <?php endforeach; ?>
                        </select>

                    </td>
                </tr>
                <?php
            }


            public function add_shipping_method( $methods ) {
                $methods[$this->id] = $this;
                return $methods;
            }

            public function sendRequest($action, $params = array()) {
                $apiKey = get_option('veebiekspert_module_smartpost_courier_eu_api_key');
                $smartpost = get_option('veebiekspert_module_smartpost_courier_eu_params', []);
                $params['api_key'] = eliides_arr_get($smartpost, ['itella_api_key']);
                $params['software'] = 'smartpost_courier_eu';

                return Veebiekspert_Modules()->getApi()->sendRequest($apiKey, 'smartpost-courier-eu', $action, $params);
            }


            /**
             * This function is used to calculate the shipping cost. Within this function we can check for weights, dimensions and other parameters.
             *
             * @access public
             * @param mixed $package
             * @return void
             */
            public function calculate_shipping( $package = array() ) {

                if (!apply_filters('veebiekspert_shipping_method_is_active', true, 'smartpost_courier_eu')) {
                    return false;
                }
                $veebiekspert_active_module = get_option('veebiekspert_active_module');

                if (!in_array('smartpost_courier_eu', (array) $veebiekspert_active_module)) {
                    return false;
                }
                $country = strtolower(eliides_arr_get($package, ['destination', 'country']));
                $countries = Veebiekspert_Init::getEuCountries();

                $smartpost = get_option('veebiekspert_module_smartpost_courier_eu_params');

                if (!isset($countries[strtoupper($country)])) {
                    return false;
                }

                $items = array();

                $cartTotal = 0;
                $hasFreeShipping = false;

                $unit = get_option( 'woocommerce_dimension_unit' );

                $unitX = 1;
                if ($unit == 'cm') {
                    $unitX = 10;
                }
                else if ($unit == 'm') {
                    $unitX = 1000;
                }

                foreach ($package['contents'] as $content) {
                    $cartTotal += $content['line_subtotal'];
                    $product = $content['data'];
                    if ($product->needs_shipping()) {
                        $productId = $product->get_id();
                        if (get_post_meta($productId, '_parcel_do_not_fit', true)) {
                            return false;
                        }
                        if ($parentId = $product->get_parent_id()) {
                            $productId = $parentId;
                        }
                        if (get_post_meta($productId, '_no_shipping_cost', true) == 'yes') {
                            $hasFreeShipping = true;
                        }

                        for ($qty = 1; $qty <= $content['quantity']; $qty ++) {

                            if ($product->get_height() > 0 || $product->get_width() > 0 || $product->get_length() > 0) {
                                $length = $width = $weight = $height = 0;
                                if ($product->get_length()) {
                                    $length = $product->get_length();
                                }
                                if ($product->get_width()) {
                                    $width = $product->get_width();
                                }
                                if ($product->get_height()) {
                                    $height = $product->get_height();
                                }
                                if ($product->get_weight()) {
                                    $weight = (int) $product->get_weight();
                                }
                                $items[] = array(
                                    'measures' => array(
                                        $length * $unitX,
                                        $width * $unitX,
                                        $height * $unitX,
                                        $weight
                                    ),
                                );
                            }

                        }
                    }
                }

                $size = '';

                $smartpost = get_option('veebiekspert_module_smartpost_courier_eu_params');
                if (isset($smartpost['prices'][strtoupper($country)])) {
                    $prices = $smartpost['prices'][strtoupper($country)];
                }
                else {
                    $prices = $smartpost['prices']['all'];
                }


                $hasCoupon = false;

                if (WC()->cart->applied_coupons) {
                    foreach (WC()->cart->applied_coupons as $code) {
                        $coupon = new WC_Coupon($code);
                        if ($coupon->is_valid_for_cart() && $coupon->get_free_shipping()) {
                            $hasCoupon = true;
                            break;
                        }
                    }
                }

                if (!empty($items)) {

                    $data = $this->sendRequest('get-parcel-size', array(
                        'items' => $items,
                        'unit' => get_option( 'woocommerce_dimension_unit' )
                    ));

                    if (isset($data['data'])) {
                        if (isset($prices[$data['data']])) {
                            $size = $data['data'];
                        }
                    }

                    if (empty($size)) {
                        return false;
                    }

                }
                else {
                    $size = 'xs';
                }

                if ($hasFreeShipping || $hasCoupon || (strlen($prices['free_from']) > 0 && $prices['free_from'] <= $cartTotal)) {

                    $price = 0;

                }
                else {



                    $price = $prices[$size];

                }

                WC()->session->_eliides_smartpost_size = $size;

                $rate = array(
                    'id' => $this->id,
                    'label' => $this->title,
                    'cost' =>  $price
                );

                $this->add_rate( $rate );
            }


        }

    endif;


    new Veebiekspert_Transport_ItellaSmartpostCourierEu();


}

add_action('plugins_loaded', 'eliides_init_smartpost_courier_eu');


