<?php


if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}



function eliides_init_omniva_parcel_matkahuolto() {

    if ( ! class_exists( 'Veebiekspert_Transport_OmnivaParcelMatkahuolto' ) && class_exists( 'WC_Shipping_Method' ) ) :

        class Veebiekspert_Transport_OmnivaParcelMatkahuolto extends WC_Shipping_Method {

            const SHIPPING_METHOD = '_eliides_shipping_method';
            const PARCEL = '_eliides_parcel';
            const SEND_TO_SERVER = 'omniva_parcel_matkahuolto_send_to_server';
            const PARCEL_SIZE = '_eliides_omniva_parcel_matkahuolto_size';
            const PACKAGE_BARCODE = '_eliides_omniva_parcel_matkahuolto_barcode';
            const PRINT_LABEL = 'omniva_parcel_matkahuolto_print_label';

            protected $_parcels = array();

            public function __construct() {

                $this->id                 = 'eliides_omniva_parcel_matkahuolto';

                $this->method_title       = __('Matkahuolto väljastuspunkt', ELIIDES_TD);
                $this->method_description = null;

                $this->title       = __('Matkahuolto väljastuspunkt', ELIIDES_TD);

                add_filter( 'woocommerce_shipping_methods', array(&$this, 'add_shipping_method'));
                add_filter( 'eliides_omniva_matkahuolto_services_filter', array($this, 'eliides_omniva_matkahuolto_services_filter'));

                Veebiekspert_Modules()->setOmnivaParcelMatkahuolto($this);

                $this->enabled = 'yes';
                $this->init();

                add_action('woocommerce_review_order_after_shipping', array(&$this, 'pickup_location'));
                add_action('woocommerce_after_checkout_validation', array($this, 'after_checkout_validation'));
                add_action('woocommerce_checkout_update_order_meta', array($this, 'checkout_update_order_meta'), 10, 2);
                add_filter('woocommerce_order_shipping_method', array($this, 'alter_shipping_name_in_totals'), 10, 2);

                if (is_admin()) {
                    add_action('woocommerce_process_shop_order_meta', array($this, 'process_shop_order_meta'), 99, 2);
                    add_action('woocommerce_admin_order_data_after_shipping_address', array($this, 'admin_order_pickup_location'));

                    add_filter('woocommerce_admin_order_actions', array($this, 'send_to_server_btn'), 10, 2);

                    add_action('wp_ajax_' . self::SEND_TO_SERVER, array($this, 'send_to_server_action'));
                    add_action('wp_ajax_' . self::PRINT_LABEL, array($this, 'print_label_action'));
                }


            }

            function init() {
                // Load the settings API
                $this->init_form_fields();
                $this->init_settings();

                add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_admin_options' ) );
            }

            function get_admin_options_html() {
                $veebiekspert_active_module = (array) get_option('veebiekspert_active_module');
                $countries = Veebiekspert_Modules()->getCountries();
                $eu_countries = Veebiekspert_Modules()->getEuCountries();
                ?>
                <div class="veebiekspert-setting-block">

                    <?php
                    $omniva_parcel = (array) get_option('veebiekspert_module_omniva_parcel_matkahuolto_params');
                    $omniva_parcel['allowed_countries'] = (array) eliides_arr_get($omniva_parcel, ['allowed_countries'], array());
                    ?>

                    <input type="hidden" name="is_module_active" value="0" />
                    <h2><label><input type="checkbox" name="is_module_active"<?php if (in_array('omniva_parcel_matkahuolto', $veebiekspert_active_module)): ?> checked<?php endif; ?> value="1" /> Aktiivne</label></h2>

                    <div class="settings-block-inner">

                        <div class="ve-form-group">
                            <label>E-liides litsentsi võti</label>
                            <input type="text" id="veebiekspert_module_omniva_parcel_matkahuolto_api_key" name="veebiekspert_module_omniva_parcel_matkahuolto_api_key" value="<?php echo get_option('veebiekspert_module_omniva_parcel_matkahuolto_api_key'); ?>" />
                            <a href="https://www.e-liides.ee" target="_blank">Registreeri võti (7 päeva tasuta)</a>
                        </div>

                        <div class="ve-form-group">
                            <label>Omniva kasutaja</label>
                            <input type="text" name="veebiekspert_module_omniva_parcel_matkahuolto_params[username]" value="<?php echo @esc_html(eliides_arr_get($omniva_parcel, ['username'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Omniva parool</label>
                            <input type="password" name="veebiekspert_module_omniva_parcel_matkahuolto_params[password]" value="<?php echo eliides_arr_get($omniva_parcel, ['password']); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Paki edastamine Omnivale</label>

                            <?php

                            $options = array(
                                'CA' => 'Kuller tuleb järgi',
                                'CD' => 'Viin postkontorisse',
                            );

                            $selected = eliides_arr_get($omniva_parcel, ['pickup_method']);
                            ?>

                            <select name="veebiekspert_module_omniva_parcel_matkahuolto_params[pickup_method]">
                                <?php foreach ($options as $k => $i): ?>
                                    <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>



                        <div class="ve-form-group">
                            <label>Teenuse tüüp</label>

                            <?php

                            $options = array(
                                'businessToClientMsg' => 'businessToClientMsg - Pakiandmed saadetakse Omnivasse ja saate automaatselt pakisildi e-poest trükkida',
                                'preSendMsg' => 'preSendMsg - Pakiandmed saadetakse Omniva serverisse. Omniva iseteeninduses peab pakiandmed eraldi kinnitama',
                            );

                            $selected = eliides_arr_get($omniva_parcel, ['request_type']);
                            ?>

                            <select name="veebiekspert_module_omniva_parcel_matkahuolto_params[request_type]">
                                <?php foreach ($options as $k => $i): ?>
                                    <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="ve-form-group">
                            <label>Aktiivne keskkond</label>

                            <?php

                            $options = array(
                                '0' => 'Live ehk reaalne keskkond',
                                '1' => 'Test ehk süsteemi testimine',
                            );

                            $selected = (int) eliides_arr_get($omniva_parcel, ['is_test']);
                            $selectedCountry = !isset($omniva_parcel['sender']['country']) ? 'EE' : $omniva_parcel['sender']['country'];

                            ?>

                            <select name="veebiekspert_module_omniva_parcel_matkahuolto_params[is_test]">
                                <?php foreach ($options as $k => $i): ?>
                                    <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="ve-form-group">
                            <label>Nimi tagastusaadressil</label>
                            <input type="text" name="veebiekspert_module_omniva_parcel_matkahuolto_params[sender][name]" value="<?php echo @esc_html(eliides_arr_get($omniva_parcel, ['sender','name'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Telefon tagastusaadressil</label>
                            <input type="text" name="veebiekspert_module_omniva_parcel_matkahuolto_params[sender][phone]" value="<?php echo @esc_html(eliides_arr_get($omniva_parcel, ['sender','phone'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>E-mail tagastusaadressil</label>
                            <input type="text" name="veebiekspert_module_omniva_parcel_matkahuolto_params[sender][email]" value="<?php echo @esc_html(eliides_arr_get($omniva_parcel, ['sender','email'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Riik tagastusaadressil</label>
                            <select name="veebiekspert_module_omniva_parcel_matkahuolto_params[sender][country]">
                                <?php foreach ($countries as $countryCode => $name): ?>
                                    <option value="<?php echo @esc_html($countryCode); ?>"<?php if ($countryCode == $selectedCountry): ?> selected<?php endif; ?>><?php echo @esc_html($name); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="ve-form-group">
                            <label>Linn ja maakond tagastusaadressil</label>
                            <input type="text" name="veebiekspert_module_omniva_parcel_matkahuolto_params[sender][city]" value="<?php echo @esc_html(eliides_arr_get($omniva_parcel, ['sender','city'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Tänav tagastusaadressil</label>
                            <input type="text" name="veebiekspert_module_omniva_parcel_matkahuolto_params[sender][street]" value="<?php echo @esc_html(eliides_arr_get($omniva_parcel, ['sender','street'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Postiindeks tagastusaadressil</label>
                            <input type="text" name="veebiekspert_module_omniva_parcel_matkahuolto_params[sender][zip]" value="<?php echo @esc_html(eliides_arr_get($omniva_parcel, ['sender','zip'])); ?>" />
                        </div>

                        <div class="ve-form-group">
                            <label>Lubatud riigid</label>

                            <label>
                                <input style="width: auto;" type="checkbox" name="veebiekspert_module_omniva_parcel_matkahuolto_params[allowed_countries][]"<?php if (in_array('fi', (array) eliides_arr_get($omniva_parcel, ['allowed_countries'], array()))): ?> checked<?php endif; ?> value="fi" /> Soome
                            </label>

                        </div>

                        <div class="ve-form-group">
                            <label>Hinnad</label>

                            <?php
                            $defaultPrices = array(
                                'FI' => array(
                                    's' => 2.45,
                                    'm' => 3.31,
                                    'l' => 4.04,
                                    'free_from' => '',
                                ),
                            );

                            $prices = eliides_arr_get($omniva_parcel, ['prices'], array());
                            if (empty($prices)) {
                                $prices = $defaultPrices;
                            }
                            ?>

                            <table class="widefat fixed" style="margin-top: 20px;">
                                <thead>
                                <tr>
                                    <th>Hinnad km-ta</th>
                                    <th>S hind</th>
                                    <th>M hind</th>
                                    <th>L hind</th>
                                    <th>Tasuta alates</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($prices as $country => $sizes): if ($country !== 'FI') { continue; } ?>
                                    <tr>
                                        <td><?php echo @esc_html($countries[$country]); ?></td>
                                        <?php foreach ($sizes as $size => $price): ?>
                                            <td><input style="width: 100%;" type="number" step="0.01" name="veebiekspert_module_omniva_parcel_matkahuolto_params[prices][<?php echo $country; ?>][<?php echo $size; ?>]" value="<?php echo @esc_html($price) ?>" /></td>
                                        <?php endforeach; ?>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>

                        </div>

                    </div>

                </div>
                <?php
            }

            public function process_admin_options()
            {
                $this->init_settings();

                $post_data = $this->get_post_data();
                update_option('veebiekspert_module_omniva_parcel_matkahuolto_api_key', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_omniva_parcel_matkahuolto_api_key']));
                update_option('veebiekspert_module_omniva_parcel_matkahuolto_params', $post_data['veebiekspert_module_omniva_parcel_matkahuolto_params']);

                $activeModules = (array) get_option('veebiekspert_active_module', []);
                $module = 'omniva_parcel_matkahuolto';

                if (!empty($post_data['is_module_active'])) {
                    if (!in_array($module, $activeModules)) {
                        $activeModules[] = $module;
                        update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
                    }
                }
                else {
                    $key = array_search($module, $activeModules);
                    if (false !== $key) {
                        unset($activeModules[$key]);
                        update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
                    }
                }

            }

            public function eliides_omniva_matkahuolto_services_filter($settings, $orderId = null) {
                return $settings;
            }

            public function print_label_action($order) {
                $order_id = absint($_GET['order_id']);

                $omniva = get_option('veebiekspert_module_omniva_parcel_matkahuolto_params');

                $barcodes = (array) get_post_meta($order_id, self::PACKAGE_BARCODE, true);

                $data = $this->sendRequest('print-label', array(
                    'username' => eliides_arr_get($omniva, 'username'),
                    'password' => eliides_arr_get($omniva, 'password'),
                    'barcodes' => isset($_GET['barcode']) ? $_GET['barcode'] : $barcodes,
                ));

                if (isset($_GET['barcode'])) {
                    update_post_meta($order_id, eliides_sanitize_text_or_array_field('printed_barcode_' . $_GET['barcode']), 1);
                }

                $pdf = base64_decode($data['data']);

                header("Content-type:application/pdf");
                header("Content-Disposition:attachment;filename=pakisilt_$order_id.pdf");
                echo $pdf;
                exit;
            }

            public function send_to_server_action($order) {
                $order_id = absint($_GET['order_id']);

                $this->send_order_to_server_final($order_id);

                wp_safe_redirect(wp_get_referer() ? wp_get_referer() : admin_url('edit.php?post_type=shop_order') );
                exit;
            }

            public function send_to_server_btn($actions, $order) {
                $method_id = get_post_meta($order->get_id(), self::SHIPPING_METHOD, true);

                if ($method_id !== $this->id) {
                    return $actions;
                }

                if ($order) {
                    if (!$barcodes = get_post_meta($order->get_id(), self::PACKAGE_BARCODE, true)) {
                        $actions[self::SEND_TO_SERVER] = array(
                            'action' => self::SEND_TO_SERVER,
                            'url' => wp_nonce_url(admin_url('admin-ajax.php?action=' . self::SEND_TO_SERVER . '&order_id=' . $order->get_id()), 'eliides-itella-send'),
                            'name' => __('Saada serverisse', ELIIDES_TD)
                        );
                    }
                    else {
                        foreach ($barcodes as $barcode) {
                            $extraClass = get_post_meta($order->get_id(), 'printed_barcode_' . $barcode, true) ? ' printed' : ' not-printed';
                            $actions[] = array(
                                'action' => self::PRINT_LABEL . $extraClass,
                                'url' => wp_nonce_url(admin_url('admin-ajax.php?action=' . self::PRINT_LABEL . '&order_id=' . $order->get_id() . '&barcode=' . $barcode), 'eliides-itella-print'),
                                'name' => __('Prindi pakisilt', ELIIDES_TD)
                            );
                        }
                        /*
                        $actions[self::PRINT_LABEL] = array(
                            'action' => self::PRINT_LABEL,
                            'url' => wp_nonce_url(admin_url('admin-ajax.php?action=' . self::PRINT_LABEL . '&order_id=' . $order->get_id()), 'eliides-itella-print'),
                            'name' => __('Prindi pakisilt', ELIIDES_TD)
                        );
                        */
                    }
                }

                return $actions;

            }

            protected function send_order_to_server_final($order_id) {
                $parcel = get_post_meta($order_id, self::PARCEL, true);
                if (!$order = wc_get_order($order_id)) {
                    return;
                }

                $old = get_post_meta($order_id, self::PACKAGE_BARCODE);
                if (!empty($old)) {
                    return;
                }

                if ($parcel && $order) {

                    $omniva = get_option('veebiekspert_module_omniva_parcel_matkahuolto_params');

                    $firstname = $order->get_billing_first_name();
                    $lastname = $order->get_billing_last_name();

                    if (!empty($order->get_shipping_first_name()) && !empty($order->get_shipping_last_name())) {
                        $firstname = $order->get_shipping_first_name();
                        $lastname = $order->get_shipping_last_name();
                    }

                    $name = trim(implode(' ', array($firstname, $lastname)));

                    if ($order->get_billing_company()) {
                        $name = $order->get_billing_company();
                    }

                    $phone = $order->get_billing_phone();
                    $email = $order->get_billing_email();

                    $size = get_post_meta($order_id, self::PARCEL_SIZE, true);
                    if (empty($size)) {
                        $size = 's';
                    }

                    $description = [];

                    foreach ($order->get_items() as $orderItem) {
                        $description[] =  $orderItem->get_quantity() . '×' . $orderItem->get_name();
                    }

                    $params = array(
                        'username' => eliides_arr_get($omniva, ['username']),
                        'password' => eliides_arr_get($omniva, ['password']),
                        'is_test' => eliides_arr_get($omniva, ['is_test']),
                        'pickup_method' => eliides_arr_get($omniva, ['pickup_method']),
                        'reference' => $order_id,
                        'request_type' => eliides_arr_get($omniva, ['request_type']),
                        'size' => $size,
                        'sender' => eliides_arr_get($omniva, ['sender']),
                        'recipient' => array(
                            'name' => $name,
                            'phone' => $phone,
                            'email' => $email,
                        ),
                        'description' => implode('; ' , $description),
                        'destination' => array(
                            'zip' => eliides_arr_get($parcel, ['zip']),
                            'zipcode' => $order->get_shipping_postcode(),
                            'city' => $order->get_shipping_city(),
                            'state' => $order->get_shipping_state(),
                            'country' => $order->get_shipping_country(),
                            'address_1' => $order->get_shipping_address_1(),
                            'address_2' => $order->get_shipping_address_2(),
                        ),
                    );

                    $params = apply_filters('eliides_omniva_matkahuolto_services_filter', $params, $order_id);

                    if (isset($params['qty'])) {
                        $reference = $params['reference'];
                        for ($i = 0; $i < $params['qty']; $i ++) {
                            $params['reference'] = $reference . '-' . ($i + 1);
                            $data = $this->sendRequest('send-package', $params);

                            if (isset($data['data']['barcodes']) && !empty($data['data']['barcodes'])) {
                                if (!$oldCodes = get_post_meta($order_id, self::PACKAGE_BARCODE, true)) {
                                    $oldCodes = array();
                                }
                                $oldCodes[] = array_shift($data['data']['barcodes']);
                                update_post_meta($order_id, self::PACKAGE_BARCODE, eliides_sanitize_text_or_array_field($oldCodes));
                                do_action('after_eliides_omniva_parcel_matkahuolto_barcode', $order_id, $data['data']['barcodes']);
                            }
                            else if (isset($data['errors'])) {
                                $order->add_order_note($data['errors']);
                            }
                        }
                    }
                    else {
                        $data = $this->sendRequest('send-package', $params);

                        if (isset($data['data']['barcodes']) && !empty($data['data']['barcodes'])) {
                            update_post_meta($order_id, self::PACKAGE_BARCODE, eliides_sanitize_text_or_array_field($data['data']['barcodes']));
                            do_action('after_eliides_omniva_parcel_matkahuolto_barcode', $order_id, $data['data']['barcodes']);
                        }
                        else if (isset($data['errors'])) {
                            $order->add_order_note($data['errors']);
                        }
                    }

                }
            }

            public function process_shop_order_meta($post_id, $post) {

                if (isset($_POST['change_eliides_pickup_location'])) {

                    if (!$order = wc_get_order($post_id)) {
                        return;
                    }

                    $country = Veebiekspert_Modules()->getOrderShippingCountry($order);

                    $oldParcel = get_post_meta($post_id, self::PARCEL, true);

                    if ($parcel = $this->getParcel($_POST['change_eliides_pickup_location'], $country)) {

                        if (eliides_arr_get($oldParcel, ['zip']) !== eliides_arr_get($parcel, ['zip'])) {

                            $old = eliides_arr_get($oldParcel, ['zip']);
                            $new = eliides_arr_get($parcel, ['name']);

                            update_post_meta($post_id, self::PARCEL, eliides_sanitize_text_or_array_field($parcel));
                            $order->add_order_note(sprintf(__("Porstipunkti vahetati: \nAlgne: %s \nUus: %s", ELIIDES_TD), $old, $new));

                            do_action('after_eliides_omniva_parcel_matkahuolto_change', $post_id, $parcel);

                        }

                    }

                }

            }

            public function admin_order_pickup_location() {
                global $post;

                if (empty($post)) {
                    return;
                }

                if (!$order = wc_get_order($post->ID)) {
                    return;
                }

                $country = Veebiekspert_Modules()->getOrderShippingCountry($order);

                $method_id = get_post_meta($order->get_id(), self::SHIPPING_METHOD, true);
                $currentParcel = get_post_meta($order->get_id(), self::PARCEL, true);

                if ($method_id == $this->id) {

                    $parcels = $this->getParcels($country);

                    $groups = array();

                    foreach ($parcels as $parcel) {
                        $groups[eliides_arr_get($parcel, 'city')][] = $parcel;
                    }

                    ksort($groups);

                    ?>
                    <div class="eliides_pickup_location">
                        <div><h3><?php _e('Valitud postipunkt', ELIIDES_TD); ?></h3></div>
                        <div><span style="color: #999;"><?php echo $this->getParcelFullTitle($order); ?></span> <a href="#" onclick="jQuery('#eliides_pickup_location-change').show(); return false;"><?php _e('Muuda', ELIIDES_TD); ?></a></div>

                        <div id="eliides_pickup_location-change" style="display: none; margin-top: 15px;">
                            <select name="change_eliides_pickup_location">
                                <option value=""><?php _e('Vali postipunkt', ELIIDES_TD); ?></option>
                                <?php foreach ($groups as $city => $items): ?>
                                    <optgroup label="<?php echo esc_html($city); ?>">
                                        <?php foreach ($items as $item): ?>
                                            <option value="<?php echo eliides_arr_get($item, 'zip'); ?>"<?php if (eliides_arr_get($item, 'zip') == $currentParcel['zip']): ?> selected<?php endif; ?>><?php echo esc_html(eliides_arr_get($item, 'name')); ?></option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <?php

                }

            }

            public function getParcelFullTitle($order) {

                $method_id = get_post_meta($order->get_id(), self::SHIPPING_METHOD, true);

                if ($method_id == $this->id) {
                    $parcel = get_post_meta($order->get_id(), self::PARCEL, true);

                    if ($parcel) {
                        return $this->method_title . ' (' . eliides_arr_get($parcel, 'city') . ', ' . eliides_arr_get($parcel, 'name') . ')';
                    }
                }

                return false;
            }

            public function alter_shipping_name_in_totals($labels, $order = null) {
                if ($order && $order->get_id()) {

                    if ($title = $this->getParcelFullTitle($order)) {
                        return $title;
                    }
                }
                return $labels;
            }

            public function checkout_update_order_meta($order_id, $post) {

                $shipping_method = eliides_arr_get($post, ['shipping_method']);

                if (in_array($this->id, (array) $shipping_method)) {
                    $shippingCountry = eliides_arr_get(WC()->session->get('customer'), 'shipping_country');

                    $parcel = $this->getParcel($_POST['eliides_omniva_parcel_matkahuolto_location'], $shippingCountry);

                    if ($parcel) {
                        WC()->session->set('_eliides_omniva_parcel_matkahuolto_location', eliides_arr_get($parcel, 'zip'));
                        update_post_meta($order_id, self::PARCEL, eliides_sanitize_text_or_array_field($parcel));
                        update_post_meta($order_id, self::SHIPPING_METHOD, $this->id);

                        $size = 'xs';
                        if (WC()->session->get('_eliides_omniva_parcel_size')) {
                            $size = WC()->session->get('_eliides_omniva_parcel_size');
                        }
                        if (empty($size)) {
                            $size = 'xs';
                        }

                        update_post_meta($order_id, self::PARCEL_SIZE, eliides_sanitize_text_or_array_field($size));

                        do_action('after_eliides_omniva_parcel_matkahuolto_change', $order_id, $parcel);

                    }

                }
            }

            public function after_checkout_validation() {

                if (in_array($this->id, (array) $_POST['shipping_method'])) {

                    if (!isset($_POST['eliides_omniva_parcel_matkahuolto_location']) || empty((int) $_POST['eliides_omniva_parcel_matkahuolto_location'])) {
                        wc_add_notice(__('Pakiautomaat puudub', ELIIDES_TD), 'error');
                        WC()->session->set('_eliides_omniva_parcel_matkahuolto_location', '');
                        return;
                    }

                    $shippingCountry = eliides_arr_get(WC()->session->get('customer'), 'shipping_country');

                    if (!$parcel = $this->getParcel($_POST['eliides_omniva_parcel_matkahuolto_location'], $shippingCountry)) {
                        wc_add_notice(__('Tundmatu pakiautomaat', ELIIDES_TD), 'error');
                        WC()->session->set('_eliides_omniva_parcel_matkahuolto_location', '');
                        return;
                    }

                }
            }

            public function pickup_location() {

                $chosenMethods = WC()->session->get('chosen_shipping_methods');

                if (!in_array($this->id, (array) $chosenMethods)) {
                    return false;
                }

                $shippingCountry = eliides_arr_get(WC()->session->get('customer'), ['shipping_country']);

                $parcels = $this->getParcels($shippingCountry);

                $groups = array();

                foreach ($parcels as $parcel) {
                    $groups[eliides_arr_get($parcel, 'city')][] = $parcel;
                }

                //ksort($groups);

                $current = WC()->session->get('_eliides_omniva_parcel_matkahuolto_location');
                ?>
                <tr>
                    <td colspan="2" class="eliides-chosen-wrapper">
                        <div style="padding-bottom: 10px;"><?php _e('Vali postipunkt', ELIIDES_TD); ?></div>
                        <select class="chosen-select-parcel" id="eliides-omniva-parcel-location" name="eliides_omniva_parcel_matkahuolto_location">
                            <option value=""><?php _e('Vali postipunkt', ELIIDES_TD); ?></option>
                            <?php foreach ((array) $groups as $city => $items): ?>
                                <optgroup label="<?php echo esc_html($city); ?>">
                                    <?php foreach ((array) $items as $item): ?>
                                        <option value="<?php echo eliides_arr_get($item, 'zip'); ?>"<?php if (eliides_arr_get($item, 'zip') == $current): ?> selected<?php endif; ?>><?php echo esc_html(eliides_arr_get($item, 'name')); ?></option>
                                    <?php endforeach; ?>
                                </optgroup>
                            <?php endforeach; ?>
                        </select>
                        <script type="text/javascript">
                            jQuery(".chosen-select-parcel").chosen({
                                width: '100%'
                            });
                        </script>
                        <style>
                            .eliides-chosen-wrapper .chosen-container {
                                font-size: 15px;
                            }
                            .eliides-chosen-wrapper {
                                text-align: left !important;
                            }
                            .eliides-chosen-wrapper a.chosen-single {
                                height: 34px !important;
                                line-height: 34px !important;
                            }
                        </style>
                    </td>
                </tr>
                <?php
            }

            public function add_shipping_method( $methods ) {
                $methods[$this->id] = $this;
                return $methods;
            }

            public function getParcel($placeId, $country) {
                $parcels = $this->getParcels($country);
                foreach ($parcels as $parcel) {
                    if (eliides_arr_get($parcel, 'zip') == $placeId) {
                        return $parcel;
                    }
                }
                return false;
            }

            public function getParcels($country = 'FI') {
                if (isset($this->_parcels[$country])) {
                    return (array) $this->_parcels[$country];
                }
                $res = $this->sendRequest('get-parcels', array('country' => $country));
                $this->_parcels[$country] = (array) eliides_arr_get($res, 'data');

                return (array) eliides_arr_get($res, 'data');
            }

            public function sendRequest($action, $params = array()) {
                $apiKey = get_option('veebiekspert_module_omniva_parcel_matkahuolto_api_key');

                $params['software'] = 'omniva_parcel_matkahuolto';

                return Veebiekspert_Modules()->getApi()->sendRequest($apiKey, 'omniva-parcel-matkahuolto', $action, $params);
            }


            /**
             * This function is used to calculate the shipping cost. Within this function we can check for weights, dimensions and other parameters.
             *
             * @access public
             * @param mixed $package
             * @return void
             */
            public function calculate_shipping( $package = array() ) {
                if (!apply_filters('veebiekspert_shipping_method_is_active', true, 'omniva_parcel_matkahuolto')) {
                    return false;
                }
                $veebiekspert_active_module = get_option('veebiekspert_active_module');

                if (!in_array('omniva_parcel_matkahuolto', (array) $veebiekspert_active_module)) {
                    return false;
                }

                $country = strtolower(eliides_arr_get($package, ['destination', 'country']));

                $omniva = get_option('veebiekspert_module_omniva_parcel_matkahuolto_params', []);
                $omniva['allowed_countries'] = (array) eliides_arr_get($omniva, ['allowed_countries']);

                if ($country !== 'fi') {
                    return false;
                }
                /*
                if (!in_array($country, (array) $omniva['allowed_countries'])) {
                    return false;
                }
                */

                $items = array();

                $hasFreeShipping = false;

                $cartTotal = 0;

                $unit = get_option( 'woocommerce_dimension_unit' );

                $unitX = 1;
                if ($unit == 'cm') {
                    $unitX = 10;
                }
                else if ($unit == 'm') {
                    $unitX = 1000;
                }

                foreach ($package['contents'] as $content) {
                    $cartTotal += $content['line_subtotal'];
                    $product = $content['data'];
                    if ($product->needs_shipping()) {

                        $productId = $product->get_id();
                        if (get_post_meta($productId, '_parcel_do_not_fit', true)) {
                            return false;
                        }
                        if ($parentId = $product->get_parent_id()) {
                            $productId = $parentId;
                        }
                        if (get_post_meta($productId, '_no_shipping_cost', true) == 'yes') {
                            $hasFreeShipping = true;
                        }

                        for ($qty = 1; $qty <= $content['quantity']; $qty ++) {

                            if ($product->get_height() > 0 || $product->get_width() > 0 || $product->get_length() > 0) {
                                $length = $width = $weight = $height = 0;
                                if ($product->get_length()) {
                                    $length = $product->get_length();
                                }
                                if ($product->get_width()) {
                                    $width = $product->get_width();
                                }
                                if ($product->get_height()) {
                                    $height = $product->get_height();
                                }
                                if ($product->get_weight()) {
                                    $weight = (int) $product->get_weight();
                                }
                                $items[] = array(
                                    'measures' => array(
                                        $length * $unitX,
                                        $width * $unitX,
                                        $height * $unitX,
                                        $weight
                                    ),
                                );
                            }

                        }
                    }
                }

                $size = '';

                $prices = $omniva['prices'][strtoupper($country)];

                $hasCoupon = false;

                if (WC()->cart->applied_coupons) {
                    foreach (WC()->cart->applied_coupons as $code) {
                        $coupon = new WC_Coupon($code);
                        if ($coupon->is_valid_for_cart() && $coupon->get_free_shipping()) {
                            $hasCoupon = true;
                            break;
                        }
                    }
                }

                if (!empty($items)) {

                    $data = $this->sendRequest('get-parcel-size', array(
                        'items' => $items,
                        'unit' => get_option( 'woocommerce_dimension_unit' )
                    ));

                    if (isset($data['data'])) {
                        if (isset($prices[$data['data']])) {
                            $size = $data['data'];
                        }
                    }

                    if (empty($size)) {
                        return false;
                    }

                }
                else {
                    $size = 's';
                }

                if ($hasFreeShipping || $hasCoupon || (strlen($prices['free_from']) > 0 && $prices['free_from'] <= $cartTotal)) {

                    $price = 0;

                }
                else {



                    $price = $prices[$size];

                }

                WC()->session->set('_eliides_omniva_parcel_size', $size);

                $rate = array(
                    'id' => $this->id,
                    'label' => $this->title,
                    'cost' =>  $price
                );

                $this->add_rate( $rate );
            }


        }

    endif;

    new Veebiekspert_Transport_OmnivaParcelMatkahuolto();


}

add_action('plugins_loaded', 'eliides_init_omniva_parcel_matkahuolto');
