<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

if ( ! class_exists( 'Veebiekspert_Payment_Maksekeskus_WC_Credit_Card' ) ) :

class Veebiekspert_Payment_Maksekeskus_WC_Credit_Card extends WC_Payment_Gateway {

    public $id = 'eliides_maksekeskus_credit';
    
    public $has_fields = true;
    
    public $enabled_methods = array();
    
    public $supports = array( 'products', 'refunds' );
    
    const PAYMENT_METHOD_NAME = 'maksekeskus_card_selected_method';
    
    const BANKLINK_TYPE = 'cards';
    
    /**
     * E-liides maksekeskus module
     * 
     * @var Veebiekspert_Payment_Maksekeskus
     */
    protected $_maksekeskus;
    
    public function __construct() {
        $this->_maksekeskus = Veebiekspert_Modules()->getMaksekeskus();
        $this->title = __('Krediitkaart', ELIIDES_TD);
		
		$this->enabled = true;

        $this->init_settings();

        add_action('init', array($this, 'banklink_response'));
        add_action('before_woocommerce_pay', array($this, 'before_woocommerce_pay'));
    }
    
    public function before_woocommerce_pay() {
        $order_id = (int) $_GET['order'];
        $order = new WC_Order((int) $order_id);
        
        if ($order->get_payment_method() !== $this->id) {
            return false;
        }
        
        if (get_post_meta($order_id, '_eliides_credit_card_paid', true)) {
            return false;
        }
        if (!$transaction = get_post_meta($order_id, '_eliides_maksekeskus_transaction', true)) {
            return false;
        }
        
        $method = get_post_meta($order_id, '_eliides_maksekeskus_transaction_payment_method', true);
        
        $selectedMethod = null;
        foreach ($transaction['payment_methods']['cards'] as $card) {
            if ($card['name'] == $method) {
                $selectedMethod = $card;
                break;
            }
        }
        
        if (empty($selectedMethod)) {
            return false;
        }

        $firstname = $order->get_billing_first_name();
        $lastname = $order->get_billing_last_name();
        
        $billTo = trim(implode(' ', array($firstname, $lastname)));
        
        if ($order->get_billing_company()) {
            $billTo = $order->get_billing_company();
        }
        
        $url = home_url() . '/?eliides_validate_payment=' . $this->id . '&order_id=' . $order_id;
        
        $uniqid = uniqid();
        
        $mkUrl = 'https://payment.maksekeskus.ee/checkout/dist/checkout.min.js';
        
        if ((int) get_option('veebiekspert_module_maksekeskus_is_test', '0') > 0) {
            $mkUrl = 'https://payment-test.maksekeskus.ee/checkout/dist/checkout.min.js';
        }
        ?>

        <div style="margin-bottom: 50px;" class="credit-card-wait">
            <?php _e('Palun oodake, suuname maksma', ELIIDES_TD); ?>
            
            <div>
                <span id="checkoutBtn-<?php echo $uniqid; ?>" class="checkoutBtn"><?php _e('Maksa krediitkaardiga', ELIIDES_TD); ?></span>
            </div>
        </div>

        <style>
            .woocommerce-error {
                display: none;
            }
        </style>
        
        <form id="checkoutForm-<?php echo $uniqid; ?>" class="checkoutForm" action="<?php echo $url; ?>" method="POST">
            <input type="hidden" name="transaction" id="transaction" value="<?php echo $transaction['id']; ?>" />
        
            <script src="<?php echo $mkUrl; ?>"
                data-key="<?php echo esc_html(get_option('veebiekspert_module_maksekeskus_public_key')); ?>"
                data-transaction="<?php echo $transaction['id']; ?>"
                data-amount="<?php echo $order->get_total(); ?>"
                data-email="<?php echo esc_html($transaction['customer']['email']); ?>"
                data-client-name="<?php echo esc_html($billTo); ?>"
                data-locale="et"
                data-name="<?php echo esc_html(get_option('veebiekspert_module_maksekeskus_shop_name')); ?>"
                data-description="Tellimus <?php echo $order_id; ?>"
                data-selector="#checkoutBtn-<?php echo $uniqid; ?>"
                data-backdrop-close="false">
            </script>
        
        </form>
        <style>
        .checkoutForm {
            display: none;
        }
        #checkoutBtn-<?php echo $uniqid; ?> {
            background-color:#44c767;
        	-moz-border-radius:5px;
        	-webkit-border-radius:5px;
        	border-radius:5px;
        	border:1px solid #18ab29;
        	display:inline-block;
        	cursor:pointer;
        	color:#ffffff;
        	font-size:17px;
        	padding:9px 31px;
        	text-decoration:none;
        	text-shadow:0px 1px 0px #2f6627;
        }
        .credit-card-wait {
            font-size: 20px;
            display: none;
        }
        .credit-card-wait:first-child {
            display: block;
        }
        </style>
        <script type="text/javascript">
        jQuery(function() {
            jQuery('.checkoutBtn').first().click();
        });
        </script>
        
        
        
        <?php
    }
    
    public function banklink_response() {
        if (!isset($_GET['eliides_validate_payment'])) {
            return;
        }
        if ($_GET['eliides_validate_payment'] !== $this->id) {
            return;
        }
        
        $response = $this->_maksekeskus->validatePayment($_POST);
        
        $order_id = $response['data']['reference'];
        $order = new WC_Order((int) $order_id);
        
        $url = $this->get_return_url($order);
        
        if ($response['status'] > 0) {
            
            do_action('eliides_before_success_payment', $order_id);
            
            update_post_meta($order_id, '_eliides_credit_card_paid', 1);
            
            $order->add_order_note(__('Makse õnnestus', ELIIDES_TD));
            $order->payment_complete();
            
            do_action('eliides_after_success_payment', $order_id);
        }
        else {
            do_action('eliides_before_failed_payment');
            
            $order->add_order_note(__('Makse ebaõnnestus', ELIIDES_TD));
            $order->add_order_note(json_encode($response));

            $order->set_status('failed');

            $order->save();
            
            do_action('eliides_after_failed_payment');
        }
        
        wp_redirect($url);
        exit;
    }
    
    public function process_refund( $order_id, $amount = null, $reason = '' ) {
        if (empty($reason)) {
            $reason = 'Põhjus puudub';
        }
        $transactionId = get_post_meta($order_id, '_eliides_maksekeskus_transaction_id', true);
        if ($transactionId) {
            $this->_maksekeskus->createRefund($transactionId, $amount, $reason);
            
            $order = new WC_Order((int) $order_id);
            $order->add_order_note(sprintf(__('Amount %s refunded', ELIIDES_TD), $amount));
            
            return true;
        }
        return false;
    }
    
    public function validate_fields() {
        $method = $_POST[self::PAYMENT_METHOD_NAME];

        $enabledMethods = get_option('veebiekspert_module_maksekeskus_enabled_methods');
        $methods = $enabledMethods[self::BANKLINK_TYPE];
        
        if (empty($method) || !in_array($method, $methods)) {
            wc_add_notice(__('Vali makseviis', ELIIDES_TD), 'error');
            return false;
        }
        return true;
    }
    
    public function process_payment($order_id) {
        $order = new WC_Order($order_id);
        
        $method = $_POST[self::PAYMENT_METHOD_NAME];
        
        //$order->update_status( 'on-hold', __( 'Makse ootel', ELIIDES_TD ) );
        
        $url = home_url() . '/?eliides_validate_payment=' . $this->id;
        
        $transaction = $this->_maksekeskus->createTransaction(array(
            'currency' => 'eur',
            'total' => $order->get_total(),
            'reference' => $order_id,
            'email' => (string) $order->get_billing_email(),
            'ip' => $_SERVER['REMOTE_ADDR'],
            'return_url' => array('url' => $url, 'method' => 'POST'),
            'cancel_url' => array('url' => $url, 'method' => 'POST'),
            'notification_url' => array('url' => $url, 'method' => 'POST'),
        ));
        
        $redirectUrl = add_query_arg('order', $order_id, add_query_arg('key', $order->get_order_key(), $order->get_checkout_payment_url(true)));
        
        update_post_meta($order_id, '_eliides_maksekeskus_transaction_id', $transaction['id']);
        update_post_meta($order_id, '_eliides_maksekeskus_transaction_payment_method', $method);
        
        update_post_meta($order_id, '_eliides_maksekeskus_transaction', $transaction);
        
        return array(
            'result' => 'success',
            'redirect' => $redirectUrl,
        );
    }
    
    public function payment_fields() {
        $enabledMethods = get_option('veebiekspert_module_maksekeskus_enabled_methods');
        $methods = $enabledMethods[self::BANKLINK_TYPE];
        
        $allMethods = $this->_maksekeskus->getPaymentMethods();
        $uniqid = uniqid();
        ?>
        <input type="hidden" id="<?php echo $uniqid; ?>" name="<?php echo self::PAYMENT_METHOD_NAME; ?>" value="" />
        <style>
        .veebiekspert-methods-<?php echo $uniqid; ?> .method-item {
            border: 3px solid rgba(0,0,0,0);
            opacity: 0.7;
            padding: 5px;
            cursor: pointer;
            border-radius: 3px;
            display: inline-block;
            margin: 5px;
            
        }
        .veebiekspert-methods-<?php echo $uniqid; ?> .method-item img {
            height: 35px;
            margin: 0 !important;
            padding: 0;
        }
        .veebiekspert-methods-<?php echo $uniqid; ?> .method-item:hover {
            opacity: 0.9;
            border: 3px solid rgba(0,0,0,0.4);
        }
        .veebiekspert-methods-<?php echo $uniqid; ?> .method-item.selected {
            opacity: 1;
            border: 3px solid #fff;
            background: #fff;
            -webkit-box-shadow: 5px 5px 5px 0px rgba(0,0,0,0.2);
            -moz-box-shadow: 5px 5px 5px 0px rgba(0,0,0,0.2);
            box-shadow: 5px 5px 5px 0px rgba(0,0,0,0.2);
        }
        </style>
        <div class="veebiekspert-methods-<?php echo $uniqid; ?>">
        <?php foreach ($allMethods[self::BANKLINK_TYPE] as $banklink): ?>
            
            
            <?php if (in_array($banklink['name'], $methods)): ?>
            <div class="method-item" banklink="<?php echo esc_html($banklink['name']); ?>">
                <img src="<?php echo esc_html($banklink['logo_url']); ?>" alt="" />
            </div>
            <?php endif; ?>
            
        <?php endforeach; ?>
        </div>
        
        <script type="text/javascript">
        jQuery(function() {
            jQuery('#<?php echo $uniqid; ?>').val('');
            
            jQuery('.veebiekspert-methods-<?php echo $uniqid; ?> .method-item').click(function() {
                jQuery('.veebiekspert-methods-<?php echo $uniqid; ?> .method-item').removeClass('selected');
                jQuery(this).addClass('selected');
                jQuery('#<?php echo $uniqid; ?>').val(jQuery(this).attr('banklink'));
            });
        });
        </script>
        <?php
    }
    
}

endif; 