<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

if ( ! class_exists( 'Veebiekspert_Payment_Swedbank' ) ) :


class Veebiekspert_Payment_Swedbank {

    /**
     * API
     *
     * @var Veebiekspert_API
     */
    protected $_api;

    protected $_api_key;

    /**
     * Swedbank banklink WC module
     *
     * @var Veebiekspert_Payment_Swedbank_WC
     */
    protected $_wc_module;

    /**
     * Consturctor
     *
     * @param Veebiekspert_API $api
     */
    public function __construct(Veebiekspert_API $api) {

        $this->_api = $api;

        $veebiekspert_active_module = get_option('veebiekspert_active_module');

        if (!in_array('swedbank', (array) $veebiekspert_active_module)) {
            return;
        }

        $this->_api_key = get_option('veebiekspert_module_swedbank_api_key');

        if ($this->_api_key) {

            add_action('plugins_loaded', array($this, 'init_module'));

            add_action('woocommerce_payment_gateways', array($this, 'woocommerce_payment_gateways'));
            add_filter('woocommerce_available_payment_gateways', array($this, 'woocommerce_available_payment_gateways'));

        }

    }

    public function woocommerce_available_payment_gateways($allowed_gateways) {
        $all_gateways = WC()->payment_gateways->payment_gateways();
        $allowed_gateways['eliides_swedbank'] = $all_gateways['eliides_swedbank'];
        return $allowed_gateways;
    }

    public function woocommerce_payment_gateways($methods) {
        //include_once( VE_ABS_PATH . 'payment/wc-module/swedbank.php' );

        $methods['eliides_swedbank'] = 'Veebiekspert_Payment_Swedbank_WC';

        return $methods;

    }

    public function init_module() {
        include_once( VE_ABS_PATH . 'payment/wc-module/swedbank.php' );
        new Veebiekspert_Payment_Swedbank_WC();
    }

    public function getPaymentForm($total, $reference, $returnLink, $title, $paymentMethod = '') {
        $res = $this->_api->sendRequest($this->_api_key, 'swedbank', 'get-form', array(
            'software' => 'swedbank',
            'bank_params' => get_option('veebiekspert_module_swedbank_params'),
            'total' => $total,
            'reference' => $reference,
            'title' => $title,
            'return_url' => $returnLink,
            'payment_method' => $paymentMethod
        ));

        return $res;
    }

    public function validateResponse($params = array()) {
        $res = $this->_api->sendRequest($this->_api_key, 'swedbank', 'validate-response', array(
            'software' => 'swedbank',
            'bank_params' => get_option('veebiekspert_module_swedbank_params'),
            'params' => $params,
        ));

        return $res;
    }

}

endif; 