<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

if ( ! class_exists( 'Veebiekspert_Payment_Maksekeskus' ) ) :


class Veebiekspert_Payment_Maksekeskus {
    
    /**
     * API
     * 
     * @var Veebiekspert_API
     */
    protected $_api;
    
    protected $_api_key;
    
    /**
     * Maksekeskus WC module
     * 
     * @var Veebiekspert_Payment_Maksekeskus_WC
     */
    protected $_wc_module;
    
    /**
     * Maksekeskus WC module credit card
     * 
     * @var Veebiekspert_Payment_Maksekeskus_WC_Credit_Card
     */
    protected $_wc_module_credit_card;
    
    /**
     * Consturctor
     * 
     * @param Veebiekspert_API $api
     */
    public function __construct(Veebiekspert_API $api) {
        
        $this->_api = $api;
        
        $veebiekspert_active_module = get_option('veebiekspert_active_module');
        
        if (!in_array('maksekeskus', (array) $veebiekspert_active_module)) {
            return;
        }
        
        $this->_api_key = get_option('veebiekspert_module_maksekeskus_api_key');
        
        if ($this->_api_key) {
            add_action('plugins_loaded', array($this, 'init_module'));
            if (isset($_GET['eliides_validate_payment']) && in_array($_GET['eliides_validate_payment'], array(
                'eliides_maksekeskus_credit', 'eliides_maksekeskus'
                ))) {
                add_action('init', array($this, 'init_module'));
            }
            else {
                add_action('plugins_loaded', array($this, 'init_module'));
            }

            add_action('woocommerce_payment_gateways', array($this, 'woocommerce_payment_gateways'));
            add_filter('woocommerce_available_payment_gateways', array($this, 'woocommerce_available_payment_gateways'));
        }
        
    }

    public function woocommerce_available_payment_gateways($allowed_gateways) {
        $all_gateways = WC()->payment_gateways->payment_gateways();
        if (isset($all_gateways['eliides_maksekeskus'])) {
            $allowed_gateways['eliides_maksekeskus'] = $all_gateways['eliides_maksekeskus'];
        }
        if (isset($all_gateways['eliides_maksekeskus_credit'])) {
            $allowed_gateways['eliides_maksekeskus_credit'] = $all_gateways['eliides_maksekeskus_credit'];
        }

        return $allowed_gateways;
    }
    
    public function woocommerce_payment_gateways($methods) {
        
        $enabledMethods = get_option('veebiekspert_module_maksekeskus_enabled_methods');
        
        include_once( VE_ABS_PATH . 'payment/wc-module/maksekeskus.php' );
        include_once( VE_ABS_PATH . 'payment/wc-module/maksekeskus-credit-card.php' );
        
        if (!empty(eliides_arr_get($enabledMethods, ['banklinks']))) {
            $methods['eliides_maksekeskus'] = 'Veebiekspert_Payment_Maksekeskus_WC';
        }
        if (!empty(eliides_arr_get($enabledMethods, ['cards']))) {
            $methods['eliides_maksekeskus_credit'] = 'Veebiekspert_Payment_Maksekeskus_WC_Credit_Card';
        }
        
        return $methods;
        
    }
    
    public function init_module() {
        include_once( VE_ABS_PATH . 'payment/wc-module/maksekeskus.php' );
        include_once( VE_ABS_PATH . 'payment/wc-module/maksekeskus-credit-card.php' );
        new Veebiekspert_Payment_Maksekeskus_WC();
        new Veebiekspert_Payment_Maksekeskus_WC_Credit_Card();

    }
    
    public function createTransaction($data) {
        $data = array_merge(array(
            'software' => 'maksekeskus',
            'shop_id' => get_option('veebiekspert_module_maksekeskus_shop_id'),
            'pub_key' => get_option('veebiekspert_module_maksekeskus_public_key'),
            'priv_key' => get_option('veebiekspert_module_maksekeskus_private_key'),
            'is_test' => get_option('veebiekspert_module_maksekeskus_is_test'),
        ), $data);
        
        $res = $this->_api->sendRequest($this->_api_key, 'maksekeskus', 'create-transaction', $data);
        
        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }
    
    public function validatePayment($post) {
        $res = $this->_api->sendRequest($this->_api_key, 'maksekeskus', 'validate-transaction', array(
            'software' => 'maksekeskus',
            'shop_id' => get_option('veebiekspert_module_maksekeskus_shop_id'),
            'pub_key' => get_option('veebiekspert_module_maksekeskus_public_key'),
            'priv_key' => get_option('veebiekspert_module_maksekeskus_private_key'),
            'is_test' => get_option('veebiekspert_module_maksekeskus_is_test'),
            'post' => $post
        ));
        
        return $res;
    }
    
    public function createRefund($transactionId, $amount, $comment) {
        $res = $this->_api->sendRequest($this->_api_key, 'maksekeskus', 'create-refund', array(
            'software' => 'maksekeskus',
            'shop_id' => get_option('veebiekspert_module_maksekeskus_shop_id'),
            'pub_key' => get_option('veebiekspert_module_maksekeskus_public_key'),
            'priv_key' => get_option('veebiekspert_module_maksekeskus_private_key'),
            'is_test' => get_option('veebiekspert_module_maksekeskus_is_test'),
            'transaction_id' => $transactionId,
            'total' => $amount,
            'comment' => $comment
        ));
        
        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }
    
    public function getPaymentMethods() {
        $res = $this->_api->sendRequest($this->_api_key, 'maksekeskus', 'get-payment-methods', array(
            'software' => 'maksekeskus',
            'shop_id' => get_option('veebiekspert_module_maksekeskus_shop_id'),
            'pub_key' => get_option('veebiekspert_module_maksekeskus_public_key'),
            'priv_key' => get_option('veebiekspert_module_maksekeskus_private_key'),
            'is_test' => get_option('veebiekspert_module_maksekeskus_is_test'),
        ));
        
        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }
    
}

endif; 