<?php
/**
 * Plugin Name: E-liidese moodulid
 * Plugin URI: https://www.e-liides.ee
 * Description: Create integrations easily
 * Version: 2.8.7
 * Author: Priit Elbe
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

include_once(ABSPATH.'wp-admin/includes/plugin.php');

if ( ! class_exists( 'Veebiekspert_Init' ) && is_plugin_active('woocommerce/woocommerce.php') ) :


define('VE_ABS_PATH', dirname( __FILE__ ) . '/' );
define('ELIIDES_TD', 'eliides');
define('ELIIDES_VERSION', 2.87);
define('ELIIDES_VERSION_STR', '2.8.7');



include_once( VE_ABS_PATH . 'general/settings.php' );
include_once( VE_ABS_PATH . 'api/veebiekspert.php' );
include_once( VE_ABS_PATH . 'accounting/compucash/compucash.php' );
include_once( VE_ABS_PATH . 'accounting/smartaccounts/smartaccounts.php' );
include_once( VE_ABS_PATH . 'accounting/merit/merit.php' );
include_once( VE_ABS_PATH . 'accounting/excellent/excellent.php' );
include_once( VE_ABS_PATH . 'accounting/erply/erply.php' );
include_once( VE_ABS_PATH . 'accounting/simplbooks/simplbooks.php' );
include_once( VE_ABS_PATH . 'payment/maksekeskus.php' );
include_once( VE_ABS_PATH . 'payment/swedbank.php' );
include_once( VE_ABS_PATH . 'payment/seb.php' );
include_once( VE_ABS_PATH . 'payment/lhv.php' );
include_once( VE_ABS_PATH . 'payment/danske.php' );
include_once( VE_ABS_PATH . 'payment/coop.php' );
include_once( VE_ABS_PATH . 'payment/estcard.php' );
include_once( VE_ABS_PATH . 'payment/luminor.php' );
include_once( VE_ABS_PATH . 'transport/itella_smartpost.php' );
include_once( VE_ABS_PATH . 'transport/smartpost_courier.php' );
include_once( VE_ABS_PATH . 'transport/smartpost_courier_eu.php' );
include_once( VE_ABS_PATH . 'transport/omniva_parcel.php' );
include_once( VE_ABS_PATH . 'transport/omniva_parcel_office.php' );
include_once( VE_ABS_PATH . 'transport/omniva_parcel_matkahuolto.php' );
include_once( VE_ABS_PATH . 'transport/omniva.php' );
include_once( VE_ABS_PATH . 'transport/dhl.php' );
include_once( VE_ABS_PATH . 'transport/venipak.php' );
include_once( VE_ABS_PATH . 'transport/dpd_parcel.php' );
include_once( VE_ABS_PATH . 'checkout/simple-checkout.php' );
include_once( VE_ABS_PATH . 'custom/company_autocomplete.php' );

if (!file_exists(VE_ABS_PATH . 'tmp')) {
    mkdir(VE_ABS_PATH . 'tmp');
}

if (!function_exists('eliides_send_email_with_attachment')) {
    function eliides_send_email_with_attachment($to, $subject, $body = '', $attachments = []) {
        $headers = array('Content-Type: text/html; charset=UTF-8');
        if (empty($body)) {
            $body = $subject;
        }
        wp_mail( $to, $subject, $body, $headers, (array) $attachments );
    }
}

add_action('admin_head', function() {
   ?>
    <style>
        .ve-form-group {
            margin-top: 20px;
        }
        .ve-form-group label {
            display: block;
        }
        .ve-form-group input,
        .ve-form-group textarea {
            width: 600px;
        }
        .veebiekspert-setting-block {
            padding: 20px;
            margin: 30px 0;
            background: #fff;
        }
    </style>
<?php
});

/**
 * Veebiekspert class
 *
 * @author Priit
 *
 */
class Veebiekspert_Init {

    public $plugin_slug;
    public $version;
    public $cache_key = 'eliides_module_upd';
    public $cache_allowed = true;

    protected $_settings;

    protected $_smartaccounts;
    protected $_merit;
    protected $_excellent;
    protected $_erply;
    protected $_simplbooks;
    protected $_compucash;

    protected $_maksekeskus;

    protected $_api;

    protected $_swedbank;
    protected $_seb;
    protected $_lhv;
    protected $_danske;
    protected $_coop;
    protected $_luminor;
    protected $_estcard;

    protected $_smartpost;
    protected $_smartpost_courier;
    protected $_smartpost_courier_eu;
    protected $_omniva_parcel;
    protected $_omniva_parcel_office;
    protected $_omniva_parcel_matkahuolto;
    protected $_omniva;
    protected $_company_autocomplete;

    protected $_dpd_parcel;

    /**
     * The single instance of the class
     *
     * @var Veebiekspert_Init
     */
    protected static $_instance = null;

    /**
     * Veebiekspert instance
     *
     * @static
     * @see Veebiekspert_Modules()
     * @return Veebiekspert_Init
     */
    public static function instance() {
        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    public function __construct() {
        $this->plugin_slug = plugin_basename( __DIR__ );
        $this->version = ELIIDES_VERSION_STR;

        $this->initHooks();

        $this->_settings = new Veebiekspert_Settings();
        $this->_api = new Veebiekspert_API();
        $this->_merit = new Veebiekspert_Accouting_Merit($this->_api);
        $this->_excellent = new Veebiekspert_Accouting_Excellent($this->_api);
        $this->_erply = new Veebiekspert_Accouting_Erply($this->_api);
        $this->_simplbooks = new Veebiekspert_Accouting_Simplbooks($this->_api);
        $this->_compucash = new Veebiekspert_Accouting_CompuCash($this->_api);
        $this->_smartaccounts = new Veebiekspert_Accouting_Smartaccounts($this->_api);

        $this->_maksekeskus = new Veebiekspert_Payment_Maksekeskus($this->_api);

        $this->_swedbank = new Veebiekspert_Payment_Swedbank($this->_api);
        $this->_seb = new Veebiekspert_Payment_Seb($this->_api);
        $this->_lhv = new Veebiekspert_Payment_Lhv($this->_api);
        $this->_danske = new Veebiekspert_Payment_Danske($this->_api);
        $this->_coop = new Veebiekspert_Payment_Coop($this->_api);
        $this->_luminor = new Veebiekspert_Payment_Luminor($this->_api);
        $this->_estcard = new Veebiekspert_Payment_Estcard($this->_api);
        $this->_company_autocomplete = new Veebiekspert_Custom_CompanyAutocomplete($this->_api);

        add_filter( 'plugins_api', array( $this, 'plugins_api' ), 20, 3 );
        add_filter( 'site_transient_update_plugins', array( $this, 'update' ) );
        add_action( 'upgrader_process_complete', array( $this, 'purge' ), 10, 2 );
        add_action( 'init', array( $this, 'init' ));

        //new Veebiekspert_Checkout_SimpleCheckout($this->_api);

        add_action( 'woocommerce_variation_options_pricing', array($this, 'woocommerce_variation_options_pricing'), 10, 3 );
        add_action( 'woocommerce_product_options_shipping', array($this, 'woocommerce_product_options_general_product_data') );
        add_action( 'woocommerce_process_product_meta', array($this, 'woocommerce_process_product_meta') );
        add_action( 'woocommerce_save_product_variation', array($this, 'woocommerce_save_product_variation'), 10, 2);
        add_action('wp_head', function() {
            ?>
            <link href="https://cdnjs.cloudflare.com/ajax/libs/chosen/1.8.7/chosen.css" rel="stylesheet" />
            <script src="https://cdnjs.cloudflare.com/ajax/libs/chosen/1.8.7/chosen.jquery.min.js"></script>
            <?php
        });
    }

    public function init()
    {
        load_plugin_textdomain(ELIIDES_TD, false, dirname(plugin_basename(__FILE__)) . '/');
    }

    public function request(){

        $remote = get_transient( $this->cache_key );

        if( false === $remote || ! $this->cache_allowed ) {

            $remote = wp_remote_get(
                'https://www.e-liides.ee/et/woocommerce-plugin-info',
                array(
                    'timeout' => 10,
                    'headers' => array(
                        'Accept' => 'application/json'
                    )
                )
            );

            if(
                is_wp_error( $remote )
                || 200 !== wp_remote_retrieve_response_code( $remote )
                || empty( wp_remote_retrieve_body( $remote ) )
            ) {
                return false;
            }

            set_transient( $this->cache_key, $remote, HOUR_IN_SECONDS );

        }

        $remote = json_decode( wp_remote_retrieve_body( $remote ) );

        return $remote;

    }

    public function plugins_api( $res, $action, $args ) {
        if( 'plugin_information' !== $action ) {
            return $res;
        }

        // do nothing if it is not our plugin
        if( $this->plugin_slug !== $args->slug ) {
            return $res;
        }

        // get updates
        $remote = $this->request();

        if( ! $remote ) {
            return $res;
        }

        $res = new stdClass();

        $res->name = $remote->name;
        $res->slug = $remote->slug;
        $res->version = $remote->version;
        $res->tested = $remote->tested;
        $res->requires = $remote->requires;
        $res->author = $remote->author;
        $res->author_profile = $remote->author_profile;
        $res->download_link = $remote->download_url;
        $res->trunk = $remote->download_url;
        $res->requires_php = $remote->requires_php;
        $res->last_updated = $remote->last_updated;

        $res->sections = array(
            'description' => $remote->sections->description,
            'installation' => $remote->sections->installation,
        );
        return $res;

    }

    public function update( $transient ) {

        if ( empty($transient->checked ) ) {
            return $transient;
        }

        $remote = $this->request();

        if(
            $remote
            && version_compare( $this->version, $remote->version, '<' )
            && version_compare( $remote->requires, get_bloginfo( 'version' ), '<=' )
            && version_compare( $remote->requires_php, PHP_VERSION, '<' )
        ) {
            $res = new stdClass();
            $res->slug = $this->plugin_slug;
            $res->plugin = plugin_basename( __FILE__ );
            $res->new_version = $remote->version;
            $res->tested = $remote->tested;
            $res->package = $remote->download_url;

            $transient->response[ $res->plugin ] = $res;

        }

        return $transient;

    }

    public function purge( $upgrader, $options ){

        if (
            $this->cache_allowed
            && 'update' === $options['action']
            && 'plugin' === $options[ 'type' ]
        ) {
            // just clean the cache when new plugin version is installed
            delete_transient( $this->cache_key );
        }

    }

    public function woocommerce_product_options_general_product_data () {
        global $woocommerce, $post;
        echo '<div class=" product_custom_field ">';

        woocommerce_wp_checkbox(
            array(
                'id'          => '_parcel_do_not_fit',
                'label'       => 'Ei mahu pakiautomaati',
                'placeholder' => '',
                'cbvalue'    => '1'
            )
        );

        echo '</div>';
    }

    public function woocommerce_variation_options_pricing ($loop, $variation_data, $variation) {
        global $woocommerce, $post;

        woocommerce_wp_checkbox(
            array(
                'id'          => '_parcel_do_not_fit',
                'label'       => 'Ei mahu pakiautomaati',
                'wrapper_class'       => 'form-row form-row-full options',
                'placeholder' => '',
                'cbvalue'    => '1',
                'value' => get_post_meta( $variation->ID, '_parcel_do_not_fit', true )
            )
        );

    }

    public function woocommerce_save_product_variation( $variation_id, $i ) {
        if (!isset($_POST['_parcel_do_not_fit'])) {
            delete_post_meta($variation_id, '_parcel_do_not_fit');
        }
        else {
            $parcelFitValue = $_POST['_parcel_do_not_fit'];
            update_post_meta($variation_id, '_parcel_do_not_fit', eliides_sanitize_text_or_array_field($parcelFitValue));
        }
    }

    public function woocommerce_process_product_meta($post_id)
    {
        if (!isset($_POST['_parcel_do_not_fit'])) {
            delete_post_meta($post_id, '_parcel_do_not_fit');
        }
        else {
            $parcelFitValue = $_POST['_parcel_do_not_fit'];
            update_post_meta($post_id, '_parcel_do_not_fit', eliides_sanitize_text_or_array_field($parcelFitValue));
        }

    }

    public function getOrderShippingCountry($order) {
        $shipping_country = get_option('woocommerce_default_country');
        if ($order) {
            if ($order->get_shipping_country()) {
                $shipping_country = $order->get_shipping_country();
            }
        }
        return $shipping_country;
    }

    public function getApi() {
        return $this->_api;
    }

    public function getMerit() {
        return $this->_merit;
    }

    public function getSmartaccounts() {
        return $this->_smartaccounts;
    }

    public function getExcellent() {
        return $this->_excellent;
    }

    public function getCompuCash() {
        return $this->_compucash;
    }

    public function getErply() {
        return $this->_erply;
    }

    public function getSimplbooks() {
        return $this->_simplbooks;
    }

    public function getMaksekeskus() {
        return $this->_maksekeskus;
    }

    public function getSwedbank() {
        return $this->_swedbank;
    }

    public function getSeb() {
        return $this->_seb;
    }

    public function getLhv() {
        return $this->_lhv;
    }

    public function getDanske() {
        return $this->_danske;
    }

    public function getCoop() {
        return $this->_coop;
    }

    public function getLuminor() {
        return $this->_luminor;
    }

    public function getSmartpost() {
        return $this->_smartpost;
    }

    public function getDpdParcel() {
        return $this->_dpd_parcel;
    }

    public function getSmartpostCourier() {
        return $this->_smartpost_courier;
    }

    public function getOmnivaParcel() {
        return $this->_omniva_parcel;
    }
    public function getOmnivaParcelOffice() {
        return $this->_omniva_parcel_office;
    }

    public function getOmnivaParcelMatkahuolto() {
        return $this->_omniva_parcel_matkahuolto;
    }

    public function getOmniva() {
        return $this->_omniva;
    }

    public function getEstcard() {
        return $this->_estcard;
    }

    public function setSmartpostCourier(Veebiekspert_Transport_ItellaSmartpostCourier $smartpostCourier) {
        $this->_smartpost_courier = $smartpostCourier;
    }

    public function setSmartpostCourierEu(Veebiekspert_Transport_ItellaSmartpostCourierEu $smartpostCourierEu) {
        $this->_smartpost_courier_eu = $smartpostCourierEu;
    }

    public function setSmartpost(Veebiekspert_Transport_ItellaSmartpost $smartpost) {
        $this->_smartpost = $smartpost;
    }

    public function setDpdParcel(Veebiekspert_Transport_DpdParcel $dpdParcel) {
        $this->_dpd_parcel = $dpdParcel;
    }

    public function setOmnivaParcel(Veebiekspert_Transport_OmnivaParcel $omniva) {
        $this->_omniva_parcel = $omniva;
    }

    public function setOmnivaParcelOffice(Veebiekspert_Transport_OmnivaParcelOffice $omniva) {
        $this->_omniva_parcel_office = $omniva;
    }

    public function setOmnivaParcelMatkahuolto(Veebiekspert_Transport_OmnivaParcelMatkahuolto $omniva) {
        $this->_omniva_parcel_matkahuolto = $omniva;
    }

    public function setOmniva(Veebiekspert_Transport_Omniva $omniva) {
        $this->_omniva = $omniva;
    }

    public function initHooks() {
        add_action('admin_init', array($this, 'admin_init'));
    }

    public function admin_init() {
        wp_register_style('eliides_global_css', plugins_url('assets/global.css',__FILE__ ), [], $this->version);
        wp_enqueue_style('eliides_global_css', [], $this->version);
    }

    public static function WC() {
		if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
			global $woocommerce;
			return $woocommerce;
		}
		return false;
    }

    public static function getEuCountries() {
        $countries = self::getCountries();
        if (empty($countries)) {
            return array();
        }

        $names = array();

        if (class_exists('WC_Countries')) {
            if (method_exists('WC_Countries', 'get_european_union_countries')) {
                $countriesObj = new WC_Countries();
                $names = $countriesObj->get_european_union_countries();
            }
        }

        if (empty($names)) {
            $names = array( 'AT', 'BE', 'BG', 'CY', 'CZ', 'DE', 'DK', 'EE', 'ES', 'FI', 'FR', 'GB', 'GR', 'HU', 'HR', 'IE', 'IT', 'LT', 'LU', 'LV', 'MT', 'NL', 'PL', 'PT', 'RO', 'SE', 'SI', 'SK' );

        }

        $res = array();

        foreach ($countries as $countryCode => $country) {
            if (in_array($countryCode, $names)) {
                $res[$countryCode] = $country;
            }
        }

        return $res;

    }

    public static function getCountries() {
		if (class_exists('WC_Countries')) {
			$countries_obj   = new WC_Countries();
    		$countries   = $countries_obj->__get('countries');
			if (!empty($countries)) {
				return (array) $countries;
			}
		}
        if ($wc = self::WC()) {
            $countries = $wc->countries;
            if (isset($countries->countries)) {
                return (array) $countries->countries;
            }
        }
        return array();
    }

    public static function getShippingGroupsForSimpleCheckout() {
        $shippingGroups = array(
            'parcel' => __('Pakiautomaat', ELIIDES_TD),
            'courier' => __('Kuller', ELIIDES_TD),
            'other' => __('Muu', ELIIDES_TD),
        );

        return $shippingGroups;
    }

}

if (!function_exists('Veebiekspert_Modules')) {
    function Veebiekspert_Modules()
    {
        return Veebiekspert_Init::instance();
    }
}

if (!function_exists('eliides_is_module_active')) {
    function eliides_is_module_active($module) {
        $veebiekspert_active_module = get_option('veebiekspert_active_module', []);
        if (!is_array($veebiekspert_active_module)) {
            return false;
        }
        if (in_array($module, $veebiekspert_active_module)) {
            return true;
        }
        return false;
    }
}

if (!function_exists('eliides_arr_get')) {
    function eliides_arr_get($arr, $keys, $default = '')
    {
        if (!is_array($arr)) {
            return $default;
        }
        if (is_array($keys)) {
            $cnt = count($keys);
            foreach ($keys as $i => $key) {
                if ($cnt - 1 == $i) {
                    if (isset($arr[$key])) {
                        return $arr[$key];
                    }
                    return $default;
                } elseif (array_key_exists($key, $arr)) {
                    $arr = $arr[$key];
                }
            }
        } else {
            if (isset($arr[$keys])) {
                return $arr[$keys];
            }
        }

        return $default;
    }
}

if (!function_exists('eliides_number_format')) {
    function eliides_number_format($str, $decimals = 2, $thousands = '', $sep = '')
    {
        if (!strlen($str)) {
            return '';
        }
        return number_format($str, $decimals, $thousands, $sep);
    }
}

if (!function_exists('eliides_sanitize_text_or_array_field')) {
    function eliides_sanitize_text_or_array_field($array_or_string)
    {
        if (is_string($array_or_string)) {
            $array_or_string = sanitize_text_field($array_or_string);
        } elseif (is_array($array_or_string)) {
            foreach ($array_or_string as $key => &$value) {
                if (is_array($value)) {
                    $value = eliides_sanitize_text_or_array_field($value);
                } else {
                    $value = sanitize_text_field($value);
                }
            }
        }

        return $array_or_string;
    }
}

$GLOBALS['eliides'] = Veebiekspert_Modules();

endif;
