<?php
/**
 * Review order table
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/review-order.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<table class="shop_table woocommerce-checkout-review-order-table">

    <?php if ( true || (WC()->cart->needs_shipping() && WC()->cart->show_shipping()) ) : ?>

        <div style="display: none;">
            <?php do_action( 'woocommerce_review_order_before_cart_contents' ); ?>
            <?php do_action( 'woocommerce_review_order_after_cart_contents' ); ?>
        </div>

        <?php do_action( 'woocommerce_review_order_before_shipping' ); ?>

        <tr>
            <td colspan="2">

                <?php
                $packages           = WC()->shipping()->get_packages();
                $first              = true;

                foreach ( $packages as $i => $package ) {
                    $chosen_method = isset( WC()->session->chosen_shipping_methods[ $i ] ) ? WC()->session->chosen_shipping_methods[ $i ] : '';
                    $product_names = array();

                    if ( count( $packages ) > 1 ) {
                        foreach ( $package['contents'] as $item_id => $values ) {
                            $product_names[ $item_id ] = $values['data']->get_name() . ' &times;' . $values['quantity'];
                        }
                        $product_names = apply_filters( 'woocommerce_shipping_package_details_array', $product_names, $package );
                    }

                    wc_get_template(
                        'checkout/cart-shipping.php',
                        array(
                            'package'                  => $package,
                            'available_methods'        => $package['rates'],
                            'show_package_details'     => count( $packages ) > 1,
                            'show_shipping_calculator' => false,
                            'package_details'          => implode( ', ', $product_names ),
                            /* translators: %d: shipping package number */
                            'package_name'             => apply_filters( 'woocommerce_shipping_package_name', ( ( $i + 1 ) > 1 ) ? sprintf( _x( 'Shipping %d', 'shipping packages', 'woocommerce' ), ( $i + 1 ) ) : _x( 'Shipping', 'shipping packages', 'woocommerce' ), $i, $package ),
                            'index'                    => $i,
                            'chosen_method'            => $chosen_method,
                            'formatted_destination'    => WC()->countries->get_formatted_address( $package['destination'], ', ' ),
                            'has_calculated_shipping'  => WC()->customer->has_calculated_shipping(),
                        )
                    );

                    $first = false;
                }
                ?>
            </td>
        </tr>

        <?php do_action( 'woocommerce_review_order_before_order_total' ); ?>
        <?php do_action( 'woocommerce_review_order_after_shipping' ); ?>

    <?php endif; ?>


    <?php do_action( 'woocommerce_review_order_after_order_total' ); ?>


</table>

<style>
    #parcelmachine_smartpost_field {
        margin: 0;
        padding: 0;
    }
    .shop_table.woocommerce-checkout-review-order-table td,
    #parcelmachine_omniva_field td,
    #parcelmachine_omniva_field {
        padding: 0;
    }
    .shop_table tbody tr {
        height: auto;
    }

    #parcelmachine_omniva:before,
    #parcelmachine_smartpost_field:before {
        content: '<?php _e('Vali pakiautomaat', ELIIDES_TD); ?>';
        font-weight: bold;
        display: block;
        margin-top: 20px;
    }

    #parcelmachine_omniva,#parcelmachine_smartpost {
        display: block;
        width: 100%;
        margin: 20px 0;
        margin-top: 5px;
    }
</style>

<script type="text/javascript">
    jQuery(function($){
        if ($('#customer_details').attr('shipping-country') !== '<?php echo WC()->customer->get_shipping_country(); ?>') {
            addEliidesSimpleCheckoutLoader();
            location.reload();
        }
    });

</script>