<?php
/**
 * Shipping Methods Display
 *
 * In 2.1 we show methods per package. This allows for multiple methods per order if so desired.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-shipping.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.0
 */

defined( 'ABSPATH' ) || exit;

$formatted_destination    = isset( $formatted_destination ) ? $formatted_destination : WC()->countries->get_formatted_address( $package['destination'], ', ' );
$has_calculated_shipping  = ! empty( $has_calculated_shipping );
$show_shipping_calculator = ! empty( $show_shipping_calculator );
$calculator_text          = '';

$hasParcel = false;

$simpleCheckoutOptions = get_option('veebiekspert_module_simple_checkout');

$shippingGroups = Veebiekspert_Init::getShippingGroupsForSimpleCheckout();


?>

<tr>
    <td colspan="2">
<?php if ( $available_methods ) : ?>

    <?php if ($simpleCheckoutOptions['shipping_display'] == 'list'): ?>

            <div id="shipping-tabs-content">

                <?php $activeMethod = null; ?>

                    <?php foreach ( $available_methods as $method ) : if ($method->method_id == $chosen_method) { $activeMethod = $method->method_id; }?>

                        <div class="shipping-method" method="<?php echo $method->method_id; ?>">
                            <?php
                            if ( 1 < count( $available_methods ) ) {
                                printf( '<input type="radio" name="shipping_method[%1$d]" data-index="%1$d" id="shipping_method_%1$d_%2$s" value="%3$s" class="shipping_method" %4$s />', $index, esc_attr( sanitize_title( $method->id ) ), esc_attr( $method->id ), checked( $method->id, $chosen_method, false ) ); // WPCS: XSS ok.
                            } else {
                                printf( '<input type="hidden" name="shipping_method[%1$d]" data-index="%1$d" id="shipping_method_%1$d_%2$s" value="%3$s" class="shipping_method" />', $index, esc_attr( sanitize_title( $method->id ) ), esc_attr( $method->id ) ); // WPCS: XSS ok.
                            }
                            printf( '<label for="shipping_method_%1$s_%2$s">%3$s</label>', $index, esc_attr( sanitize_title( $method->id ) ), wc_cart_totals_shipping_method_label( $method ) ); // WPCS: XSS ok.
                            do_action( 'woocommerce_after_shipping_rate', $method, $index );
                            ?>
                        </div>
                    <?php endforeach; ?>

            </div>

    <?php else: ?>

            <?php

            $finalShippingGroups = array();

            foreach ($shippingGroups as $groupId => $groupName) {
                $finalShippingGroups[$groupId] = array();
            }

            foreach ($available_methods as $method) {
                if (isset($simpleCheckoutOptions['shipping'][$method->method_id])) {
                    foreach ($shippingGroups as $groupId => $groupName) {
                        if ($groupId == $simpleCheckoutOptions['shipping'][$method->method_id]) {
                            $finalShippingGroups[$groupId][$method->method_id] = $method;
                        }
                    }
                }
            }

            foreach ($finalShippingGroups as $groupId => $methods) {
                if (empty($methods)) {
                    unset($finalShippingGroups[$groupId]);
                }
            }


            ?>

        <div id="checkout-shipping-tabs-container">

            <div id="shipping-tabs-nav">

            <?php $nr = 0; foreach ($finalShippingGroups as $groupId => $methods): $nr ++; ?>
                <span class="tab<?php if ($nr == 1): ?> active<?php endif; ?>" target="#shipping-tab-<?php echo $groupId; ?>">
                    <?php echo esc_html($shippingGroups[$groupId]); ?>
                </span>
            <?php endforeach; ?>

            </div>
            <div id="shipping-tabs-content">

                <?php $activeMethod = null; $nr = 0; foreach ($finalShippingGroups as $groupId => $methods): $nr ++; ?>

                    <div id="shipping-tab-<?php echo $groupId; ?>" class="shipping-tab">
                        <?php foreach ( $methods as $method ) : if ($method->method_id == $chosen_method) { $activeMethod = $method->method_id; }?>

                                <div class="shipping-method" method="<?php echo $method->method_id; ?>">
                                    <?php
                                    if ( 1 < count( $available_methods ) ) {
                                        printf( '<input type="radio" name="shipping_method[%1$d]" data-index="%1$d" id="shipping_method_%1$d_%2$s" value="%3$s" class="shipping_method" %4$s />', $index, esc_attr( sanitize_title( $method->id ) ), esc_attr( $method->id ), checked( $method->id, $chosen_method, false ) ); // WPCS: XSS ok.
                                    } else {
                                        printf( '<input type="hidden" name="shipping_method[%1$d]" data-index="%1$d" id="shipping_method_%1$d_%2$s" value="%3$s" class="shipping_method" />', $index, esc_attr( sanitize_title( $method->id ) ), esc_attr( $method->id ) ); // WPCS: XSS ok.
                                    }
                                    printf( '<label for="shipping_method_%1$s_%2$s">%3$s</label>', $index, esc_attr( sanitize_title( $method->id ) ), wc_cart_totals_shipping_method_label( $method ) ); // WPCS: XSS ok.
                                    do_action( 'woocommerce_after_shipping_rate', $method, $index );
                                    ?>
                                </div>
                        <?php endforeach; ?>
                    </div>

                <?php endforeach; ?>

            </div>
        </div>

    <?php endif; ?>


    <script type="text/javascript">

        <?php if ($simpleCheckoutOptions['shipping_display'] !== 'list'): ?>
        jQuery(function() {
            jQuery('#shipping-tabs-nav .tab').click(function() {
                jQuery('.shipping-tab').hide();
                jQuery(jQuery(this).attr('target')).show();
                jQuery('#shipping-tabs-nav .tab').removeClass('active');
                jQuery(this).addClass('active');
            });

            var selected = jQuery('.shipping-method input:checked');

            jQuery('.tab[target="#' + jQuery(selected).closest('.shipping-tab').attr('id') + '"]').click();

        });
        <?php endif; ?>

        <?php if ($simpleCheckoutOptions['shipping'][$activeMethod] == 'courier'): ?>
        if (jQuery('#billing_address_1_field').length == 0) {
            addEliidesSimpleCheckoutLoader();
            location.reload();
        }
        <?php else: ?>
        if (jQuery('#billing_address_1_field').length > 0) {
            addEliidesSimpleCheckoutLoader();
            location.reload();
        }
        <?php endif; ?>


    </script>

<?php else: ?>

    <div style="padding: 10px; margin: 20px 0; background: red; color: #fff">Tarneviise ei leitud!</div>

<?php endif; ?>

    </td>
</tr>