<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}


if ( ! class_exists( 'Veebiekspert_Checkout_SimpleCheckout' ) ) :

    class Veebiekspert_Checkout_SimpleCheckout
    {

        /**
         * API
         *
         * @var Veebiekspert_API
         */
        protected $_api;

        protected $_api_key;

        protected $_params;

        protected $_name = 'simple_checkout';

        /**
         * Consturctor
         *
         * @param Veebiekspert_API $api
         */
        public function __construct(Veebiekspert_API $api)
        {
            $veebiekspert_active_module = (array) get_option('veebiekspert_active_module');
            if (!in_array('simple_checkout', $veebiekspert_active_module)) {
                return false;
            }

            add_filter( 'woocommerce_ship_to_different_address_checked', '__return_false' );

            add_action('woocommerce_before_checkout_form', array($this, 'woocommerce_before_checkout_form'));
            add_action('woocommerce_after_checkout_form', array($this, 'woocommerce_after_checkout_form'));

            add_action('init', array($this, 'init'));
            add_filter( 'woocommerce_locate_template', array($this, 'edit_template'), 30, 3 );

            add_filter( 'woocommerce_default_address_fields' , array($this, 'filter_default_address_fields'), 50, 1 );
            add_filter( 'woocommerce_billing_fields', array($this, 'filter_billing_fields'), 50, 1 );
            add_filter( 'woocommerce_shipping_fields', array($this, 'filter_shipping_fields'), 50, 1 );

            add_action('wp_footer', array($this, 'billing_country_update_checkout'), 50);
            add_filter( 'default_checkout_billing_country', array($this, 'change_default_checkout_country'), 10, 1 );
            //add_filter( 'default_checkout_shipping_country', array($this, 'change_default_checkout_country'), 10, 1 );

            add_filter('woocommerce_package_rates', array($this, 'sort_and_reorder_shipping_methods'), 10, 2);
        }



        public function sort_and_reorder_shipping_methods($available_shipping_methods, $package)
        {
            // Arrange shipping methods as per your requirement
            $sort_order	= array(
                'eliides_smartpost'	=>	array(),
                'eliides_smartpost_courier'	=>	array(),
                'local_pickup'	=>	array(),
            );

            // unsetting all methods that needs to be sorted
            foreach($available_shipping_methods as $carrier_id => $carrier){
                $carrier_name	=	current(explode(":",$carrier_id));
                if(array_key_exists($carrier_name,$sort_order)){
                    $sort_order[$carrier_name][$carrier_id]	=		$available_shipping_methods[$carrier_id];
                    unset($available_shipping_methods[$carrier_id]);
                }
            }

            // adding methods again according to sort order array
            foreach($sort_order as $carriers){
                $available_shipping_methods	=	array_merge($available_shipping_methods,$carriers);
            }
            return $available_shipping_methods;
        }

        public function change_default_checkout_country($country) {
            if ($country) {
                return $country;
            }
            return 'EE';
        }

        public function init() {
            wp_register_style('eliides_simple_checkout_css', plugins_url('assets/simple-checkout.css',__FILE__ ));
            wp_enqueue_style('eliides_simple_checkout_css');
        }

        public function woocommerce_before_checkout_form() {
            echo '<div class="eliides-checkout-wrapper">';
        }

        public function woocommerce_after_checkout_form() {
            echo '</div>';
        }

        public function edit_template( $template, $template_name, $template_path ) {
            $basename = basename( $template );

            if (file_exists(trailingslashit( plugin_dir_path( __FILE__ ) ) . 'templates/' . $basename)) {
                $template = trailingslashit( plugin_dir_path( __FILE__ ) ) . 'templates/' . $basename;
            }
            return $template;
        }


        public function filter_default_address_fields($address_fields ) {
            if( ! is_checkout() ) return $address_fields;

            $key_fields = array('address_1','city','state','postcode');

            // Loop through each address fields (billing and shipping)
            foreach( $key_fields as $key_field )
                $address_fields[$key_field]['required'] = true;

            return $address_fields;

        }

        public function filter_billing_fields($billing_fields) {
            // Only on checkout page
            if( ! is_checkout() ) return $billing_fields;

            $simpleCheckoutOptions = get_option('veebiekspert_module_simple_checkout');

            unset($billing_fields['billing_company']);

            $billing_fields['billing_phone']['class'][] = 'form-row-first';
            $billing_fields['billing_email']['class'][] = 'form-row-last';

            $billing_fields['billing_email']['class'] = $this->remove_from_r($billing_fields['billing_email']['class'], 'form-row-wide');
            $billing_fields['billing_phone']['class'] = $this->remove_from_r($billing_fields['billing_phone']['class'], 'form-row-wide');

            $billing_fields['billing_country']['priority'] = 25;

            global $woocommerce;
            $chosen_methods = WC()->session->get( 'chosen_shipping_methods' );
            $chosen_shipping = $chosen_methods[0];
            $exp = explode(':', $chosen_shipping);

            if ($simpleCheckoutOptions['shipping'][$exp[0]] !== 'courier') {

                unset($billing_fields['shipping_address_1']);
                unset($billing_fields['shipping_address_2']);
                unset($billing_fields['shipping_state']);
                unset($billing_fields['shipping_city']);
                unset($billing_fields['billing_address_1']);
                unset($billing_fields['billing_address_2']);
                unset($billing_fields['billing_postcode']);
                unset($billing_fields['billing_state']);
                unset($billing_fields['billing_city']);
            }

            //unset($billing_fields['billing_company']);
            unset($billing_fields['billing_fax']);
            unset($billing_fields['billing_vatnr']);
            unset($billing_fields['billing_regnr']);

            return $billing_fields;
        }

        public function filter_shipping_fields($shipping_fields) {
            // Only on checkout page
            if( ! is_checkout() ) return $shipping_fields;

            unset($shipping_fields['shipping_country']);

            unset($shipping_fields['shipping_company']);
            unset($shipping_fields['shipping_fax']);

            unset($shipping_fields['shipping_regnr']);
            unset($shipping_fields['shipping_vatnr']);

            unset($shipping_fields['shipping_phone']);
            unset($shipping_fields['shipping_email']);

            unset($shipping_fields['shipping_first_name']);
            unset($shipping_fields['shipping_last_name']);

            unset($shipping_fields['shipping_address_1']);
            unset($shipping_fields['shipping_address_2']);
            unset($shipping_fields['shipping_state']);
            unset($shipping_fields['shipping_city']);
            unset($shipping_fields['shipping_postcode']);

            return $shipping_fields;
        }

        public function remove_from_r(&$arr, $value) {
            foreach ($arr as $k => $i) {
                if ($i == $value) {
                    unset($arr[$k]);
                }
            }
            return $arr;
        }

        public function billing_country_update_checkout() {
            ?>
            <script type="text/javascript">
                function addEliidesSimpleCheckoutLoader() {
                    jQuery('body').append('<div style="position: fixed; left: 0; top: 0; height: 100%; width: 100%; background: rgba(255,255,255,0.5); z-index: 999"></div>');
                }

            </script>
            <?php
        }

    }

endif;