<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

if ( ! class_exists( 'Veebiekspert_API' ) ) :

/**
 * Veebiekspert api client
 * 
 * @author Priit
 *
 */
class Veebiekspert_API
{
    
    /**
     * Api url
     * 
     * @var string
     */
    protected $url = 'https://www.e-liides.ee/api/';
    
    /**
     * Constructor
     */
    public function __construct() {
        if (getenv('APPLICATION_ENV')) {
            if (getenv('APPLICATION_ENV') == 'priit') {
                $this->url = 'http://prinxit.test/api/';
            }
        }
    }
    
    public static function getEnabledModules() {
        $url = 'https://www.e-liides.ee/et/index/my-modules';
        
        if (getenv('APPLICATION_ENV') == 'priit') {
            $url = 'http://prinxit.test/et/index/my-modules';
        }

        $response = wp_remote_get($url);
        return $response['body'];
    }
	
	public static function getIp() {
	    $url = 'https://www.e-liides.ee/et/index/ip';
        
        if (getenv('APPLICATION_ENV') == 'priit') {
            $url = 'http://prinxit.test/et/index/ip';
        }
        $response = wp_remote_get($url);
        return $response['body'];
	}
    
    /**
     * Send request to eliides api
     * 
     * @param string $type
     * @param string $method
     * @param array $filter
     * @return mixed
     */
    public function sendRequest($apiKey, $type, $method, $filter = array())
    {
        $post = array(
            'api_key' => $apiKey, 
            'filter' => $filter,
            'plugin_version' => ELIIDES_VERSION,
        );

        $response = wp_remote_post($this->url . $type . '/' . $method, [
            'body' => $post,
            'timeout' => 3600,
        ]);

        if ($response instanceof WP_Error) {
            return [
                'status' => 0,
                'data' => '',
            ];
        }

        $response = json_decode($response['body'], true);

        if (!is_array($response)) {
            $response = json_decode($response, true);
        }
        return $response;
    }
}


endif;