<?php

class WC_Integration_Eliides_Smartaccounts extends WC_Integration {


    public function __construct() {
        $this->id                 = 'smartaccounts';
        $this->method_title       = 'SmartAccounts';
        $this->method_description = null;

        $this->init_form_fields();
        $this->init_settings();

        add_action( 'woocommerce_update_options_integration_' .  $this->id, array( $this, 'process_admin_options' ) );
    }

    public function process_admin_options()
    {
        $this->init_settings();

        $post_data = $this->get_post_data();
        update_option('veebiekspert_module_smartaccounts_options', eliides_sanitize_text_or_array_field(eliides_arr_get($post_data, 'veebiekspert_module_smartaccounts_options')));

        $activeModules = (array) get_option('veebiekspert_active_module', []);
        $module = 'smartaccounts';

        if (!empty($post_data['is_module_active'])) {
            if (!in_array($module, $activeModules)) {
                $activeModules[] = $module;
                update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
            }
        }
        else {
            $key = array_search($module, $activeModules);
            if (false !== $key) {
                unset($activeModules[$key]);
                update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
            }
        }

    }

    public function admin_options() {
        parent::admin_options();
        $smartAccountOptions = (array) get_option('veebiekspert_module_smartaccounts_options');
        $taxes = array(
            0 => array(
                'label' => '0%',
                'rate' => 0,
            )
        );

        if (defined('WC_ABSPATH')) {

            $allShippingPackages = WC()->shipping()->get_shipping_methods();

            $zones = WC_Shipping_Zones::get_zones();
            foreach ($zones as $zone) {
                foreach ($zone['shipping_methods'] as $shipMethod) {
                    $shipObj = new stdClass();
                    $shipObj->id = $shipMethod->id . ':' . $shipMethod->instance_id;
                    $shipObj->title = $shipMethod->title;
                    $allShippingPackages[] = $shipObj;
                }
            }


            foreach (WC_Tax::get_rates() as $taxId => $tax) {
                $taxes[$taxId] = $tax;
            }

            if (class_exists('WC_Tax')) {
                if (method_exists('WC_Tax', 'get_tax_class_slugs')) {

                    $taxClasses = array_merge(array(''), WC_Tax::get_tax_class_slugs());

                    foreach ($taxClasses as $taxSlug) {
                        foreach (WC_Tax::get_rates_for_tax_class($taxSlug) as $taxId => $tax) {
                            $taxes[$taxId] = array(
                                'label' => implode(', ', array_filter(array($taxSlug, $tax->tax_rate_name, $tax->tax_rate_country))),
                                'rate' => $tax->tax_rate,
                            );
                        }

                    }

                }
            }

        }

        $veebiekspert_active_module = (array) get_option('veebiekspert_active_module');
        ?>
        <div class="veebiekspert-setting-block">
            <input type="hidden" name="is_module_active" value="0" />
            <h2><label><input type="checkbox" name="is_module_active"<?php if (in_array('smartaccounts', $veebiekspert_active_module)): ?> checked<?php endif; ?> value="1" /> Aktiivne</label></h2>

            <div class="settings-block-inner">

                <div class="ve-form-group">
                    <label>E-liides litsentsi võti</label>
                    <input type="text" id="veebiekspert_module_smartaccounts_api_key" name="veebiekspert_module_smartaccounts_options[api_key]" value="<?php echo esc_html(eliides_arr_get($smartAccountOptions, 'api_key')); ?>" />
                    <a href="https://www.e-liides.ee" target="_blank">Registreeri võti (7 päeva tasuta)</a>
                </div>

                <div class="ve-form-group">
                    <label>SmartAccounts API public key</label>
                    <input type="text" id="veebiekspert_module_smartaccounts_public_key" name="veebiekspert_module_smartaccounts_options[public_key]" value="<?php echo esc_html(eliides_arr_get($smartAccountOptions, 'public_key')); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>SmartAccounts API private key</label>
                    <input type="text" id="veebiekspert_module_smartaccounts_private_key" name="veebiekspert_module_smartaccounts_options[private_key]" value="<?php echo esc_html(eliides_arr_get($smartAccountOptions, 'private_key')); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Arve eesliide</label>
                    <input type="text" name="veebiekspert_module_smartaccounts_options[invoice_prefix]" value="<?php echo esc_html(eliides_arr_get($smartAccountOptions, ['invoice_prefix'], 'WP')); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Uue artikli tüüp</label>

                    <?php

                    $options = array(
                        'PRODUCT' => 'Toode',
                        'SERVICE' => 'Teenus',
                        'WH' => 'Laokaup',
                    );

                    $selected = isset($smartAccountOptions['invoice_row_type']) ? $smartAccountOptions['invoice_row_type'] : 'PRODUCT';
                    ?>

                    <select name="veebiekspert_module_smartaccounts_options[invoice_row_type]">
                        <?php foreach ($options as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="ve-form-group">
                    <label>Arve saatmise hetk</label>

                    <?php

                    $options = array(
                        'woocommerce_order_status_on-hold' => 'Ootel',
                        'woocommerce_order_status_processing' => 'Töötluses',
                        'woocommerce_order_status_completed' => 'Tellimus täidetud',
                    );

                    $selected = eliides_arr_get($smartAccountOptions, 'invoice_trigger', 'woocommerce_order_status_processing');
                    ?>

                    <select name="veebiekspert_module_smartaccounts_options[invoice_trigger]">
                        <?php foreach ($options as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="ve-form-group">
                    <label>Dokumendi tüüp</label>

                    <?php

                    $options = array(
                        'invoice' => 'Arve',
                        'order' => 'Tellimus',
                        'offer' => 'Pakkumine',
                    );

                    $selected = eliides_arr_get($smartAccountOptions, 'document_type', 'invoice');
                    ?>

                    <select name="veebiekspert_module_smartaccounts_options[document_type]">
                        <?php foreach ($options as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <?php
                $objects = Veebiekspert_Modules()->getSmartaccounts()->getObjects();
                ?>
                <div class="ve-form-group">
                    <label>Objekt arvel</label>

                    <?php
                    $selected = eliides_arr_get($smartAccountOptions, 'object');
                    ?>

                    <select name="veebiekspert_module_smartaccounts_options[object]">
                        <option value=""></option>
                        <?php foreach ($objects as $i): ?>
                            <option value="<?php echo esc_html($i['code']); ?>"<?php if ($i['code'] == $selected): ?> selected<?php endif; ?>><?php echo esc_html($i['name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <?php
                $warehouses = Veebiekspert_Modules()->getSmartaccounts()->getWarehouses();
                ?>
                <div class="ve-form-group">
                    <label>Ladu arvel</label>

                    <?php
                    $selected = eliides_arr_get($smartAccountOptions, 'warehouse');
                    ?>

                    <select name="veebiekspert_module_smartaccounts_options[warehouse]">
                        <option value="">Vaikimisi</option>
                        <?php foreach ($warehouses as $i): ?>
                            <option value="<?php echo esc_html($i['name']); ?>"<?php if ($i['name'] == $selected): ?> selected<?php endif; ?>><?php echo esc_html($i['name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <?php
                $yesNoOptions = array(
                    'no' => 'Ei saada SmartAccountsi PDF arvet e-mailile',
                    'yes' => 'Saada SmartAccountsi PDF arve e-mailile',
                );
                ?>

                <div class="ve-form-group">
                    <label>Lisa arve PDF e-mailiga kaasa kui tellimus on täidetud</label>
                    <select name="veebiekspert_module_smartaccounts_options[send_smartaccounts_pdf]">
                        <?php foreach ($yesNoOptions as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == eliides_arr_get($smartAccountOptions, ['send_smartaccounts_pdf'])): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="ve-form-group">
                    <span style="color: #cc0808; font-weight: bold;">Laoseisu uuendamiseks</span> tuleb külastada linki:<br />
                    <a href="<?php echo get_site_url(); ?>/?eliides_sync_smartaccounts" target="_blank"><?php echo get_site_url(); ?>/?eliides_sync_smartaccounts</a>
                </div>

                <?php
                $yesNoOptions = array(
                    'outofstock' => 'Laost otsas',
                    'onbackorder' => 'Järeltellimisel',
                );
                ?>

                <div class="ve-form-group">
                    <label>Laost otsas toodete olek</label>
                    <select name="veebiekspert_module_smartaccounts_options[zero_stock_status]">
                        <?php foreach ($yesNoOptions as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == eliides_arr_get($smartAccountOptions, ['zero_stock_status'])): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <?php if (defined('WC_ABSPATH')): ?>

                    <?php
                    $available_gateways = WC()->payment_gateways->payment_gateways();
                    $smartAccountPaymentMethods = Veebiekspert_Modules()->getSmartaccounts()->getPaymentMethods();
                    if (!$smartAccountPaymentMethods) {
                        $smartAccountPaymentMethods = array();
                    }

                    ?>

                    <table class="widefat fixed" style="margin-top: 20px;">
                        <thead>
                        <tr>
                            <th>E-poe makseviis</th>
                            <th>SmartAccountsi konto</th>
                            <th>Laekumine lisatakse SmartAccountsi</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($available_gateways as $methodName => $method): ?>
                            <tr>
                                <td><?php echo @esc_html($method->title); ?></td>
                                <td>
                                    <select name="veebiekspert_module_smartaccounts_options[payment_methods][<?php echo @esc_html($methodName); ?>]">
                                        <?php foreach ($smartAccountPaymentMethods as $smartAccountPaymentMethod): ?>
                                            <option value="<?php echo $smartAccountPaymentMethod['account']; ?>"<?php if (eliides_arr_get($smartAccountOptions, ['payment_methods', $methodName]) == $smartAccountPaymentMethod['account']): ?> selected<?php endif; ?>><?php echo @esc_html($smartAccountPaymentMethod['name'] . ' (' . $smartAccountPaymentMethod['account'] . ')'); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                                <td>
                                    <select name="veebiekspert_module_smartaccounts_options[disable_income][<?php echo @esc_html($methodName); ?>]">
                                        <option value="yes"<?php if (eliides_arr_get($smartAccountOptions, ['disable_income',$methodName]) == 'yes'): ?> selected<?php endif; ?>>Jah</option>
                                        <option value="no"<?php if (eliides_arr_get($smartAccountOptions, ['disable_income',$methodName]) == 'no'): ?> selected<?php endif; ?>>Ei</option>
                                    </select>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>

                    <?php

                    if (!$smartAccountTaxes = Veebiekspert_Modules()->getSmartaccounts()->getTaxes()) {
                        $smartAccountTaxes = [];
                    }

                    if (!$smartAccountTaxAccounts = Veebiekspert_Modules()->getSmartaccounts()->getAccounts()) {
                        $smartAccountTaxAccounts = [];
                    }
                    ?>

                    <table class="widefat fixed" style="margin-top: 20px;">
                        <thead>
                        <tr>
                            <th>Maksu ID</th>
                            <th>Maksu %</th>
                            <th>Nimetus</th>
                            <th>Konto</th>
                            <th>Vaste</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($taxes as $taxId => $tax): ?>
                            <tr>
                                <td><?php echo $taxId; ?></td>
                                <td><?php echo $tax['rate']; ?></td>
                                <td><?php echo @esc_html($tax['label']); ?></td>
                                <td>
                                    <select name="veebiekspert_module_smartaccounts_options[tax_accounts][<?php echo $taxId; ?>]">
                                        <option value="">Vaikimisi maksutüübi järgi</option>
                                        <?php foreach ($smartAccountTaxAccounts as $smartAccountTaxAccount): ?>
                                            <option value="<?php echo $smartAccountTaxAccount['code']; ?>"<?php if (eliides_arr_get($smartAccountOptions, ['tax_accounts', $taxId]) == $smartAccountTaxAccount['code']): ?> selected<?php endif; ?>><?php echo @esc_html($smartAccountTaxAccount['code'] . ' - ' . $smartAccountTaxAccount['descriptionEt']); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                                <td>
                                    <select name="veebiekspert_module_smartaccounts_options[taxes][<?php echo $taxId; ?>]">
                                        <?php foreach ($smartAccountTaxes as $smartAccountTax): ?>
                                            <option value="<?php echo $smartAccountTax['vatPc']; ?>"<?php if (eliides_arr_get($smartAccountOptions, ['taxes', $taxId]) == $smartAccountTax['vatPc']): ?> selected<?php endif; ?>><?php echo @esc_html($smartAccountTax['descriptionEt'] . ' (' . $smartAccountTax['pc'] . '%)'); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        <tr>
                            <th colspan="3">EU VAT koodiga tellimus</th>
                            <td>
                                <select name="veebiekspert_module_smartaccounts_options[tax_accounts][eu_vat_code]">
                                    <option value="">Vaikimisi maksutüübi järgi</option>
                                    <?php foreach ($smartAccountTaxAccounts as $smartAccountTaxAccount): ?>
                                        <option value="<?php echo $smartAccountTaxAccount['code']; ?>"<?php if (eliides_arr_get($smartAccountOptions, ['tax_accounts', 'eu_vat_code']) == $smartAccountTaxAccount['code']): ?> selected<?php endif; ?>><?php echo @esc_html($smartAccountTaxAccount['code'] . ' - ' . $smartAccountTaxAccount['descriptionEt']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                            <td>
                                <select name="veebiekspert_module_smartaccounts_options[taxes][eu_vat_code]">
                                    <?php foreach ($smartAccountTaxes as $smartAccountTax): ?>
                                        <option value="<?php echo $smartAccountTax['vatPc']; ?>"<?php if (eliides_arr_get($smartAccountOptions, ['taxes', 'eu_vat_code']) == $smartAccountTax['vatPc']): ?> selected<?php endif; ?>><?php echo @esc_html($smartAccountTax['descriptionEt'] . ' (' . $smartAccountTax['pc'] . '%)'); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <th colspan="3">Puuduva maksu vaste (peaks olema 0%)</th>
                            <td>
                                <select name="veebiekspert_module_smartaccounts_options[tax_accounts][missing_vat]">
                                    <option value="">Vaikimisi maksutüübi järgi</option>
                                    <?php foreach ($smartAccountTaxAccounts as $smartAccountTaxAccount): ?>
                                        <option value="<?php echo $smartAccountTaxAccount['code']; ?>"<?php if (eliides_arr_get($smartAccountOptions, ['tax_accounts', 'missing_vat']) == $smartAccountTaxAccount['code']): ?> selected<?php endif; ?>><?php echo @esc_html($smartAccountTaxAccount['code'] . ' - ' . $smartAccountTaxAccount['descriptionEt']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                            <td>
                                <select name="veebiekspert_module_smartaccounts_options[taxes][missing_vat]">
                                    <?php foreach ($smartAccountTaxes as $smartAccountTax): ?>
                                        <option value="<?php echo $smartAccountTax['vatPc']; ?>"<?php if (eliides_arr_get($smartAccountOptions, ['taxes', 'missing_vat']) == $smartAccountTax['vatPc']): ?> selected<?php endif; ?>><?php echo @esc_html($smartAccountTax['descriptionEt'] . ' (' . $smartAccountTax['pc'] . '%)'); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                        </tr>
                        </tbody>
                    </table>

                    <table class="widefat fixed" style="margin-top: 20px;">
                        <thead>
                        <tr>
                            <th>Tarneviisi ID</th>
                            <th>Nimetus</th>
                            <th>Artikli kood</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($allShippingPackages as $package): ?>
                            <?php
                            if (empty($package->title)) {
                                continue;
                            }
                            $shippingArticle = '';
                            if (isset($smartAccountOptions['shipping_articles'][$package->id])) {
                                $shippingArticle = $smartAccountOptions['shipping_articles'][$package->id];
                            }
                            ?>
                            <tr>
                                <td><?php echo $package->id; ?></td>
                                <td><?php echo esc_html($package->title); ?></td>
                                <td>
                                    <input type="text" name="veebiekspert_module_smartaccounts_options[shipping_articles][<?php echo $package->id; ?>]" value="<?php echo esc_html($shippingArticle); ?>" />
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>

                <?php else: ?>

                    Aktiveeri Woocommerce moodul, et maksude andmed seadistada

                <?php endif; ?>

            </div>

        </div>

        <?php
    }
}
