<?php

class WC_Integration_Eliides_Simplbooks extends WC_Integration {


    public function __construct() {
        $this->id                 = 'simplbooks';
        $this->method_title       = 'Simplbooks';
        $this->method_description = null;

        $this->init_form_fields();
        $this->init_settings();

        add_action( 'woocommerce_update_options_integration_' .  $this->id, array( $this, 'process_admin_options' ) );
    }

    public function process_admin_options()
    {
        $this->init_settings();

        $post_data = $this->get_post_data();
        update_option('veebiekspert_module_simplbooks_options', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_simplbooks_options']));
        update_option('veebiekspert_module_simplbooks_api_key', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_simplbooks_api_key']));
        update_option('veebiekspert_module_simplbooks_internal_api_key', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_simplbooks_internal_api_key']));
        update_option('veebiekspert_module_simplbooks_internal_client_code', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_simplbooks_internal_client_code']));
        update_option('veebiekspert_module_simplbooks_trigger', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_simplbooks_trigger']));

        $activeModules = (array) get_option('veebiekspert_active_module', []);
        $module = 'simplbooks';

        if (!empty($post_data['is_module_active'])) {
            if (!in_array($module, $activeModules)) {
                $activeModules[] = $module;
                update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
            }
        }
        else {
            $key = array_search($module, $activeModules);
            if (false !== $key) {
                unset($activeModules[$key]);
                update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
            }
        }

    }

    public function admin_options() {
        parent::admin_options();
        $simplbooksOptions = (array) get_option('veebiekspert_module_simplbooks_options');
        $warehouses = Veebiekspert_Modules()->getSimplbooks()->getWarehouses();
        $countries = Veebiekspert_Modules()->getCountries();
        $taxes = array(
            0 => array(
                'label' => '0%',
                'rate' => 0,
            )
        );

        if (defined('WC_ABSPATH')) {

            $allShippingPackages = WC()->shipping()->get_shipping_methods();

            $zones = WC_Shipping_Zones::get_zones();
            foreach ($zones as $zone) {
                foreach ($zone['shipping_methods'] as $shipMethod) {
                    $shipObj = new stdClass();
                    $shipObj->id = $shipMethod->id . ':' . $shipMethod->instance_id;
                    $shipObj->title = $shipMethod->title;
                    $allShippingPackages[] = $shipObj;
                }
            }


            foreach (WC_Tax::get_rates() as $taxId => $tax) {
                $taxes[$taxId] = $tax;
            }

            if (class_exists('WC_Tax')) {
                if (method_exists('WC_Tax', 'get_tax_class_slugs')) {

                    $taxClasses = array_merge(array(''), WC_Tax::get_tax_class_slugs());

                    foreach ($taxClasses as $taxSlug) {
                        foreach (WC_Tax::get_rates_for_tax_class($taxSlug) as $taxId => $tax) {
                            $taxes[$taxId] = array(
                                'label' => implode(', ', array_filter(array($taxSlug, $tax->tax_rate_name, $tax->tax_rate_country))),
                                'rate' => $tax->tax_rate,
                            );
                        }

                    }

                }
            }

        }

        $veebiekspert_active_module = (array) get_option('veebiekspert_active_module');
        ?>
        <div class="veebiekspert-setting-block">

            <input type="hidden" name="is_module_active" value="0" />
            <h2><label><input type="checkbox" name="is_module_active"<?php if (in_array('simplbooks', $veebiekspert_active_module)): ?> checked<?php endif; ?> value="1" /> Aktiivne</label></h2>

            <div class="settings-block-inner">

                <div class="ve-form-group">
                    <label>E-liides litsentsi võti</label>
                    <input type="text" id="veebiekspert_module_simplbooks_api_key" name="veebiekspert_module_simplbooks_api_key" value="<?php echo get_option('veebiekspert_module_simplbooks_api_key'); ?>" />
                    <a href="https://www.e-liides.ee" target="_blank">Registreeri võti (7 päeva tasuta)</a>
                </div>

                <div class="ve-form-group">
                    <label>SimplBooks ettevõtte kood</label>
                    <input type="text" id="veebiekspert_module_simplbooks_internal_client_code" name="veebiekspert_module_simplbooks_internal_client_code" value="<?php echo get_option('veebiekspert_module_simplbooks_internal_client_code'); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>SimplBooks API võti</label>
                    <input type="text" id="veebiekspert_module_simplbooks_internal_api_key" name="veebiekspert_module_simplbooks_internal_api_key" value="<?php echo get_option('veebiekspert_module_simplbooks_internal_api_key'); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Arve saatmise hetk</label>

                    <?php

                    $options = array(
                        'woocommerce_order_status_on-hold' => 'Ootel',
                        'woocommerce_order_status_processing' => 'Töötluses',
                        'woocommerce_order_status_completed' => 'Tellimus täidetud',
                    );

                    $selected = get_option('veebiekspert_module_simplbooks_trigger', 'woocommerce_order_status_completed');
                    ?>

                    <select name="veebiekspert_module_simplbooks_trigger">
                        <?php foreach ($options as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="ve-form-group">
                    <label>Põhiladu</label>

                    <?php
                    $selected = eliides_arr_get($simplbooksOptions, ['warehouse_id']);
                    ?>

                    <select name="veebiekspert_module_simplbooks_options[warehouse_id]">
                        <option value=""></option>
                        <?php foreach ($warehouses as $i): ?>
                            <option value="<?php echo $i['id']; ?>"<?php if ($i['id'] == $selected): ?> selected<?php endif; ?>><?php echo esc_html($i['name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>


                <?php if (defined('WC_ABSPATH')): ?>

                    <?php
                    $available_gateways = WC()->payment_gateways->payment_gateways();
                    if (!$simplbooksPaymentMethods = Veebiekspert_Modules()->getSimplbooks()->getPaymentMethods()) {
                        $simplbooksPaymentMethods = [];
                    }
                    $simplbooksPaymentSettings = eliides_arr_get($simplbooksOptions, 'payment_methods');

                    ?>

                    <table class="widefat fixed" style="margin-top: 20px;">
                        <thead>
                        <tr>
                            <th>E-poe makseviis</th>
                            <th>SimplBooks konto</th>
                            <th>Laekumine lisatakse SimplBooksi</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($available_gateways as $methodName => $method): ?>
                            <tr>
                                <td><?php echo @esc_html($method->title); ?></td>
                                <td>
                                    <select name="veebiekspert_module_simplbooks_options[payment_methods][<?php echo @esc_html($methodName); ?>]">
                                        <?php foreach ($simplbooksPaymentMethods as $method): ?>
                                            <option value="<?php echo $method['id']; ?>"<?php if (isset($simplbooksPaymentSettings[$methodName]) && $method['id'] == $simplbooksPaymentSettings[$methodName]): ?> selected<?php endif; ?>><?php echo @esc_html($method['account_name']); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                                <td>
                                    <select name="veebiekspert_module_simplbooks_options[disable_income][<?php echo @esc_html($methodName); ?>]">
                                        <option value="yes"<?php if (isset($simplbooksOptions['disable_income']) && $simplbooksOptions['disable_income'][$methodName] == 'yes'): ?> selected<?php endif; ?>>Jah</option>
                                        <option value="no"<?php if (isset($simplbooksOptions['disable_income']) && $simplbooksOptions['disable_income'][$methodName] == 'no'): ?> selected<?php endif; ?>>Ei</option>
                                    </select>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>

                <?php else: ?>

                    Aktiveeri Woocommerce moodul, et maksude andmed seadistada

                <?php endif; ?>

            </div>

        </div>

        <?php
    }
}