<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

if (!class_exists('Veebiekspert_Accouting_Merit')):


class Veebiekspert_Accouting_Merit {

    /**
     * API
     *
     * @var Veebiekspert_API
     */
    protected $_api;

    protected $_api_key;

    protected $_options = array();

    protected $_name = 'merit';

    const SEND_INVOICE = 'eliides_merit_send';

    /**
     * Consturctor
     *
     * @param Veebiekspert_API $api
     */
    public function __construct(Veebiekspert_API $api) {

        $this->_api = $api;
        $this->_api_key = get_option('veebiekspert_module_merit_api_key');

        add_action( 'plugins_loaded', function() {
            if ( class_exists( 'WC_Integration' ) ) {
                include_once( VE_ABS_PATH . 'accounting/merit/merit-integration.php' );
                add_filter( 'woocommerce_integrations', function($integrations) {
                    $integrations[] = 'WC_Integration_Eliides_Merit';
                    return $integrations;
                });
            }
        });

        $veebiekspert_active_module = get_option('veebiekspert_active_module');

        if (!in_array('merit', (array) $veebiekspert_active_module)) {
            return;
        }

        $this->_options = get_option('veebiekspert_module_merit_options');

        add_filter( 'woocommerce_email_attachments', array($this, 'woocommerce_email_attachments'), 10, 3 );


        //add_filter('woocommerce_admin_order_actions', array($this, 'add_pdf_invoice_link'), 10, 2);


        add_action('wp_ajax_' . self::SEND_INVOICE, array($this, 'send_invoice_ajax'));

        if ($this->_api_key) {
            add_filter('bulk_actions-woocommerce_page_wc-orders', [$this, 'hpos_bulk_action'], 20, 1);
            add_action('init', array($this, 'do_hpos_bulk_action'));

            add_filter('woocommerce_admin_order_actions', array($this, 'show_if_invoice_sent'), 10, 2);
            add_action('admin_footer', array($this, 'custom_bulk_admin_footer'));

            add_action('load-edit.php', array($this, 'bulk_action'));

            add_action('woocommerce_order_status_on-hold', array($this, 'check_if_send_invoice'));
            add_action('woocommerce_order_status_processing', array($this, 'check_if_send_invoice'));
            add_action('woocommerce_order_status_completed', array($this, 'check_if_send_invoice'));

            if (isset($_GET['eliides_sync_merit'])) {
                add_action('init', array($this, 'sync_stock'));
            }

            if (_wp_array_get($this->_options, ['sync_montonio_merit_reference_nr']) !== 'no') {
                add_filter('montonio_payments_before_payment_data_submission', [$this, 'montonio_before_data_submission'], 10, 2);
                add_filter('montonio_split_before_payment_data_submission', [$this, 'montonio_before_data_submission'], 10, 2);
                add_filter('montonio_card_payments_before_payment_data_submission', [$this, 'montonio_before_data_submission'], 10, 2);
                add_filter('wc_montonio_before_order_data_submission', [$this, 'wc_montonio_before_order_data_submission'], 10, 2);

                add_filter('merit_data_before_send', [$this, 'merit_data_before_send'], 10, 2);
            }
        }

    }

    public function merit_data_before_send($data, $order_id)
    {
        $data['reference_nr'] = $this->generate_reference_number($order_id);
        return $data;
    }

    public function montonio_before_data_submission( $payment_data, $order ) {
        $payment_data['payment_information_structured'] = $this->generate_reference_number($order->get_id());
        return $payment_data;
    }

    public function wc_montonio_before_order_data_submission( $payment_data, $order ) {
        $payment_data['merchantReferenceDisplay'] = $this->generate_reference_number($order->get_id());
        $payment_data['payment']['methodOptions']['paymentReference'] = $this->generate_reference_number($order->get_id());
        return $payment_data;
    }

    private function generate_reference_number($nr){
        $nr = (string)$nr;
        $kaal = array(7,3,1);
        $sl = $st = strlen($nr);
        $total = 0;
        while($sl > 0 and substr($nr, --$sl, 1) >='0'){
            $total += substr($nr, ($st-1)-$sl, 1)*$kaal[($sl%3)];
        }
        $kontrollnr = ((ceil(($total/10))*10)-$total);
        return $nr.$kontrollnr;
    }

    public function woocommerce_email_attachments ( $attachments , $email_id, $order  ) {
        if ( ! is_a( $order, 'WC_Order' ) || ! isset( $email_id ) ) {
            return $attachments;
        }

        if (eliides_arr_get($this->_options, 'send_merit_pdf') !== 'yes') {
            return $attachments;
        }

        if( $email_id === 'customer_completed_order' ){
            if ($base64Pdf = $this->getInvoicePDF($order->get_id())) {

                $dest = VE_ABS_PATH . 'tmp/';
                if (!file_exists($dest)) {
                    mkdir($dest);
                }
                $dest .= 'merit/';
                if (!file_exists($dest)) {
                    mkdir($dest);
                }

                $dest .= $order->get_id() . '_arve.pdf';


                file_put_contents($dest, base64_decode($base64Pdf));

                $attachments[] = $dest;
            }
        }

        return $attachments;
    }

    public function check_if_send_invoice($order_id) {
        $trigger = get_option('veebiekspert_module_merit_trigger');

        if ($order = wc_get_order($order_id)) {

            if ($trigger == 'woocommerce_order_status_on-hold') {

                if ($order->has_status(array('on-hold', 'processing', 'completed'))) {
                    $this->send_invoice($order_id);
                }
            }
            elseif ($trigger == 'woocommerce_order_status_processing') {

                if ($order->has_status(array('processing', 'completed'))) {
                    $this->send_invoice($order_id);
                }
            }
            elseif ($trigger == 'woocommerce_order_status_completed') {

                if ($order->has_status(array('completed'))) {
                    $this->send_invoice($order_id);
                }
            }

        }

    }

    public function sync_stock() {

        set_time_limit(0);
        global $sitepress;

        $products = $this->getProducts();

        $outofstockStatus = $this->_options['zero_stock_status'];
        if (empty($outofstockStatus)) {
            $outofstockStatus = 'outofstock';
        }

        foreach ($products as $product) {

            try {

                $sku = $product['Code'];

                if (empty($sku)) {
                    continue;
                }

                $name = $product['Name'];
                $qty = $product['InventoryQty'];
                $price = $product['SalesPrice'];

                $productId = wc_get_product_id_by_sku($sku);

                $qty = apply_filters('veebiekspert_merit_stock_qty', $product['InventoryQty'], $productId);

                if (empty($productId)) {
                    continue;
                }

                $wc_product = wc_get_product($productId);

                if (empty($wc_product)) {
                    continue;
                }

                $discountPrc = $product['DiscountPct'];

                if ($this->_options['allow_price_update'] == 'yes') {
                    $wc_product->set_regular_price($price);

                    if (eliides_arr_get($this->_options, 'allow_sale_price_update') == 'yes') {
                        if ($discountPrc > 0) {
                            $wc_product->set_sale_price($price - ($discountPrc * $price / 100));
                        } else {
                            $wc_product->set_sale_price($price);
                        }
                    } else {
                        if ($discountPrice = get_post_meta($productId, '_sale_price', true)) {
                            $wc_product->set_sale_price($discountPrice);
                        } else {
                            $wc_product->set_sale_price($price);
                        }
                    }

                }

                if ($this->_options['allow_stock_update'] !== 'no') {

                    $wc_product->set_stock_quantity($qty);

                    if ($qty > 0) {
                        $wc_product->set_stock_status('instock');
                    } else {
                        if ($wc_product->managing_stock()) {
                            $wc_product->set_stock_status($outofstockStatus);
                        } else {
                            $wc_product->set_stock_status('instock');
                        }

                    }

                }

                $wc_product->save();

                $productIds = $this->getProductIdsBySku($sku);

                foreach ($productIds as $productId2) {
                    $wc_product2 = wc_get_product($productId2);

                    if (empty($wc_product2)) {
                        continue;
                    }

                    if ($this->_options['allow_price_update'] == 'yes') {
                        $wc_product2->set_regular_price($price);

                        if (eliides_arr_get($this->_options, 'allow_sale_price_update') == 'yes') {
                            if ($discountPrc > 0) {
                                $wc_product2->set_sale_price($price - ($discountPrc * $price / 100));
                            } else {
                                $wc_product2->set_sale_price($price);
                            }
                        } else {
                            if ($discountPrice = get_post_meta($productId, '_sale_price', true)) {
                                $wc_product2->set_sale_price($discountPrice);
                            } else {
                                $wc_product2->set_sale_price($price);
                            }
                        }

                    }

                    if ($this->_options['allow_stock_update'] !== 'no') {

                        $wc_product2->set_stock_quantity($qty);

                        if ($qty > 0) {
                            $wc_product2->set_stock_status('instock');
                        } else {
                            if ($wc_product2->managing_stock()) {
                                $wc_product2->set_stock_status($outofstockStatus);
                            } else {
                                $wc_product2->set_stock_status('instock');
                            }
                        }

                    }

                    $wc_product2->save();
                }

                if ($sitepress) {

                    $trid = $sitepress->get_element_trid($productId, 'post_product');
                    $translations = $sitepress->get_element_translations($trid, 'post_product');

                    foreach ($translations as $trLang => $translation) {
                        $post_id = $translation->element_id;

                        $wc_product = wc_get_product($post_id);

                        if (empty($wc_product)) {
                            continue;
                        }

                        $discountPrc = $product['DiscountPct'];

                        if ($this->_options['allow_price_update'] == 'yes') {
                            $wc_product->set_regular_price($price);

                            if (eliides_arr_get($this->_options, 'allow_sale_price_update') == 'yes') {
                                if ($discountPrc > 0) {
                                    $wc_product->set_sale_price($price - ($discountPrc * $price / 100));
                                } else {
                                    $wc_product->set_sale_price($price);
                                }
                            } else {
                                if ($discountPrice = get_post_meta($productId, '_sale_price', true)) {
                                    $wc_product->set_sale_price($discountPrice);
                                } else {
                                    $wc_product->set_sale_price($price);
                                }
                            }

                        }

                        if ($this->_options['allow_stock_update'] !== 'no') {

                            $wc_product->set_stock_quantity($qty);

                            if ($qty > 0) {
                                $wc_product->set_stock_status('instock');
                            } else {
                                if ($wc_product->managing_stock()) {
                                    $wc_product->set_stock_status($outofstockStatus);
                                } else {
                                    $wc_product->set_stock_status('instock');
                                }
                            }

                        }

                        $wc_product->save();


                    }
                }
            }
            catch (\Exception $e) {

            }



        }
        echo 'done';
        exit;
    }

    public function do_hpos_bulk_action()
    {
        if (!isset($_REQUEST['action2'])) {
            return;
        }
        if (!in_array($_REQUEST['action2'], ['merit_bulk_send', 'merit_bulk_delete'])) {
            return;
        }
        $post_ids = array_map('intval', (array) $_REQUEST['id']);

        foreach ($post_ids as $order_id) {
            if ($_REQUEST['action2'] == 'merit_bulk_send') {
                $this->send_invoice($order_id);
            }

            if ($_REQUEST['action2'] == 'merit_bulk_delete') {
                $this->delete_invoice($order_id);
            }
        }
    }

    public function hpos_bulk_action($actions) {
        $actions['merit_bulk_send'] = __('Saada arve Merit Aktiva serverisse', ELIIDES_TD);
        $actions['merit_bulk_delete'] = __('Kustuta arve Merit Aktivast', ELIIDES_TD);
        return $actions;
    }

    public function bulk_action() {
        $wp_list_table = _get_list_table( 'WP_Posts_List_Table' );
        $action        = $wp_list_table->current_action();

        if ($action !== 'eliide_merit_send_bulk' && $action !== 'eliides_merit_delete_bulk') {
            return false;
        }

        $post_ids = array_map( 'absint', (array) $_REQUEST['post'] );

        foreach ($post_ids as $order_id) {
            if ($action == 'eliide_merit_send_bulk') {
                $this->send_invoice($order_id);
            }

            if ($action == 'eliides_merit_delete_bulk') {
                $this->delete_invoice($order_id);
            }
        }
    }

    public function custom_bulk_admin_footer() {
        global $post_type;
         if($post_type == 'shop_order') {
         ?>
         <script type="text/javascript">
         jQuery(document).ready(function() {
             jQuery('<option>').val('eliide_merit_send_bulk').text('<?php echo esc_html(__('Saada arve Merit Aktiva serverisse', ELIIDES_TD)); ?>').appendTo('select[name="action"]');
             jQuery('<option>').val('eliides_merit_delete_bulk').text('<?php echo esc_html(__('Kustuta arve Merit Aktivast', ELIIDES_TD)); ?>').appendTo('select[name="action"]');
             jQuery('<option>').val('eliide_merit_send_bulk').text('<?php echo esc_html(__('Saada arve Merit Aktiva serverisse', ELIIDES_TD)); ?>').appendTo('select[name="action2"]');
             jQuery('<option>').val('eliides_merit_delete_bulk').text('<?php echo esc_html(__('Kustuta arve Merit Aktivast', ELIIDES_TD)); ?>').appendTo('select[name="action2"]');
         });
         </script>
         <?php
         }
    }

    public function send_invoice_ajax() {
        $order_id = absint($_GET['order_id']);

        $this->send_invoice($order_id);

        wp_safe_redirect(wp_get_referer() ? wp_get_referer() : admin_url('edit.php?post_type=shop_order') );
        exit;
    }

    public function show_if_invoice_sent($actions, $order) {

        if (!$order->get_meta('merit_invoice_id')) {

            $paymentType = $order->get_payment_method();

            $disabledPaymentMethods = (array) apply_filters('eliides_accounting_disabled_methods_' . self::SEND_INVOICE, array());

            if (!in_array($paymentType, $disabledPaymentMethods)) {
                $actions[self::SEND_INVOICE] = array(
                    'action' => self::SEND_INVOICE,
                    'url' => wp_nonce_url(admin_url('admin-ajax.php?action=' . self::SEND_INVOICE . '&order_id=' . $order->get_id()), 'eliides-merit-send'),
                    'name' => __('Saada arve Merit Aktiva serverisse', ELIIDES_TD)
                );
            }

        }
        return $actions;
    }

    public function delete_invoice($order_id) {
        $order = wc_get_order($order_id);
        if (!$invoiceData = $order->get_meta('merit_invoice_id')) {
            return false;
        }

        if (isset($invoiceData['InvoiceId']) && !empty($invoiceData['InvoiceId'])) {
            $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'delete-invoice', array(
                'software' => 'merit',
                'software_api_id' => get_option('veebiekspert_module_merit_internal_app_id'),
                'software_api_key' => get_option('veebiekspert_module_merit_internal_app_key'),
                'invoice_id' => $invoiceData['InvoiceId'],
            ));

            if ($res['status'] > 0) {
                delete_post_meta($order_id, 'merit_invoice_id');
            }
        }
    }

    public function send_invoice($order_id) {
        $order = wc_get_order($order_id);

        $paymentType = $order->get_payment_method();

        if ($order->get_meta('merit_invoice_id')) {
            return false;
        }

        $meritOptions = get_option('veebiekspert_module_merit_options');

        if (_wp_array_get($meritOptions, ['send_zero_price_invoices']) == 'no' && $order->get_total() == 0) {
            return false;
        }

        $disabledPaymentMethods = (array) apply_filters('eliides_accounting_disabled_methods_' . self::SEND_INVOICE, array());

        if (in_array($paymentType, $disabledPaymentMethods)) {
            return false;
        }

        $hasEUVat = false;

        $vatNr = '';

        if ($order->get_meta('_vat_number')) {
            $hasEUVat = true;
            $vatNr = $order->get_meta('_vat_number');
        }

        if ($order->get_meta('vat_number')) {
            $hasEUVat = true;
            $vatNr = $order->get_meta('vat_number');
        }

        if ($vatCompanyAc = $order->get_meta('company_kmkr')) {
            $vatNr = $vatCompanyAc;
        }
        if ($vatBillingAc = $order->get_meta('_billing_eu_vat_number')) {
            $hasEUVat = true;
            if (is_array($vatBillingAc)) {
                $vatNr = array_shift($vatBillingAc);
            }
            else {
                $vatNr = $vatBillingAc;
            }
        }
        if ($vatBillingAc = $order->get_meta('_billing_vat')) {
            $hasEUVat = true;
        }
        if ($vatBillingAc = $order->get_meta('_billing_vat_number')) {
            $hasEUVat = true;
            if (is_array($vatBillingAc)) {
                $vatNr = array_shift($vatBillingAc);
            }
            else {
                $vatNr = $vatBillingAc;
            }
        }

        if ($order->get_meta('is_vat_exempt') == 'no') {
            $hasEUVat = false;
        }

        $firstname = $order->get_billing_first_name();
        $lastname = $order->get_billing_last_name();


        if (!empty($order->get_shipping_first_name()) && !empty($order->get_shipping_last_name())) {
            $firstname = $order->get_shipping_first_name();
            $lastname = $order->get_shipping_last_name();
        }

        $billTo = $company = trim(implode(' ', array($firstname, $lastname)));

        $isCompany = 0;

        if ($order->get_billing_company()) {
            $company = $order->get_billing_company();
            $isCompany = 1;
        }

        $footerComment = array();
        $headerComment = array();

        $countryCode = strtoupper(empty($order->get_billing_country()) ? 'EE' : $order->get_billing_country());

        $department = '';

        if (isset($meritOptions['departments'][$countryCode])) {
            $department = $meritOptions['departments'][$countryCode];
        }
        else if (!empty(eliides_arr_get($meritOptions, ['default_department']))) {
            $department = eliides_arr_get($meritOptions, ['default_department']);
        }

        $invoiceNr = eliides_arr_get($meritOptions, ['invoice_prefix'], 'WP') . $order->get_order_number();

        if (function_exists('wcpdf_get_invoice')) {
            if ( $invoice = wcpdf_get_invoice( $order ) ) {
                $wcpdfInvoiceNr = (string) $invoice->get_number();
                if (!empty($wcpdfInvoiceNr)) {
                    $invoiceNr = $wcpdfInvoiceNr;
                }
            }
        }

        $data = array(
            'invoice_no' => apply_filters('eliides_merit_invoice_no', $invoiceNr, $order_id),
            'date' => $order->get_date_created() ? $order->get_date_created()->date_i18n() : date('Y-m-d'),
            'currency_code' => $order->get_currency(),
            'project' => $meritOptions['project'],
            'department_code' => $department,
            'footer_commment' => '',
            'header_commment' => '',
            'total' => $order->get_total(),
            'customer' => array(
                'name' => $company,
                'country_code' => empty($countryCode) ? 'EE' : $countryCode,
                'is_private' => $isCompany,
                'address' => implode(' ', array_filter(array($order->get_billing_address_1(), $order->get_billing_address_2()))),
                'city' => $order->get_billing_city(),
                'country' => $order->get_billing_country(),
                'postal_code' => $order->get_billing_postcode(),
                'phone' => $order->get_billing_phone(),
                'email' => $order->get_billing_email(),
                'vat_reg_no' => $vatNr,
                'reg_no' => $order->get_meta('company_code'),
            ),
            'rows' => array()
        );

        if ($paymentDays = _wp_array_get($this->_options, ['payment_days'])) {
            $data['deadline'] = date('Y-m-d', strtotime($data['date'] . ' + ' . $paymentDays . ' days'));
        }

        if (eliides_arr_get($meritOptions, ['invoice_lang'])) {
            $data['customer']['invoice_lang'] = eliides_arr_get($meritOptions, ['invoice_lang']);
        }

        $isDisabledMethod = false;

        if (isset($meritOptions['disable_income'][$paymentType]) && $meritOptions['disable_income'][$paymentType] == 'no') {
            $isDisabledMethod = true;
        }

        if ($order->is_paid() && $isDisabledMethod == false) {

            $meritPaymentSettings = get_option('veebiekspert_module_merit_payment_methods', []);

            if (isset($meritPaymentSettings[$paymentType])) {

                $meritPaymentMethods = $this->getPaymentMethods();

                $data['payment'] = array(
                    'sum' => $order->get_total(),
                    'account' => $meritPaymentMethods[$meritPaymentSettings[$paymentType]]
                );
            }

        }

        $meritTaxSettings = get_option('veebiekspert_module_merit_taxes', []);

        foreach ($order->get_items( 'line_item' ) as $item_id => $item ) {

            $name = $item->get_name();

            $product_id = null;

            if ($item['variation_id']) {
                $product = wc_get_product($item['variation_id']);
                $product_id = $item['variation_id'];
            }
            else {
                $product = wc_get_product($item['product_id']);
                $product_id = $item['product_id'];
            }
            $sku = null;
            if ($product) {
                $sku = $product->get_sku();
            }

            $line_tax_data = isset( $item['line_tax_data'] ) ? $item['line_tax_data'] : '';
            $tax_data = maybe_unserialize( $line_tax_data );

            $taxes = $item->get_taxes();

            $tax_item_id = 0;

            $lastTaxSum = 0;
            $lastTaxId = null;

            $maxTaxSum = 0;
            $maxTaxId = null;

            foreach ($taxes['subtotal'] as $taxId => $taxTotal) {
                $tax_item_id = $taxId;

                if ($maxTaxSum < $taxTotal) {
                    $maxTaxSum = $taxTotal;
                    $maxTaxId = $taxId;
                }

                $lastTaxSum = $taxTotal;
                $lastTaxId = $taxId;
            }

            if (abs($maxTaxSum) > 0) {
                $lastTaxSum = $maxTaxSum;
                $lastTaxId = $maxTaxId;
            }

            $tax_item_id = $lastTaxId;

            if (!isset($meritTaxSettings[$tax_item_id])) {
                $tax_item_id = 0;
                if (isset($meritTaxSettings['missing_vat'])) {
                    if (!empty($meritTaxSettings['missing_vat'])) {
                        $tax_item_id = 'missing_vat';
                    }
                }

            }
			$rowType = isset($this->_options['invoice_row_type']) ? $this->_options['invoice_row_type'] : 3;

            $discount = '';

            if ($item->get_subtotal() !== $item->get_total()) {
                $discount = number_format($item->get_subtotal() - $item->get_total(), 2, '.', '');
            }

            $costCenter = $meritOptions['cost_center'];
            $glAccount = '';

            if (isset($meritOptions['tax_cost_center'][$tax_item_id])) {
                if (!empty($meritOptions['tax_cost_center'][$tax_item_id])) {
                    $glAccount = $meritOptions['tax_cost_center'][$tax_item_id];
                }
            }

            $data['rows'][] = array(
                'tax_id' => $meritTaxSettings[$tax_item_id],
                'description' => $name,
                'code' => $sku,
                'quantity' => $item->get_quantity(),
                'price' => $order->get_item_total( $item, false, false ),
                'type' => $rowType,
                'cost_center' => $costCenter,
                'gl_account' => $glAccount,
                'discount_sum' => $discount,
                'stock_code' => isset($this->_options['stock_code_invoice']) ? $this->_options['stock_code_invoice'] : null,
                'row_type' => 'line_item',
                'product_id' => $product_id,
            );

        }

        foreach ($order->get_items( 'fee' ) as $item_id => $item ) {

            $name = $item->get_name();

            $line_tax_data = isset( $item['line_tax_data'] ) ? $item['line_tax_data'] : '';
            $tax_data = maybe_unserialize( $line_tax_data );

            $taxes = $item->get_taxes();

            $tax_item_id = 0;

            $lastTaxSum = 0;
            $lastTaxId = null;

            $maxTaxSum = 0;
            $maxTaxId = null;

            foreach ($taxes['total'] as $taxId => $taxTotal) {
                $tax_item_id = $taxId;

                if ($maxTaxSum < $taxTotal) {
                    $maxTaxSum = $taxTotal;
                    $maxTaxId = $taxId;
                }

                $lastTaxSum = $taxTotal;
                $lastTaxId = $taxId;
            }

            if (abs($maxTaxSum) > 0) {
                $lastTaxSum = $maxTaxSum;
                $lastTaxId = $maxTaxId;
            }

            $tax_item_id = $lastTaxId;

            if (!isset($meritTaxSettings[$tax_item_id])) {
                $tax_item_id = 0;
                if (isset($meritTaxSettings['missing_vat'])) {
                    if (!empty($meritTaxSettings['missing_vat'])) {
                        $tax_item_id = 'missing_vat';
                    }
                }

            }
			$rowType = isset($this->_options['invoice_row_type']) ? $this->_options['invoice_row_type'] : 3;

            $discount = '';

            $costCenter = $meritOptions['cost_center'];
            $glAccount = '';

            if (isset($meritOptions['tax_cost_center'][$tax_item_id])) {
                if (!empty($meritOptions['tax_cost_center'][$tax_item_id])) {
                    $glAccount = $meritOptions['tax_cost_center'][$tax_item_id];
                }
            }

            $data['rows'][] = array(
                'tax_id' => $meritTaxSettings[$tax_item_id],
                'description' => $name,
                'code' => '',
                'quantity' => $item->get_quantity(),
                'price' => $order->get_item_total( $item, false, false ),
                'type' => $rowType,
                'cost_center' => $costCenter,
                'gl_account' => $glAccount,
                'discount_sum' => $discount,
                'stock_code' => isset($this->_options['stock_code_invoice']) ? $this->_options['stock_code_invoice'] : null,
                'row_type' => 'fee',
            );

        }

        $line_items_shipping = $order->get_items( 'shipping' );

        $shippingArticle = null;

        if ($orderShippingMethods = $order->get_shipping_methods()) {
            $shipping_method = array_shift($orderShippingMethods);
            $shipping_method_id = $shipping_method['method_id'];

            $shippingMethodFullName = $shipping_method_id;
            if ($shipping_method_instance_id = $shipping_method['instance_id']) {
                $shippingMethodFullName .= ':' . $shipping_method_instance_id;
            }

            if (isset($meritOptions['shipping_articles'][$shippingMethodFullName])) {
                $shippingArticle = $meritOptions['shipping_articles'][$shippingMethodFullName];
            }
        }

        foreach ($line_items_shipping as $item_id => $item) {
            $name = $item->get_name() ? $item->get_name() : __( 'Shipping', 'woocommerce' );
            $tax_data = $item->get_taxes();

            if (empty(eliides_arr_get($tax_data, ['total']))) {
                $footerComment[] = 'Tarneviis: ' . $name;
            }

            $tax_item_id = 0;

            $lastTaxRow = array();
            $maxValueTaxRow = array();
            $maxTaxValue = 0;

            $costCenter = $meritOptions['cost_center'];
            $glAccount = '';

            if (empty($tax_data['total'])) {
                if (isset($meritTaxSettings['missing_vat']) && !empty($meritTaxSettings['missing_vat'])) {
                    if (isset($meritOptions['tax_cost_center']['missing_vat'])) {
                        if (!empty($meritOptions['tax_cost_center']['missing_vat'])) {
                            $glAccount = $meritOptions['tax_cost_center']['missing_vat'];
                        }
                    }
                    $lastTaxRow = array(
                        'tax_id' => $meritTaxSettings['missing_vat'],
                        'description' => $name,
                        'code' => $shippingArticle,
                        'quantity' => 1,
                        'cost_center' => $costCenter,
                        'gl_account' => $glAccount,
                        'price' => $item->get_total('not-view'),
                    );
                }

            }
            else {
                foreach ($tax_data['total'] as $tax_item_id => $tax_total) {
                    if (!isset($meritTaxSettings[$tax_item_id])) {
                        $tax_item_id = 0;
                        if (isset($meritTaxSettings['missing_vat'])) {
                            if (!empty($meritTaxSettings['missing_vat'])) {
                                $tax_item_id = 'missing_vat';
                            }
                        }

                    }

                    if (isset($meritOptions['tax_cost_center'][$tax_item_id])) {
                        if (!empty($meritOptions['tax_cost_center'][$tax_item_id])) {
                            $glAccount = $meritOptions['tax_cost_center'][$tax_item_id];
                        }
                    }

                    if ($tax_total > $maxTaxValue) {
                        $maxValueTaxRow = array(
                            'tax_id' => $meritTaxSettings[$tax_item_id],
                            'description' => $name,
                            'code' => $shippingArticle,
                            'quantity' => 1,
                            'cost_center' => $costCenter,
                            'gl_account' => $glAccount,
                            'price' => $item->get_total('not-view'),
                        );
                    }

                    $lastTaxRow = array(
                        'tax_id' => $meritTaxSettings[$tax_item_id],
                        'description' => $name,
                        'code' => $shippingArticle,
                        'quantity' => 1,
                        'cost_center' => $costCenter,
                        'gl_account' => $glAccount,
                        'price' => $item->get_total('not-view'),
                    );

                }
            }



            if (!empty($maxValueTaxRow)) {
                $lastTaxRow = $maxValueTaxRow;
            }
            $lastTaxRow['row_type'] = 'shipping';
            $data['rows'][] = $lastTaxRow;
        }

        if (!empty($footerComment)) {
            $data['footer_comment'] = implode(', ', $footerComment);
        }

        if (!empty($headerComment)) {
            $data['header_comment'] = implode(', ', $headerComment);
        }

        if ($hasEUVat) {
            foreach ($data['rows'] as $rowK => $row) {
                if (isset($meritTaxSettings['eu_vat_code'])) {
                    if (!empty($meritTaxSettings['eu_vat_code'])) {
                        $data['rows'][$rowK]['tax_id'] = $meritTaxSettings['eu_vat_code'];
                    }
                }
                if (isset($meritOptions['tax_cost_center']['eu_vat_code'])) {
                    if (!empty($meritOptions['tax_cost_center']['eu_vat_code'])) {
                        $data['rows'][$rowK]['gl_account'] = $meritOptions['tax_cost_center']['eu_vat_code'];
                    }
                }
            }
        }

        if (!$data = apply_filters('merit_data_before_send', $data, $order_id)) {
            return false;
        }

        $endpoint = 'send-invoice';
        if (eliides_arr_get($meritOptions, 'invoice_type') == 'sales_offer') {
            $endpoint = 'send-sale-offer';
        }

        $res = $this->_api->sendRequest($this->_api_key, 'accounting', $endpoint, array(
            'software' => 'merit',
            'software_api_id' => get_option('veebiekspert_module_merit_internal_app_id'),
            'software_api_key' => get_option('veebiekspert_module_merit_internal_app_key'),
            'invoice' => $data,
        ));

        if ($res['status'] > 0) {
            $order->add_order_note(sprintf(__('Arve saadeti raamatupidamistarkvarasse %s', ELIIDES_TD), 'Merit Aktiva'));
            $order->update_meta_data('merit_invoice_id', eliides_sanitize_text_or_array_field($res['data']));
            $order->save();
            return true;
        }
		else {

			unset($data['payment']);

			$res = $this->_api->sendRequest($this->_api_key, 'accounting', $endpoint, array(
				'software' => 'merit',
				'software_api_id' => get_option('veebiekspert_module_merit_internal_app_id'),
				'software_api_key' => get_option('veebiekspert_module_merit_internal_app_key'),
				'invoice' => $data,
			));

			if ($res['status'] > 0) {
				$order->add_order_note(sprintf(__('Arve saadeti raamatupidamistarkvarasse %s', ELIIDES_TD), 'Merit Aktiva'));
                $order->update_meta_data('merit_invoice_id', eliides_sanitize_text_or_array_field($res['data']));
                $order->save();
				return true;
			}

		}
        return false;


    }

    public function getProducts() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-products', array(
            'software' => 'merit',
            'software_api_id' => get_option('veebiekspert_module_merit_internal_app_id'),
            'software_api_key' => get_option('veebiekspert_module_merit_internal_app_key'),
            'params' => array(
                'stock_code' => isset($this->_options['stock_code']) ? $this->_options['stock_code'] : null,
            )
        ));

        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }

        return false;
    }

    public function getTaxes() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-taxes', array(
            'software' => 'merit',
            'software_api_id' => get_option('veebiekspert_module_merit_internal_app_id'),
            'software_api_key' => get_option('veebiekspert_module_merit_internal_app_key'),
        ));

        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }

    public function getDepartments() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-departments', array(
            'software' => 'merit',
            'software_api_id' => get_option('veebiekspert_module_merit_internal_app_id'),
            'software_api_key' => get_option('veebiekspert_module_merit_internal_app_key'),
        ));

        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }

    public function getCostCenters() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-cost-centers', array(
            'software' => 'merit',
            'software_api_id' => get_option('veebiekspert_module_merit_internal_app_id'),
            'software_api_key' => get_option('veebiekspert_module_merit_internal_app_key'),
        ));

        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }

    public function getProjects() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-projects', array(
            'software' => 'merit',
            'software_api_id' => get_option('veebiekspert_module_merit_internal_app_id'),
            'software_api_key' => get_option('veebiekspert_module_merit_internal_app_key'),
        ));

        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }

    public function getVatCostCenters() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-tax-accounts', array(
            'software' => 'merit',
            'software_api_id' => get_option('veebiekspert_module_merit_internal_app_id'),
            'software_api_key' => get_option('veebiekspert_module_merit_internal_app_key'),
        ));

        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }

    public function getPaymentMethods() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-payment-methods', array(
            'software' => 'merit',
            'software_api_id' => get_option('veebiekspert_module_merit_internal_app_id'),
            'software_api_key' => get_option('veebiekspert_module_merit_internal_app_key'),
        ));

        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }

    public function getInvoicePDF($order_id) {
        $order = wc_get_order($order_id);
        if (!$invoiceData = $order->get_meta('merit_invoice_id')) {
            return false;
        }

        if (isset($invoiceData['InvoiceId']) && !empty($invoiceData['InvoiceId'])) {
            $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-invoice-pdf', array(
                'software' => 'merit',
                'software_api_id' => get_option('veebiekspert_module_merit_internal_app_id'),
                'software_api_key' => get_option('veebiekspert_module_merit_internal_app_key'),
                'invoice_id' => $invoiceData['InvoiceId'],
            ));

            if ($res['status'] > 0) {
                return eliides_arr_get($res, 'pdf');
            }
        }

        return false;
    }

    public function getProductIdsBySku($sku) {
        if (empty($sku)) {
            return array();
        }
        global $wpdb;

        $sql = $wpdb->prepare("SELECT post_id FROM " . $wpdb->postmeta . " WHERE meta_key = '_sku' AND meta_value = %s", $sku);

        return $wpdb->get_col($sql);
    }

}

endif;
