<?php

class WC_Integration_Eliides_Merit extends WC_Integration {


    public function __construct() {
        $this->id                 = 'merit';
        $this->method_title       = 'Merit Aktiva';
        $this->method_description = null;

        $this->init_form_fields();
        $this->init_settings();

        add_action( 'woocommerce_update_options_integration_' .  $this->id, array( $this, 'process_admin_options' ) );
    }

    public function process_admin_options()
    {
        $this->init_settings();

        $post_data = $this->get_post_data();
        update_option('veebiekspert_module_merit_api_key', eliides_sanitize_text_or_array_field(eliides_arr_get($post_data, 'veebiekspert_module_merit_api_key')));
        update_option('veebiekspert_module_merit_internal_app_id', eliides_sanitize_text_or_array_field(eliides_arr_get($post_data, 'veebiekspert_module_merit_internal_app_id')));
        update_option('veebiekspert_module_merit_internal_app_key', eliides_sanitize_text_or_array_field(eliides_arr_get($post_data, 'veebiekspert_module_merit_internal_app_key')));
        update_option('veebiekspert_module_merit_trigger', eliides_sanitize_text_or_array_field(eliides_arr_get($post_data, 'veebiekspert_module_merit_trigger')));
        update_option('veebiekspert_module_merit_taxes', eliides_sanitize_text_or_array_field(eliides_arr_get($post_data, 'veebiekspert_module_merit_taxes')));
        update_option('veebiekspert_module_merit_payment_methods', eliides_sanitize_text_or_array_field(eliides_arr_get($post_data, 'veebiekspert_module_merit_payment_methods')));
        update_option('veebiekspert_module_merit_options', eliides_sanitize_text_or_array_field(eliides_arr_get($post_data, 'veebiekspert_module_merit_options')));

        $activeModules = (array) get_option('veebiekspert_active_module', []);
        $module = 'merit';

        if (!empty($post_data['is_module_active'])) {
            if (!in_array($module, $activeModules)) {
                $activeModules[] = $module;
                update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
            }
        }
        else {
            $key = array_search($module, $activeModules);
            if (false !== $key) {
                unset($activeModules[$key]);
                update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
            }
        }

    }

    public function admin_options() {
        parent::admin_options();
        $meritOptions = (array) get_option('veebiekspert_module_merit_options');
        $countries = Veebiekspert_Modules()->getCountries();
        $taxes = array(
            0 => array(
                'label' => '0%',
                'rate' => 0,
            )
        );

        if (defined('WC_ABSPATH')) {

            $allShippingPackages = WC()->shipping()->get_shipping_methods();

            $zones = WC_Shipping_Zones::get_zones();
            foreach ($zones as $zone) {
                foreach ($zone['shipping_methods'] as $shipMethod) {
                    $shipObj = new stdClass();
                    $shipObj->id = $shipMethod->id . ':' . $shipMethod->instance_id;
                    $shipObj->title = $shipMethod->title;
                    $allShippingPackages[] = $shipObj;
                }
            }


            foreach (WC_Tax::get_rates() as $taxId => $tax) {
                $taxes[$taxId] = $tax;
            }

            if (class_exists('WC_Tax')) {
                if (method_exists('WC_Tax', 'get_tax_class_slugs')) {

                    $taxClasses = array_merge(array(''), WC_Tax::get_tax_class_slugs());

                    foreach ($taxClasses as $taxSlug) {
                        foreach (WC_Tax::get_rates_for_tax_class($taxSlug) as $taxId => $tax) {
                            $taxes[$taxId] = array(
                                'label' => implode(', ', array_filter(array($taxSlug, $tax->tax_rate_name, $tax->tax_rate_country))),
                                'rate' => $tax->tax_rate,
                            );
                        }

                    }

                }
            }

        }

        $veebiekspert_active_module = (array) get_option('veebiekspert_active_module');
        ?>
        <div class="veebiekspert-setting-block">
            <input type="hidden" name="is_module_active" value="0" />
            <h2><label><input type="checkbox" name="is_module_active"<?php if (in_array('merit', $veebiekspert_active_module)): ?> checked<?php endif; ?> value="1" /> Aktiivne</label></h2>

            <div class="settings-block-inner">

                <div class="ve-form-group">
                    <label>E-liides litsentsi võti</label>
                    <input type="text" id="veebiekspert_module_merit_api_key" name="veebiekspert_module_merit_api_key" value="<?php echo get_option('veebiekspert_module_merit_api_key'); ?>" />
                    <a href="https://www.e-liides.ee" target="_blank">Registreeri võti (7 päeva tasuta)</a>
                </div>

                <div class="ve-form-group">
                    <label>API ID (Merit Aktiva keskkonna oma)</label>
                    <input type="text" id="veebiekspert_module_merit_internal_app_id" name="veebiekspert_module_merit_internal_app_id" value="<?php echo get_option('veebiekspert_module_merit_internal_app_id'); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>API Võti (Merit Aktiva keskkonna oma)</label>
                    <input type="text" id="veebiekspert_module_merit_internal_app_key" name="veebiekspert_module_merit_internal_app_key" value="<?php echo get_option('veebiekspert_module_merit_internal_app_key'); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Arve eesliide</label>
                    <input type="text" name="veebiekspert_module_merit_options[invoice_prefix]" value="<?php echo esc_html(eliides_arr_get($meritOptions, ['invoice_prefix'], 'WP')); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Maksetähtaeg päevades</label>
                    <input type="text" name="veebiekspert_module_merit_options[payment_days]" value="<?php echo esc_html(eliides_arr_get($meritOptions, ['payment_days'], '')); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Arve saatmise hetk</label>

                    <?php

                    $options = array(
                        'woocommerce_order_status_on-hold' => 'Ootel',
                        'woocommerce_order_status_processing' => 'Töötluses',
                        'woocommerce_order_status_completed' => 'Tellimus täidetud',
                    );

                    $selected = get_option('veebiekspert_module_merit_trigger', 'woocommerce_order_status_completed');
                    ?>

                    <select name="veebiekspert_module_merit_trigger">
                        <?php foreach ($options as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="ve-form-group">
                    <label>Arve ridade tüüp</label>

                    <?php

                    $options = array(
                        '1' => 'Laokaup',
                        '2' => 'Teenus',
                        '3' => 'Kaup',
                    );

                    $selected = isset($meritOptions['invoice_row_type']) ? $meritOptions['invoice_row_type'] : 3;
                    ?>

                    <select name="veebiekspert_module_merit_options[invoice_row_type]">
                        <?php foreach ($options as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="ve-form-group">
                    <span style="color: #cc0808; font-weight: bold;">Laoseisu uuendamiseks</span> tuleb külastada linki:<br />
                    <a href="<?php echo get_site_url(); ?>/?eliides_sync_merit" target="_blank"><?php echo get_site_url(); ?>/?eliides_sync_merit</a>
                </div>

                <?php
                $yesNoOptions = array(
                    'outofstock' => 'Laost otsas',
                    'onbackorder' => 'Järeltellimisel',
                );
                ?>

                <div class="ve-form-group">
                    <label>Laost otsas toodete olek</label>
                    <select name="veebiekspert_module_merit_options[zero_stock_status]">
                        <?php foreach ($yesNoOptions as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == eliides_arr_get($meritOptions, ['zero_stock_status'])): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="ve-form-group">
                    <label>Laokood, mille laoseis imporditakse (valikuline)</label>
                    <input type="text" name="veebiekspert_module_merit_options[stock_code]" value="<?php echo esc_html(eliides_arr_get($meritOptions, ['stock_code'])); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Laokood, millest Meritis laoseisu vähendatakse (valikuline)</label>
                    <input type="text" name="veebiekspert_module_merit_options[stock_code_invoice]" value="<?php echo esc_html(eliides_arr_get($meritOptions, ['stock_code_invoice'])); ?>" />
                </div>

                <?php
                $yesNoOptions = array(
                    'no' => 'Ei luba hindasi uuendada',
                    'yes' => 'Luba hindade uuendamine',
                );
                ?>

                <div class="ve-form-group">
                    <label>Hindade uuendamine</label>
                    <select name="veebiekspert_module_merit_options[allow_price_update]">
                        <?php foreach ($yesNoOptions as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == eliides_arr_get($meritOptions, ['allow_price_update'])): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <?php
                $yesNoOptions = array(
                    'no' => 'Ei luba soodushindasi uuendada',
                    'yes' => 'Luba soodushindade uuendamine',
                );
                ?>

                <div class="ve-form-group">
                    <label>Soodushindade uuendamine</label>
                    <select name="veebiekspert_module_merit_options[allow_sale_price_update]">
                        <?php foreach ($yesNoOptions as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == eliides_arr_get($meritOptions, ['allow_sale_price_update'])): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <?php
                $yesNoOptions = array(
                    'no' => 'Ei luba laoseisu uuendada',
                    'yes' => 'Luba laoseisude uuendamine',
                );
                ?>

                <div class="ve-form-group">
                    <label>Laoseisu uuendamine</label>
                    <select name="veebiekspert_module_merit_options[allow_stock_update]">
                        <?php foreach ($yesNoOptions as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == eliides_arr_get($meritOptions, ['allow_stock_update'])): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>


                <?php
                $yesNoOptions = array(
                    'yes' => 'Saada Meritisse 0 EUR summaga arveid',
                    'no' => 'Ära saada Meritisse 0 EUR summaga arveid',
                );
                ?>

                <div class="ve-form-group">
                    <label>0 EUR summaga arvete saatmine</label>
                    <select name="veebiekspert_module_merit_options[send_zero_price_invoices]">
                        <?php foreach ($yesNoOptions as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == eliides_arr_get($meritOptions, ['send_zero_price_invoices'])): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <?php
                $yesNoOptions = array(
                    'yes' => 'Ühilda Meriti arve ja Montonio makse viitenumbrid',
                    'no' => 'Ära ühilda Meriti arve ja Montonio makse viitenumbrid',
                );
                ?>

                <div class="ve-form-group">
                    <label>Meriti ja Montonio viitenumbri ühildamine (Montonio olemasolul)</label>
                    <select name="veebiekspert_module_merit_options[sync_montonio_merit_reference_nr]">
                        <?php foreach ($yesNoOptions as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == eliides_arr_get($meritOptions, ['sync_montonio_merit_reference_nr'])): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <?php
                $yesNoOptions = array(
                    'no' => 'Ei saada Meriti PDF arvet e-mailile',
                    'yes' => 'Saada Meriti PDF arve e-mailile',
                );
                ?>

                <div class="ve-form-group">
                    <label>Lisa arve PDF e-mailiga kaasa kui tellimus on täidetud</label>
                    <select name="veebiekspert_module_merit_options[send_merit_pdf]">
                        <?php foreach ($yesNoOptions as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == eliides_arr_get($meritOptions, ['send_merit_pdf'])): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <?php
                $meritDepartments = Veebiekspert_Modules()->getMerit()->getDepartments();
                if (!$meritDepartments) {
                    $meritDepartments = array();
                }

                $meritProjects = Veebiekspert_Modules()->getMerit()->getProjects();
                if (!$meritProjects) {
                    $meritProjects = array();
                }

                ?>

                <div class="ve-form-group">
                    <label>Merit projekt arvel</label>
                    <select name="veebiekspert_module_merit_options[project]">
                        <option value=""></option>
                        <?php foreach ($meritProjects as $i): ?>
                            <option value="<?php echo $i['Code']; ?>"<?php if ($i['Code'] == eliides_arr_get($meritOptions, ['project'])): ?> selected<?php endif; ?>><?php echo $i['Name']; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <?php
                $meritCostCenters = Veebiekspert_Modules()->getMerit()->getCostCenters();
                if (!$meritCostCenters) {
                    $meritCostCenters = array();
                }

                if (!isset($meritOptions['departments'])) {
                    $meritDepartmentRows = array();
                }
                else {
                    $meritDepartmentRows = $meritOptions['departments'];
                }

                ?>

                <div class="ve-form-group">
                    <label>Merit kulukonto arvel</label>
                    <select name="veebiekspert_module_merit_options[cost_center]">
                        <option value=""></option>
                        <?php foreach ($meritCostCenters as $i): ?>
                            <option value="<?php echo $i['Code']; ?>"<?php if ($i['Code'] == eliides_arr_get($meritOptions, ['cost_center'])): ?> selected<?php endif; ?>><?php echo $i['Name']; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="ve-form-group">
                    <label>Saada tellimus Meritisse</label>
                    <select name="veebiekspert_module_merit_options[invoice_type]">
                        <option value="">Arvena</option>
                        <option value="sales_offer"<?php if ('sales_offer' == eliides_arr_get($meritOptions, ['invoice_type'])): ?> selected<?php endif; ?>>Ettemaksuarvena</option>
                    </select>
                </div>

                <div class="ve-form-group">
                    <label>Arve keel</label>
                    <select name="veebiekspert_module_merit_options[invoice_lang]">
                        <option value="">Eesti</option>
                        <option value="EN"<?php if ('EN' == eliides_arr_get($meritOptions, ['invoice_lang'])): ?> selected<?php endif; ?>>Inglise</option>
                    </select>
                </div>

                <div class="ve-form-group">
                    <label>Vaikimisi osakond</label>
                    <select name="veebiekspert_module_merit_options[default_department]">
                        <option value=""></option>
                        <?php foreach ($meritDepartments as $i): ?>
                            <option value="<?php echo $i['Code']; ?>"<?php if ($i['Code'] == eliides_arr_get($meritOptions, ['default_department'])): ?> selected<?php endif; ?>><?php echo $i['Name']; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="ve-form-group">
                    <label>Osakondade erisused</label>

                    <table class="widefat fixed" style="margin-top: 20px;">
                        <thead>
                        <tr>
                            <th>Riik</th>
                            <th>Osakond</th>
                            <th></th>
                        </tr>
                        </thead>
                        <tbody id="merit-department-table">
                        <?php foreach ($meritDepartmentRows as $country => $department): ?>
                            <tr>
                                <td><?php echo @esc_html(eliides_arr_get($countries, [$country])); ?></td>
                                <td>
                                    <?php foreach ($meritDepartments as $meritDepartment): ?>
                                        <?php if ($meritDepartment['Code'] == $department): ?>
                                            <?php echo esc_html($meritDepartment['Name']); ?>
                                            <?php break; endif; ?>
                                    <?php endforeach; ?>
                                    <input type="hidden" name="veebiekspert_module_merit_options[departments][<?php echo $country; ?>]" value="<?php echo $department; ?>" />
                                </td>
                                <td><span style="color: red; cursor: pointer;" onclick="jQuery(this).closest('tr').remove();">Kustuta</span></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                        <tr>
                            <td colspan="3">
                                <select id="merit-department-new-country">
                                    <?php foreach ($countries as $countryCode => $name): ?>
                                        <option value="<?php echo @esc_html($countryCode); ?>"><?php echo @esc_html($name); ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <button class="button" onclick="return addNewMeritDepartmentRow();">Lisa</button>
                            </td>
                        </tr>
                        </tfoot>
                    </table>

                    <script type="text/javascript">
                        function addNewMeritDepartmentRow() {
                            var html = jQuery('#new-merit-department-row-template').html();

                            html = html.replace(new RegExp('country_name', 'g'), jQuery('#merit-department-new-country option:selected').text());
                            html = html.replace(new RegExp('country', 'g'), jQuery('#merit-department-new-country').val());

                            jQuery('#merit-department-table').append(html);
                            return false;
                        }
                    </script>

                    <script type="text/template" id="new-merit-department-row-template">
                        <tr>
                            <td>country_name</td>
                            <td>
                                <select name="veebiekspert_module_merit_options[departments][country]">
                                    <option value=""></option>
                                    <?php foreach ($meritDepartments as $i): ?>
                                        <option value="<?php echo $i['Code']; ?>"><?php echo $i['Name']; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                            <td><span style="color: red; cursor: pointer;" onclick="jQuery(this).closest('tr').remove();">Kustuta</span></td>
                        <tr>
                    </script>

                </div>

                <?php if (defined('WC_ABSPATH')): ?>

                    <?php
                    $available_gateways = WC()->payment_gateways->payment_gateways();
                    $meritPaymentMethods = Veebiekspert_Modules()->getMerit()->getPaymentMethods();
                    $meritPaymentSettings = (array) get_option('veebiekspert_module_merit_payment_methods');
                    if (!$meritPaymentMethods) {
                        $meritPaymentMethods = array();
                    }

                    ?>

                    <table class="widefat fixed" style="margin-top: 20px;">
                        <thead>
                        <tr>
                            <th>E-poe makseviis</th>
                            <th>Merit konto</th>
                            <th>Laekumine lisatakse Meritisse</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($available_gateways as $methodName => $method): ?>
                            <tr>
                                <td><?php echo @esc_html($method->title); ?></td>
                                <td>
                                    <select name="veebiekspert_module_merit_payment_methods[<?php echo @esc_html($methodName); ?>]">
                                        <?php foreach ($meritPaymentMethods as $meritMethod): ?>
                                            <option value="<?php echo $meritMethod['AccountID']; ?>"<?php if (isset($meritPaymentSettings[$methodName]) && $meritMethod['AccountID'] == $meritPaymentSettings[$methodName]): ?> selected<?php endif; ?>><?php echo @esc_html($meritMethod['Name'] . ' (' . $meritMethod['Code'] . ')'); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                                <td>
                                    <select name="veebiekspert_module_merit_options[disable_income][<?php echo @esc_html($methodName); ?>]">
                                        <option value="yes"<?php if (isset($meritOptions['disable_income']) && eliides_arr_get($meritOptions, ['disable_income',$methodName]) == 'yes'): ?> selected<?php endif; ?>>Jah</option>
                                        <option value="no"<?php if (isset($meritOptions['disable_income']) && eliides_arr_get($meritOptions, ['disable_income',$methodName]) == 'no'): ?> selected<?php endif; ?>>Ei</option>
                                    </select>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>

                    <?php

                    if (!$meritTaxes = Veebiekspert_Modules()->getMerit()->getTaxes()) {
                        $meritTaxes = [];
                    }
                    if (!$meritTaxAccounts = Veebiekspert_Modules()->getMerit()->getVatCostCenters()) {
                        $meritTaxAccounts = [];
                    }
                    $meritTaxSettings = (array) get_option('veebiekspert_module_merit_taxes');

                    ?>

                    <table class="widefat fixed" style="margin-top: 20px;">
                        <thead>
                        <tr>
                            <th>Maksu ID</th>
                            <th>Maksu %</th>
                            <th>Nimetus</th>
                            <th>Vaste</th>
                            <th>Konto</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($taxes as $taxId => $tax): ?>
                            <tr>
                                <td><?php echo $taxId; ?></td>
                                <td><?php echo $tax['rate']; ?></td>
                                <td><?php echo @esc_html($tax['label']); ?></td>
                                <td>
                                    <select name="veebiekspert_module_merit_taxes[<?php echo $taxId; ?>]">
                                        <?php foreach ($meritTaxes as $meritTax): ?>
                                            <option value="<?php echo $meritTax['Id']; ?>"<?php if (isset($meritTaxSettings[$taxId]) && $meritTax['Id'] == $meritTaxSettings[$taxId]): ?> selected<?php endif; ?>><?php echo @esc_html($meritTax['Name'] . ' (' . $meritTax['TaxPct'] . '%)'); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                                <td>
                                    <select name="veebiekspert_module_merit_options[tax_cost_center][<?php echo $taxId; ?>]">
                                        <option value=""></option>
                                        <?php foreach ($meritTaxAccounts as $meritTax): ?>
                                            <option value="<?php echo $meritTax['Code']; ?>"<?php if (isset($meritOptions['tax_cost_center'][$taxId]) && $meritTax['Code'] == $meritOptions['tax_cost_center'][$taxId]): ?> selected<?php endif; ?>><?php echo @esc_html($meritTax['Name'] . ' (' . $meritTax['Code'] . ')'); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        <tr>
                            <th colspan="3">EU VAT koodiga tellimus</th>
                            <td>
                                <select name="veebiekspert_module_merit_taxes[eu_vat_code]">
                                    <?php foreach ($meritTaxes as $meritTax): ?>
                                        <option value="<?php echo $meritTax['Id']; ?>"<?php if (isset($meritTaxSettings['eu_vat_code']) && $meritTax['Id'] == $meritTaxSettings['eu_vat_code']): ?> selected<?php endif; ?>><?php echo @esc_html($meritTax['Name'] . ' (' . $meritTax['TaxPct'] . '%)'); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                            <td>
                                <select name="veebiekspert_module_merit_options[tax_cost_center][eu_vat_code]">
                                    <option value=""></option>
                                    <?php foreach ($meritTaxAccounts as $meritTax): ?>
                                        <option value="<?php echo $meritTax['Code']; ?>"<?php if (isset($meritOptions['tax_cost_center']['eu_vat_code']) && $meritTax['Code'] == $meritOptions['tax_cost_center']['eu_vat_code']): ?> selected<?php endif; ?>><?php echo @esc_html($meritTax['Name'] . ' (' . $meritTax['Code'] . ')'); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <th colspan="3">Puuduva maksu vaste (peaks olema 0%)</th>
                            <td>
                                <select name="veebiekspert_module_merit_taxes[missing_vat]">
                                    <?php foreach ($meritTaxes as $meritTax): ?>
                                        <option value="<?php echo $meritTax['Id']; ?>"<?php if (isset($meritTaxSettings['missing_vat']) && $meritTax['Id'] == $meritTaxSettings['missing_vat']): ?> selected<?php endif; ?>><?php echo @esc_html($meritTax['Name'] . ' (' . $meritTax['TaxPct'] . '%)'); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                            <td>
                                <select name="veebiekspert_module_merit_options[tax_cost_center][missing_vat]">
                                    <option value=""></option>
                                    <?php foreach ($meritTaxAccounts as $meritTax): ?>
                                        <option value="<?php echo $meritTax['Code']; ?>"<?php if (isset($meritOptions['tax_cost_center']['missing_vat']) && $meritTax['Code'] == $meritOptions['tax_cost_center']['missing_vat']): ?> selected<?php endif; ?>><?php echo @esc_html($meritTax['Name'] . ' (' . $meritTax['Code'] . ')'); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                        </tr>
                        </tbody>
                    </table>

                    <table class="widefat fixed" style="margin-top: 20px;">
                        <thead>
                        <tr>
                            <th>Tarneviisi ID</th>
                            <th>Nimetus</th>
                            <th>Artikli kood</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($allShippingPackages as $package): ?>
                            <?php
                            if (empty($package->title)) {
                                continue;
                            }
                            $shippingArticle = '';
                            if (isset($meritOptions['shipping_articles'][$package->id])) {
                                $shippingArticle = $meritOptions['shipping_articles'][$package->id];
                            }
                            ?>
                            <tr>
                                <td><?php echo $package->id; ?></td>
                                <td><?php echo esc_html($package->title); ?></td>
                                <td>
                                    <input type="text" name="veebiekspert_module_merit_options[shipping_articles][<?php echo $package->id; ?>]" value="<?php echo esc_html($shippingArticle); ?>" />
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>

                <?php else: ?>

                    Aktiveeri Woocommerce moodul, et maksude andmed seadistada

                <?php endif; ?>

            </div>

        </div>

        <?php
    }
}
