<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

if ( ! class_exists( 'Veebiekspert_Accouting_Excellent' ) ) :


    class Veebiekspert_Accouting_Excellent {

        /**
         * API
         *
         * @var Veebiekspert_API
         */
        protected $_api;

        protected $_api_key;

        protected $_options = array();

        protected $_name = 'excellent';

        const SEND_INVOICE = 'eliides_excellent_send';

        /**
         * Consturctor
         *
         * @param Veebiekspert_API $api
         */
        public function __construct(Veebiekspert_API $api) {

            $this->_api = $api;
            $this->_api_key = get_option('veebiekspert_module_excellent_api_key');

            add_action( 'plugins_loaded', function() {
                if ( class_exists( 'WC_Integration' ) ) {
                    include_once( VE_ABS_PATH . 'accounting/excellent/excellent-integration.php' );
                    add_filter( 'woocommerce_integrations', function($integrations) {
                        $integrations[] = 'WC_Integration_Eliides_Excellent';
                        return $integrations;
                    });
                }
            });

            $veebiekspert_active_module = get_option('veebiekspert_active_module');

            if (!in_array('excellent', (array) $veebiekspert_active_module)) {
                return;
            }

            $this->_options = get_option('veebiekspert_module_excellent_options');

            //add_filter('woocommerce_admin_order_actions', array($this, 'add_pdf_invoice_link'), 10, 2);


            add_action('wp_ajax_' . self::SEND_INVOICE, array($this, 'send_invoice_ajax'));

            if ($this->_api_key) {

                add_filter('bulk_actions-woocommerce_page_wc-orders', [$this, 'hpos_bulk_action'], 20, 1);
                add_action('init', array($this, 'do_hpos_bulk_action'));

                add_filter('woocommerce_admin_order_actions', array($this, 'show_if_invoice_sent'), 10, 2);
                add_action('admin_footer', array($this, 'custom_bulk_admin_footer'));

                add_action('load-edit.php', array($this, 'bulk_action'));

                add_action('woocommerce_order_status_on-hold', array($this, 'check_if_send_invoice'));
                add_action('woocommerce_order_status_processing', array($this, 'check_if_send_invoice'));
                add_action('woocommerce_order_status_completed', array($this, 'check_if_send_invoice'));

                if (_wp_array_get($this->_options, ['sync_montonio_books_reference_nr']) !== 'no') {
                    add_filter('montonio_payments_before_payment_data_submission', [$this, 'montonio_before_data_submission'], 10, 2);
                    add_filter('montonio_split_before_payment_data_submission', [$this, 'montonio_before_data_submission'], 10, 2);
                    add_filter('montonio_card_payments_before_payment_data_submission', [$this, 'montonio_before_data_submission'], 10, 2);
                    add_filter('wc_montonio_before_order_data_submission', [$this, 'wc_montonio_before_order_data_submission'], 10, 2);

                    add_filter('excellent_data_before_send', [$this, 'excellent_data_before_send'], 10, 2);
                }

                if (isset($_GET['eliides_sync_excellent'])) {
                    add_action('init', array($this, 'sync_stock'));
                }
            }

        }

        public function excellent_data_before_send($data, $order_id)
        {
            $data['reference_nr'] = $this->generate_reference_number($order_id);
            return $data;
        }

        public function montonio_before_data_submission( $payment_data, $order ) {
            $payment_data['payment_information_structured'] = $this->generate_reference_number($order->get_id());
            return $payment_data;
        }

        public function wc_montonio_before_order_data_submission( $payment_data, $order ) {
            $payment_data['merchantReferenceDisplay'] = $this->generate_reference_number($order->get_id());
            $payment_data['payment']['methodOptions']['paymentReference'] = $this->generate_reference_number($order->get_id());
            return $payment_data;
        }

        public function check_if_send_invoice($order_id) {
            $trigger = get_option('veebiekspert_module_excellent_trigger');

            if ($order = wc_get_order($order_id)) {

                if ($trigger == 'woocommerce_order_status_on-hold') {

                    if ($order->has_status(array('on-hold', 'processing', 'completed'))) {
                        $this->send_invoice($order_id);
                    }
                }
                elseif ($trigger == 'woocommerce_order_status_processing') {

                    if ($order->has_status(array('processing', 'completed'))) {
                        $this->send_invoice($order_id);
                    }
                }
                elseif ($trigger == 'woocommerce_order_status_completed') {

                    if ($order->has_status(array('completed'))) {
                        $this->send_invoice($order_id);
                    }
                }

            }

        }

        public function sync_stock() {
            global $sitepress;
            $products = $this->getProducts();
            $stock = $this->getStock();

            foreach ($products as $product) {

                $sku = $product['code'];

                if (empty($sku)) {
                    continue;
                }

                $name = $product['name'];
                if (!isset($stock[$sku])) {
                    $stock[$sku] = array(
                        'qty' => 0,
                    );
                }
                $qty = $stock[$sku]['qty'];
                $price = $product['price'];

                $productId = wc_get_product_id_by_sku($sku);

                if (empty($productId)) {
                    continue;

                }

                $wc_product = wc_get_product($productId);
                if (empty($wc_product)) {
                    continue;
                }

                if ($this->_options['allow_price_update'] == 'yes') {

                    $wc_product->set_regular_price($price);

                    if ($discountPrice = get_post_meta($productId, '_sale_price', true)) {
                        $wc_product->set_sale_price($discountPrice);
                    }
                    else {
                        $wc_product->set_sale_price($price);
                    }

                }

                $wc_product->set_stock_quantity($qty);
                $wc_product->save();

                if ($sitepress) {

                    $trid = $sitepress->get_element_trid($productId, 'post_product');
                    $translations = $sitepress->get_element_translations($trid, 'post_product');

                    foreach ($translations as $trLang => $translation) {
                        $post_id = $translation->element_id;

                        $wc_product = wc_get_product($post_id);

                        if (empty($wc_product)) {
                            continue;
                        }

                        $discountPrc = $product['DiscountPct'];

                        if ($this->_options['allow_price_update'] == 'yes') {
                            $wc_product->set_regular_price($price);

                            if ($discountPrice = get_post_meta($productId, '_sale_price', true)) {
                                $wc_product->set_sale_price($discountPrice);
                            }
                            else {
                                $wc_product->set_sale_price($price);
                            }

                        }

                        $wc_product->set_stock_quantity($qty);
                        $wc_product->save();



                    }
                }



            }
            echo 'done';
            exit;
        }

        public function bulk_action() {
            $wp_list_table = _get_list_table( 'WP_Posts_List_Table' );
            $action        = $wp_list_table->current_action();

            if ($action !== 'eliide_excellent_send_bulk') {
                return false;
            }

            $post_ids = array_map( 'absint', (array) $_REQUEST['post'] );

            foreach ($post_ids as $order_id) {
                $this->send_invoice($order_id);
            }
        }

        public function custom_bulk_admin_footer() {
            global $post_type;
            if($post_type == 'shop_order') {
                ?>
                <script type="text/javascript">
                    jQuery(document).ready(function() {
                        jQuery('<option>').val('eliide_excellent_send_bulk').text('<?php echo esc_html(__('Saada arve Standard Books serverisse', ELIIDES_TD)); ?>').appendTo('select[name="action"]');
                        jQuery('<option>').val('eliide_excellent_send_bulk').text('<?php echo esc_html(__('Saada arve Standard Books serverisse', ELIIDES_TD)); ?>').appendTo('select[name="action2"]');
                    });
                </script>
                <?php
            }
        }

        public function do_hpos_bulk_action()
        {
            if (!isset($_REQUEST['action2'])) {
                return;
            }
            if (!in_array($_REQUEST['action2'], ['excellent_bulk_send'])) {
                return;
            }
            $post_ids = array_map('intval', (array) $_REQUEST['id']);

            foreach ($post_ids as $order_id) {
                if ($_REQUEST['action2'] == 'excellent_bulk_send') {
                    $this->send_invoice($order_id);
                }
            }
        }

        public function hpos_bulk_action($actions) {
            $actions['excellent_bulk_send'] = __('Saada arve Standard Books serverisse', ELIIDES_TD);
            return $actions;
        }

        public function send_invoice_ajax() {
            $order_id = absint($_GET['order_id']);

            $this->send_invoice($order_id);

            wp_safe_redirect(wp_get_referer() ? wp_get_referer() : admin_url('edit.php?post_type=shop_order') );
            exit;
        }

        public function show_if_invoice_sent($actions, $order) {

            if (!$order->get_meta('excellent_invoice_id')) {

                $paymentType = $order->get_meta('_payment_method');

                $disabledPaymentMethods = (array) apply_filters('eliides_accounting_disabled_methods_' . self::SEND_INVOICE, array());

                if (!in_array($paymentType, $disabledPaymentMethods)) {
                    $actions[self::SEND_INVOICE] = array(
                        'action' => self::SEND_INVOICE,
                        'url' => wp_nonce_url(admin_url('admin-ajax.php?action=' . self::SEND_INVOICE . '&order_id=' . $order->get_id()), 'eliides-excellent-send'),
                        'name' => __('Saada arve Standard Books serverisse', ELIIDES_TD)
                    );
                }

            }
            return $actions;
        }

        public function send_invoice($order_id) {
            $order = wc_get_order($order_id);

            $paymentType = $order->get_payment_method();

            if ($order->get_meta('excellent_invoice_id')) {
                return false;
            }

            if ($invoiceDisabled = apply_filters('eliides_accounting_excellent_disable_invoice', false, $order_id)) {
                return false;
            }

            $standardBooksOptions = get_option('veebiekspert_module_excellent_options');

            if ($customPaymentTerm = eliides_arr_get($standardBooksOptions, ['payment_terms', $paymentType])) {
                $standardBooksOptions['payment_term'] = $customPaymentTerm;
            }

            $disabledPaymentMethods = (array) apply_filters('eliides_accounting_disabled_methods_' . self::SEND_INVOICE, array());

            if (in_array($paymentType, $disabledPaymentMethods)) {
                return false;
            }

            $isDisabledMethod = false;

            if (isset($standardBooksOptions['disable_income'][$paymentType]) && $standardBooksOptions['disable_income'][$paymentType] == 'no') {
                $isDisabledMethod = true;
            }

            $firstname = $order->get_billing_first_name();
            $lastname = $order->get_billing_last_name();

            if (!empty($order->get_shipping_first_name()) && !empty($order->get_shipping_last_name())) {
                $firstname = $order->get_shipping_first_name();
                $lastname = $order->get_shipping_last_name();
            }

            $billTo = $company = trim(implode(' ', array($firstname, $lastname)));

            $isCompany = 0;

            if ($order->get_billing_company()) {
                $company = $order->get_billing_company();
                $isCompany = 1;
            }

            $footerComment = array();
            $headerComment = array();

            $invoiceNr = eliides_arr_get($standardBooksOptions, ['invoice_prefix'], 'WP') . $order->get_order_number();

            if (function_exists('wcpdf_get_invoice')) {
                if ( $invoice = wcpdf_get_invoice( $order ) ) {
                    $wcpdfInvoiceNr = (string) $invoice->get_number();
                    if (!empty($wcpdfInvoiceNr)) {
                        $invoiceNr = $wcpdfInvoiceNr;
                    }
                }
            }

            $hasEUVat = false;

            if ($vatNr = $order->get_meta('_vat_number')) {
                $hasEUVat = true;
            }
            if ($vatCompanyAc = $order->get_meta('company_kmkr')) {
                $vatNr = $vatCompanyAc;
            }
            if ($vatBillingAc = $order->get_meta('_billing_eu_vat_number')) {
                $hasEUVat = true;
                if (is_array($vatBillingAc)) {
                    $vatNr = array_shift($vatBillingAc);
                }
                else {
                    $vatNr = $vatBillingAc;
                }
            }
            if ($vatBillingAc = $order->get_meta('_billing_vat')) {
                $hasEUVat = true;
            }
            if ($vatBillingAc = $order->get_meta('_billing_vat_number')) {
                $vatNr = $vatBillingAc;
                if (strtoupper(substr($vatBillingAc, 0, 2)) !== 'EE') {
                    $hasEUVat = true;
                }
            }

            $pricesWithVat = eliides_arr_get($standardBooksOptions, 'invoice_sum_type') !== 'without_vat';

            $data = array(
                'invoice_no' => $invoiceNr,
                'date' => $order->get_date_created() ? $order->get_date_created()->date_i18n() : date('Y-m-d'),
                'invoice_is_ok_flag' => $standardBooksOptions['invoice_is_ok_flag'],
                'invoice_is_stock_flag' => $standardBooksOptions['invoice_is_stock_flag'],
                'payment_term' => $standardBooksOptions['payment_term'],
                'project' => $standardBooksOptions['project'],
                'currency_code' => $order->get_currency(),
                'footer_commment' => '',
                'header_commment' => '',
                'total' => $order->get_total(),
                'warehouse_code' => eliides_arr_get($standardBooksOptions, 'warehouse_code', 'PL'),
                'customer' => array(
                    'name' => $company,
                    'company_name' => $company,
                    'person_name' => $billTo,
                    'country_code' => empty($order->get_billing_country()) ? 'EE' : $order->get_billing_country(),
                    'is_private' => $isCompany,
                    'address' => implode(' ', array_filter(array($order->get_billing_address_1(), $order->get_billing_address_2()))),
                    'city' => $order->get_billing_city(),
                    'country' => $order->get_billing_country(),
                    'postal_code' => $order->get_billing_postcode(),
                    'phone' => $order->get_billing_phone(),
                    'email' => $order->get_billing_email(),
                    'cat' => $standardBooksOptions['customer_cat'],
                    'fixed_person_id' => $standardBooksOptions['fixed_person_id'],
                    'payment_term' => $standardBooksOptions['payment_term'],
                    'vat_reg_no' => $vatNr,
                    'reg_no' => $order->get_meta('company_code'),
                ),
                'rows' => array()
            );

            if ($pricesWithVat) {
                $data['prices_with_vat'] = 1;
            }

            if ($order->is_paid() && !$isDisabledMethod) {

                $data['payment'] = array(
                    'sum' => $order->get_total(),
                    'code' => isset($standardBooksOptions['payment_methods'][$paymentType]) ? $standardBooksOptions['payment_methods'][$paymentType] : 'P',
                );


                /*
                $standardBooksPaymentSettings = get_option('veebiekspert_module_excellent_payment_methods');

                if (isset($standardBooksPaymentSettings[$paymentType])) {

                    $paymentMethods = $this->getPaymentMethods();

                    foreach ($paymentMethods as $paymentOption) {
                        if ($paymentOption['id'] == $standardBooksPaymentSettings[$paymentType]) {
                            $data['payment'] = array(
                                'sum' => $order->get_total(),
                                'account' => $paymentOption['code'],
                                'id' => $paymentOption['id'],
                            );
                            break;
                        }
                    }

                }

                */

            }

            $standardBooksTaxSettings = get_option('veebiekspert_module_excellent_taxes');
            $standardBooksVatSettings = get_option('veebiekspert_module_excellent_vat');

            foreach ($order->get_items( 'line_item' ) as $item_id => $item ) {

                $name = $item->get_name();

                if ($item['variation_id']) {
                    if (!$product = wc_get_product($item['variation_id'])) {
                        continue;
                    }
                }
                else {
                    if (!$product = wc_get_product($item['product_id'])) {
                        continue;
                    }
                }

                $sku = null;
                if ($product) {
                    $sku = $product->get_sku();
                }

                $line_tax_data = isset( $item['line_tax_data'] ) ? $item['line_tax_data'] : '';
                $tax_data = maybe_unserialize( $line_tax_data );

                $taxes = $item->get_taxes();

                $tax = 0;
                $tax_item_id = 0;

                $lastTaxId = null;

                $maxTaxSum = 0;
                $maxTaxId = null;

                foreach ($taxes['subtotal'] as $taxId => $taxTotal) {
                    $tax_item_id = $taxId;

                    if ($maxTaxSum < $taxTotal) {
                        $maxTaxSum = $taxTotal;
                        $maxTaxId = $taxId;
                    }

                    $lastTaxSum = $taxTotal;
                    $lastTaxId = $taxId;
                }

                if (abs($maxTaxSum) > 0) {
                    $lastTaxSum = $maxTaxSum;
                    $lastTaxId = $maxTaxId;
                }

                $tax_item_id = $lastTaxId;

                if (!isset($standardBooksTaxSettings[$tax_item_id])) {
                    $tax_item_id = 0;
                    if (isset($standardBooksTaxSettings['missing_vat'])) {
                        if (!empty($standardBooksTaxSettings['missing_vat'])) {
                            $tax_item_id = 'missing_vat';
                        }
                    }

                }

                $rowType = isset($this->_options['invoice_row_type']) ? $this->_options['invoice_row_type'] : 3;

                $data['rows'][] = array(
                    'product_id' => $item['product_id'],
                    'variation_id' => isset($item['variation_id']) ? $item['variation_id'] : null,
                    'tax_id' => $standardBooksTaxSettings[$tax_item_id],
                    'vat' => isset($standardBooksVatSettings[$tax_item_id]) ? $standardBooksVatSettings[$tax_item_id] : '',
                    'description' => $name,
                    'code' => $sku,
                    'quantity' => $item->get_quantity(),
                    'price' => $order->get_item_total( $item, $pricesWithVat, true ),
                    'row_sum' => $pricesWithVat ? floatval( $item->get_total() + $item->get_total_tax() ) : floatval($item->get_total()),
                    'type' => $rowType,
                );



            }

            foreach ($order->get_items( 'fee' ) as $item_id => $item ) {

                $name = $item->get_name();

                $taxes = $item->get_taxes();
                $lastTaxId = null;

                $maxTaxSum = 0;
                $maxTaxId = null;

                foreach ($taxes['subtotal'] as $taxId => $taxTotal) {
                    if ($maxTaxSum < $taxTotal) {
                        $maxTaxSum = $taxTotal;
                        $maxTaxId = $taxId;
                    }

                    $lastTaxId = $taxId;
                }

                if (abs($maxTaxSum) > 0) {
                    $lastTaxId = $maxTaxId;
                }

                $tax_item_id = $lastTaxId;

                $tax_item_id = $lastTaxId;

                if (!isset($standardBooksTaxSettings[$tax_item_id])) {
                    $tax_item_id = 0;
                    if (isset($standardBooksTaxSettings['missing_vat'])) {
                        if (!empty($standardBooksTaxSettings['missing_vat'])) {
                            $tax_item_id = 'missing_vat';
                        }
                    }

                }

                $data['rows'][] = array(
                    'tax_id' => $standardBooksTaxSettings[$tax_item_id],
                    'vat' => isset($standardBooksVatSettings[$tax_item_id]) ? $standardBooksVatSettings[$tax_item_id] : '',
                    'description' => $name,
                    'code' => null,
                    'quantity' => $item->get_quantity(),
                    'price' => $order->get_item_total( $item, $pricesWithVat, true ),
                    'row_sum' => $pricesWithVat ? floatval( $item->get_total() + $item->get_total_tax() ) : floatval($item->get_total()),
                );

            }



            foreach ($data['rows'] as $dataRow) {
                if (isset($dataRow['vat']) && !empty($dataRow['vat'])) {
                    $data['vat'] = $dataRow['vat'];
                    break;
                }
            }

            $line_items_shipping = $order->get_items( 'shipping' );

            $shippingArticle = null;
            $shippingTax = null;

            if ($orderShippingMethods = $order->get_shipping_methods()) {
                $shipping_method = array_shift($orderShippingMethods);
                $shipping_method_id = $shipping_method['method_id'];
                $shippingMethodFullName = $shipping_method_id;
                if ($shipping_method_instance_id = $shipping_method['instance_id']) {
                    $shippingMethodFullName .= ':' . $shipping_method_instance_id;
                }

                if (isset($standardBooksOptions['shipping_articles'][$shippingMethodFullName])) {
                    if (!empty($standardBooksOptions['shipping_articles'][$shippingMethodFullName])) {
                        $shippingArticle = $standardBooksOptions['shipping_articles'][$shippingMethodFullName];
                    }
                }

                if (isset($standardBooksOptions['shipping_taxes'][$shippingMethodFullName])) {
                    if (!empty($standardBooksOptions['shipping_taxes'][$shippingMethodFullName])) {
                        $shippingTax = $standardBooksOptions['shipping_taxes'][$shippingMethodFullName];
                    }
                }
            }

            foreach ($line_items_shipping as $item_id => $item) {
                $name = $item->get_name() ? $item->get_name() : __( 'Shipping', 'woocommerce' );
                $tax_data = $item->get_taxes();

                if (empty(eliides_arr_get($tax_data, ['total']))) {
                    $footerComment[] = 'Tarneviis: ' . $name;
                }
                $shippingFound = false;
                $tax_item_id = 0;

                $lastTaxRow = array();
                $maxValueTaxRow = array();
                $maxTaxValue = 0;

                foreach ($tax_data['total'] as $tax_item_id => $tax_total) {

                    if (!isset($standardBooksTaxSettings[$tax_item_id])) {
                        $tax_item_id = 0;
                        if (isset($standardBooksTaxSettings['missing_vat'])) {
                            if (!empty($standardBooksTaxSettings['missing_vat'])) {
                                $tax_item_id = 'missing_vat';
                            }
                        }
                    }

                    if ($tax_total > $maxTaxValue) {
                        $shippingFound = true;
                        $maxValueTaxRow = array(
                            'tax_id' => $shippingTax ?? $standardBooksTaxSettings[$tax_item_id],
                            'description' => $name,
                            'vat' => isset($standardBooksVatSettings[$tax_item_id]) ? $standardBooksVatSettings[$tax_item_id] : '',
                            'quantity' => 1,
                            'price' => $pricesWithVat ? floatval( $item->get_total() + $item->get_total_tax() ) : floatval($item->get_total()),
                            'row_sum' => $pricesWithVat ? floatval( $item->get_total() + $item->get_total_tax() ) : floatval($item->get_total()),
                            'code' => !empty($shippingArticle) ? $shippingArticle : substr(str_replace(' ', '', $name), 0, 20),
                        );
                    }
                }
                if (!$shippingFound) {
                    $tax_item_id = 'missing_vat';
                    if (isset($standardBooksTaxSettings[$tax_item_id])) {
                        $data['rows'][] = array(
                            'tax_id' => $shippingTax ?? $standardBooksTaxSettings[$tax_item_id],
                            'description' => $name,
                            'vat' => isset($standardBooksVatSettings[$tax_item_id]) ? $standardBooksVatSettings[$tax_item_id] : '',
                            'quantity' => 1,
                            'price' => $pricesWithVat ? floatval( $item->get_total() + $item->get_total_tax() ) : floatval($item->get_total()),
                            'row_sum' => $pricesWithVat ? floatval( $item->get_total() + $item->get_total_tax() ) : floatval($item->get_total()),
                            'code' => !empty($shippingArticle) ? $shippingArticle : substr(str_replace(' ', '', $name), 0, 20),
                        );
                    }
                } else {
                    $data['rows'][] = $maxValueTaxRow;
                }
            }

            if ($hasEUVat) {
                foreach ($data['rows'] as $rowK => $row) {
                    if (isset($standardBooksTaxSettings['eu_vat_code'])) {
                        if (!empty($standardBooksTaxSettings['eu_vat_code'])) {
                            $data['rows'][$rowK]['tax_id'] = $standardBooksTaxSettings['eu_vat_code'];
                        }
                    }
                    if (isset($standardBooksVatSettings['eu_vat_code'])) {
                        if (!empty($standardBooksVatSettings['eu_vat_code'])) {
                            $data['rows'][$rowK]['vat'] = $standardBooksVatSettings['eu_vat_code'];
                        }
                    }
                }
            }

            $data = apply_filters('excellent_data_before_send', $data, $order_id);

            $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'send-invoice', array(
                'software' => 'excellent',
                'api_user' => eliides_arr_get($standardBooksOptions, ['api_user']),
                'api_pass' => eliides_arr_get($standardBooksOptions, ['api_pass']),
                'api_server' => eliides_arr_get($standardBooksOptions, ['api_server']),
                'api_port' => eliides_arr_get($standardBooksOptions, ['api_port']),
                'api_company_code' => eliides_arr_get($standardBooksOptions, ['api_company_code']),
                'invoice' => $data,
            ));

            if ($res['status'] > 0) {
                $order->add_order_note(sprintf(__('Arve saadeti raamatupidamistarkvarasse %s', ELIIDES_TD), 'Standard Books'));
                $order->update_meta_data('excellent_invoice_id', eliides_sanitize_text_or_array_field($res['data']));
                $order->save();

                return true;
            }
            return false;


        }

        public function getProducts() {
            $standardBooksOptions = get_option('veebiekspert_module_excellent_options');
            $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-products', array(
                'software' => 'excellent',
                'api_user' => eliides_arr_get($standardBooksOptions, ['api_user']),
                'api_pass' => eliides_arr_get($standardBooksOptions, ['api_pass']),
                'api_server' => eliides_arr_get($standardBooksOptions, ['api_server']),
                'api_port' => eliides_arr_get($standardBooksOptions, ['api_port']),
                'api_company_code' => eliides_arr_get($standardBooksOptions, ['api_company_code']),
            ));

            if ($res['status'] > 0) {
                return eliides_arr_get($res, 'data');
            }

            return false;
        }

        public function getStock() {
            $standardBooksOptions = get_option('veebiekspert_module_excellent_options');
            $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-stock', array(
                'software' => 'excellent',
                'api_user' => eliides_arr_get($standardBooksOptions, ['api_user']),
                'api_pass' => eliides_arr_get($standardBooksOptions, ['api_pass']),
                'api_server' => eliides_arr_get($standardBooksOptions, ['api_server']),
                'api_port' => eliides_arr_get($standardBooksOptions, ['api_port']),
                'api_company_code' => eliides_arr_get($standardBooksOptions, ['api_company_code']),
            ));

            if ($res['status'] > 0) {
                return eliides_arr_get($res, 'data');
            }

            return false;
        }

        public function getVatAccounts() {
            $standardBooksOptions = get_option('veebiekspert_module_excellent_options');
            $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-taxes', array(
                'software' => 'excellent',
                'api_user' => eliides_arr_get($standardBooksOptions, ['api_user']),
                'api_pass' => eliides_arr_get($standardBooksOptions, ['api_pass']),
                'api_server' => eliides_arr_get($standardBooksOptions, ['api_server']),
                'api_port' => eliides_arr_get($standardBooksOptions, ['api_port']),
                'api_company_code' => eliides_arr_get($standardBooksOptions, ['api_company_code']),
                'vat_accounts' => 1,
            ));

            if ($res['status'] > 0) {
                return eliides_arr_get($res, 'data');
            }
            return false;
        }

        public function getPaymentTerms() {
            $standardBooksOptions = get_option('veebiekspert_module_excellent_options');
            $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-payment-terms', array(
                'software' => 'excellent',
                'api_user' => eliides_arr_get($standardBooksOptions, ['api_user']),
                'api_pass' => eliides_arr_get($standardBooksOptions, ['api_pass']),
                'api_server' => eliides_arr_get($standardBooksOptions, ['api_server']),
                'api_port' => eliides_arr_get($standardBooksOptions, ['api_port']),
                'api_company_code' => eliides_arr_get($standardBooksOptions, ['api_company_code']),
                'vat_accounts' => 1,
            ));

            if ($res['status'] > 0) {
                return eliides_arr_get($res, 'data');
            }
            return false;
        }

        public function getTaxes() {
            $standardBooksOptions = get_option('veebiekspert_module_excellent_options');
            $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-taxes', array(
                'software' => 'excellent',
                'api_user' => eliides_arr_get($standardBooksOptions, ['api_user']),
                'api_pass' => eliides_arr_get($standardBooksOptions, ['api_pass']),
                'api_server' => eliides_arr_get($standardBooksOptions, ['api_server']),
                'api_port' => eliides_arr_get($standardBooksOptions, ['api_port']),
                'api_company_code' => eliides_arr_get($standardBooksOptions, ['api_company_code']),
            ));

            if ($res['status'] > 0) {
                return eliides_arr_get($res, 'data');
            }
            return false;
        }

        public function getPaymentMethods() {
            $standardBooksOptions = get_option('veebiekspert_module_excellent_options');
            $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-payment-methods', array(
                'software' => 'excellent',
                'api_user' => eliides_arr_get($standardBooksOptions, ['api_user']),
                'api_pass' => eliides_arr_get($standardBooksOptions, ['api_pass']),
                'api_server' => eliides_arr_get($standardBooksOptions, ['api_server']),
                'api_port' => eliides_arr_get($standardBooksOptions, ['api_port']),
                'api_company_code' => eliides_arr_get($standardBooksOptions, ['api_company_code']),
            ));

            if ($res['status'] > 0) {
                return eliides_arr_get($res, 'data');
            }
            return false;
        }

        private function generate_reference_number($nr){
            $nr = (string)$nr;
            $kaal = array(7,3,1);
            $sl = $st = strlen($nr);
            $total = 0;
            while($sl > 0 and substr($nr, --$sl, 1) >='0'){
                $total += substr($nr, ($st-1)-$sl, 1)*$kaal[($sl%3)];
            }
            $kontrollnr = ((ceil(($total/10))*10)-$total);
            return $nr.$kontrollnr;
        }

    }

endif;
