<?php

class WC_Integration_Eliides_Excellent extends WC_Integration {


    public function __construct() {
        $this->id                 = 'excellent';
        $this->method_title       = 'Standard Books';
        $this->method_description = null;

        $this->init_form_fields();
        $this->init_settings();

        add_action( 'woocommerce_update_options_integration_' .  $this->id, array( $this, 'process_admin_options' ) );
    }

    public function process_admin_options()
    {
        $this->init_settings();

        $post_data = $this->get_post_data();
        update_option('veebiekspert_module_excellent_api_key', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_excellent_api_key']));
        update_option('veebiekspert_module_excellent_options', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_excellent_options']));
        update_option('veebiekspert_module_excellent_trigger', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_excellent_trigger']));
        update_option('veebiekspert_module_excellent_taxes', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_excellent_taxes']));
        update_option('veebiekspert_module_excellent_vat', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_excellent_vat']));
        update_option('veebiekspert_module_excellent_payment_methods', eliides_sanitize_text_or_array_field($post_data['veebiekspert_module_excellent_payment_methods']));

        $activeModules = (array) get_option('veebiekspert_active_module', []);
        $module = 'excellent';

        if (!empty($post_data['is_module_active'])) {
            if (!in_array($module, $activeModules)) {
                $activeModules[] = $module;
                update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
            }
        }
        else {
            $key = array_search($module, $activeModules);
            if (false !== $key) {
                unset($activeModules[$key]);
                update_option('veebiekspert_active_module', eliides_sanitize_text_or_array_field($activeModules));
            }
        }

    }

    public function admin_options() {
        parent::admin_options();

        $taxes = array(
            0 => array(
                'label' => '0%',
                'rate' => 0,
            )
        );

        if (defined('WC_ABSPATH')) {

            $allShippingPackages = WC()->shipping()->get_shipping_methods();

            $zones = WC_Shipping_Zones::get_zones();
            foreach ($zones as $zone) {
                foreach ($zone['shipping_methods'] as $shipMethod) {
                    $shipObj = new stdClass();
                    $shipObj->id = $shipMethod->id . ':' . $shipMethod->instance_id;
                    $shipObj->title = $shipMethod->title;
                    $allShippingPackages[] = $shipObj;
                }
            }


            foreach (WC_Tax::get_rates() as $taxId => $tax) {
                $taxes[$taxId] = $tax;
            }

            if (class_exists('WC_Tax')) {
                if (method_exists('WC_Tax', 'get_tax_class_slugs')) {

                    $taxClasses = array_merge(array(''), WC_Tax::get_tax_class_slugs());

                    foreach ($taxClasses as $taxSlug) {
                        foreach (WC_Tax::get_rates_for_tax_class($taxSlug) as $taxId => $tax) {
                            $taxes[$taxId] = array(
                                'label' => implode(', ', array_filter(array($taxSlug, $tax->tax_rate_name, $tax->tax_rate_country))),
                                'rate' => $tax->tax_rate,
                            );
                        }

                    }

                }
            }

        }

        $veebiekspert_active_module = (array) get_option('veebiekspert_active_module');
        ?>
        <?php
        $excellentOptions = (array) get_option('veebiekspert_module_excellent_options');
        ?>

        <?php if (!isset($excellentOptions['api_company_code']) && empty($excellentOptions['api_company_code'])) {
            $excellentOptions['api_company_code'] = 1;
        }
        ?>

        <div class="veebiekspert-setting-block">
            <input type="hidden" name="is_module_active" value="0" />
            <h2><label><input type="checkbox" name="is_module_active"<?php if (in_array('excellent', $veebiekspert_active_module)): ?> checked<?php endif; ?> value="1" /> Aktiivne</label></h2>

            <div class="settings-block-inner">

                <div class="ve-form-group">
                    <label>E-liides litsentsi võti</label>
                    <input type="text" id="veebiekspert_module_excellent_api_key" name="veebiekspert_module_excellent_api_key" value="<?php echo get_option('veebiekspert_module_excellent_api_key'); ?>" />
                    <a href="https://www.e-liides.ee" target="_blank">Registreeri võti (7 päeva tasuta)</a>
                </div>

                <div class="ve-form-group">
                    <label>Standard Books kasutaja</label>
                    <input type="text" name="veebiekspert_module_excellent_options[api_user]" value="<?php echo esc_html(eliides_arr_get($excellentOptions, ['api_user'])); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Standard Books parool</label>
                    <input type="text" name="veebiekspert_module_excellent_options[api_pass]" value="<?php echo esc_html(eliides_arr_get($excellentOptions, ['api_pass'])); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Standard Books server (nt mars.excellent.ee)</label>
                    <input type="text" placeholder="mars.excellent.ee" name="veebiekspert_module_excellent_options[api_server]" value="<?php echo esc_html(eliides_arr_get($excellentOptions, ['api_server'])); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Standard Books server (nt 4455)</label>
                    <input type="text" placeholder="4455" name="veebiekspert_module_excellent_options[api_port]" value="<?php echo esc_html(eliides_arr_get($excellentOptions, ['api_port'])); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Standard Books ettevõtte kood</label>
                    <input type="text" name="veebiekspert_module_excellent_options[api_company_code]" value="<?php echo esc_html(eliides_arr_get($excellentOptions, ['api_company_code'])); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Arve maksetähtaeg (valikuline)</label>
                    <input type="text" name="veebiekspert_module_excellent_options[payment_term]" placeholder="Vaikimisi 7 päeva" value="<?php echo esc_html(eliides_arr_get($excellentOptions, ['payment_term'])); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Fikseeritud kliendi ID eraisiku puhul (valikuline)</label>
                    <input type="text" name="veebiekspert_module_excellent_options[fixed_person_id]" placeholder="" value="<?php echo esc_html(eliides_arr_get($excellentOptions, ['fixed_person_id'])); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Arve eesliides</label>
                    <input type="text" name="veebiekspert_module_excellent_options[invoice_prefix]" placeholder="" value="<?php echo esc_html(eliides_arr_get($excellentOptions, ['invoice_prefix'], 'WP')); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Laokood, millelt laoseis maha arvestatakse</label>
                    <input type="text" name="veebiekspert_module_excellent_options[warehouse_code]" placeholder="" value="<?php echo esc_html(eliides_arr_get($excellentOptions, ['warehouse_code'], 'PL')); ?>" />
                </div>

                <div class="ve-form-group">
                    <label>Arve summade tüüp</label>
                    <select name="veebiekspert_module_excellent_options[invoice_sum_type]">
                        <?php foreach (array('without_vat' => 'Summad saadetakse maksudeta ja lisatakse maksutüüp kaasa, võib tekkida 0.01 EUR summa erinevus', 'with_vat' => 'Summad saadetakse koos maksudega ja Standard Books arvutab ise maksud') as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == eliides_arr_get($excellentOptions, ['invoice_sum_type'])): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="ve-form-group">
                    <label>Arve saadetakse kinnitatud olekus</label>
                    <select name="veebiekspert_module_excellent_options[invoice_is_ok_flag]">
                        <?php foreach (array('yes' => 'Jah', 'no' => 'Ei') as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == eliides_arr_get($excellentOptions, ['invoice_is_ok_flag'])): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="ve-form-group">
                    <label>"Uuenda ladu" linnuke arvel</label>
                    <select name="veebiekspert_module_excellent_options[invoice_is_stock_flag]">
                        <?php foreach (array('yes' => 'Jah', 'no' => 'Ei') as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == eliides_arr_get($excellentOptions, ['invoice_is_stock_flag'])): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="ve-form-group">
                    <label>Arve saatmise hetk</label>

                    <?php

                    $options = array(
                        'woocommerce_order_status_on-hold' => 'Ootel',
                        'woocommerce_order_status_processing' => 'Töötluses',
                        'woocommerce_order_status_completed' => 'Tellimus täidetud',
                    );

                    $selected = get_option('veebiekspert_module_excellent_trigger', 'woocommerce_order_status_completed');
                    ?>

                    <select name="veebiekspert_module_excellent_trigger">
                        <?php foreach ($options as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == $selected): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="ve-form-group">
                    <span style="color: #cc0808; font-weight: bold;">Laoseisu uuendamiseks</span> tuleb külastada linki:<br />
                    <a href="<?php echo get_site_url(); ?>/?eliides_sync_excellent" target="_blank"><?php echo get_site_url(); ?>/?eliides_sync_excellent</a>
                </div>

                <?php
                $yesNoOptions = array(
                    'no' => 'Ei luba hindasi uuendada',
                    'yes' => 'Luba hindade uuendamine',
                );
                ?>

                <div class="ve-form-group">
                    <label>Hindade uuendamine lubatud</label>
                    <select name="veebiekspert_module_excellent_options[allow_price_update]">
                        <?php foreach ($yesNoOptions as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == eliides_arr_get($excellentOptions, ['allow_price_update'])): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <?php
                $yesNoOptions = array(
                    'yes' => 'Ühilda Booksi arve ja Montonio makse viitenumbrid',
                    'no' => 'Ära ühilda Booksi arve ja Montonio makse viitenumbrid',
                );
                ?>

                <div class="ve-form-group">
                    <label>Booksi ja Montonio viitenumbri ühildamine (Montonio olemasolul)</label>
                    <select name="veebiekspert_module_excellent_options[sync_montonio_books_reference_nr]">
                        <?php foreach ($yesNoOptions as $k => $i): ?>
                            <option value="<?php echo $k; ?>"<?php if ($k == eliides_arr_get($excellentOptions, ['sync_montonio_books_reference_nr'])): ?> selected<?php endif; ?>><?php echo $i; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>


                <div class="ve-form-group">
                    <label>Kliendi kategooria kood (valikuline)</label>
                    <input type="text" name="veebiekspert_module_excellent_options[customer_cat]" value="<?php echo esc_html(eliides_arr_get($excellentOptions, ['customer_cat'])); ?>" />
                </div>

                <?php if (defined('WC_ABSPATH')): ?>

                    <?php
                    $available_gateways = WC()->payment_gateways->payment_gateways();
                    $excellentPaymentMethods = Veebiekspert_Modules()->getExcellent()->getPaymentMethods();
                    $excellentPaymentTerms = Veebiekspert_Modules()->getExcellent()->getPaymentTerms();

                    $excellentPaymentSettings = get_option('veebiekspert_module_excellent_payment_methods');
                    if (!$excellentPaymentMethods) {
                        $excellentPaymentMethods = array();
                    }

                    ?>

                    <table class="widefat fixed" style="margin-top: 20px;">
                        <thead>
                        <tr>
                            <th>E-poe makseviis</th>
                            <th>Maksetingimus</th>
                            <th>Excellent konto</th>
                            <th>Laekumine lisatakse Booksi</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($available_gateways as $methodName => $method): ?>
                            <tr>
                                <td><?php echo @esc_html($method->title); ?></td>
                                <td>
                                    <select name="veebiekspert_module_excellent_options[payment_terms][<?php echo @esc_html($methodName); ?>]">
                                        <?php foreach ($excellentPaymentTerms as $excellentPaymentTerm): ?>
                                            <option value="<?php echo $excellentPaymentTerm['code']; ?>"<?php if (isset($excellentOptions['payment_terms'][$methodName]) && $excellentPaymentTerm['code'] == $excellentOptions['payment_terms'][$methodName]): ?> selected<?php endif; ?>><?php echo @esc_html($excellentPaymentTerm['name']); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                                <td>
                                    <select name="veebiekspert_module_excellent_options[payment_methods][<?php echo @esc_html($methodName); ?>]">
                                        <?php foreach ($excellentPaymentMethods as $excellentMethod): ?>
                                            <option value="<?php echo $excellentMethod['code']; ?>"<?php if (isset($excellentOptions['payment_methods'][$methodName]) && $excellentMethod['code'] == $excellentOptions['payment_methods'][$methodName]): ?> selected<?php endif; ?>><?php echo @esc_html($excellentMethod['name']); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                                <td>
                                    <select name="veebiekspert_module_excellent_options[disable_income][<?php echo @esc_html($methodName); ?>]">
                                        <option value="yes"<?php if (isset($excellentOptions['disable_income']) && $excellentOptions['disable_income'][$methodName] == 'yes'): ?> selected<?php endif; ?>>Jah</option>
                                        <option value="no"<?php if (isset($excellentOptions['disable_income']) && $excellentOptions['disable_income'][$methodName] == 'no'): ?> selected<?php endif; ?>>Ei</option>
                                    </select>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>

                    <?php

                    $excellentTaxes = Veebiekspert_Modules()->getExcellent()->getTaxes();
                    $excellentVats = Veebiekspert_Modules()->getExcellent()->getVatAccounts();
                    $excellentTaxSettings = (array) get_option('veebiekspert_module_excellent_taxes');
                    $excellentVatSettings = (array) get_option('veebiekspert_module_excellent_vat');

                    if (!$excellentTaxes) {
                        $excellentTaxes = array();
                    }
                    if (!$excellentVats) {
                        $excellentVats = array();
                    }

                    ?>

                    <table class="widefat fixed" style="margin-top: 20px;">
                        <thead>
                        <tr>
                            <th>Maksu ID</th>
                            <th>Maksu %</th>
                            <th>Nimetus</th>
                            <th>Vaste</th>
                            <th>Maksu tüüp</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($taxes as $taxId => $tax): ?>
                            <tr>
                                <td><?php echo $taxId; ?></td>
                                <td><?php echo $tax['rate']; ?></td>
                                <td><?php echo @esc_html($tax['label']); ?></td>
                                <td>
                                    <select name="veebiekspert_module_excellent_taxes[<?php echo $taxId; ?>]">
                                        <?php foreach ($excellentTaxes as $excellentTax): ?>
                                            <option value="<?php echo $excellentTax['id']; ?>"<?php if (isset($excellentTaxSettings[$taxId]) && $excellentTax['id'] == $excellentTaxSettings[$taxId]): ?> selected<?php endif; ?>><?php echo @esc_html($excellentTax['name'] . ' (' . $excellentTax['code'] . ')'); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                                <td>
                                    <select name="veebiekspert_module_excellent_vat[<?php echo $taxId; ?>]">
                                        <option value=""></option>
                                        <?php foreach ($excellentVats as $excellentVat): ?>
                                            <option value="<?php echo $excellentVat['code']; ?>"<?php if (isset($excellentVatSettings[$taxId]) && $excellentVat['code'] == $excellentVatSettings[$taxId]): ?> selected<?php endif; ?>><?php echo @esc_html($excellentVat['name'] . ' (' . $excellentVat['percent'] . '%)'); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        <tr>
                            <th colspan="3">EU VAT koodiga tellimus</th>
                            <td>
                                <select name="veebiekspert_module_excellent_taxes[eu_vat_code]">
                                    <?php foreach ($excellentTaxes as $excellentTax): ?>
                                        <option value="<?php echo $excellentTax['id']; ?>"<?php if (isset($excellentTaxSettings['eu_vat_code']) && $excellentTax['id'] == $excellentTaxSettings['eu_vat_code']): ?> selected<?php endif; ?>><?php echo @esc_html($excellentTax['name'] . ' (' . $excellentTax['code'] . ')'); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                            <td>
                                <select name="veebiekspert_module_excellent_vat[eu_vat_code]">
                                    <option value=""></option>
                                    <?php foreach ($excellentVats as $excellentVat): ?>
                                        <option value="<?php echo $excellentVat['code']; ?>"<?php if (isset($excellentVatSettings['eu_vat_code']) && $excellentVat['code'] == $excellentVatSettings['eu_vat_code']): ?> selected<?php endif; ?>><?php echo @esc_html($excellentVat['name'] . ' (' . $excellentVat['percent'] . '%)'); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <th colspan="3">Puuduva maksu vaste (peaks olema 0%)</th>
                            <td>
                                <select name="veebiekspert_module_excellent_taxes[missing_vat]">
                                    <?php foreach ($excellentTaxes as $excellentTax): ?>
                                        <option value="<?php echo $excellentTax['id']; ?>"<?php if (isset($excellentTaxSettings['missing_vat']) && $excellentTax['id'] == $excellentTaxSettings['missing_vat']): ?> selected<?php endif; ?>><?php echo @esc_html($excellentTax['name'] . ' (' . $excellentTax['code'] . ')'); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                            <td>
                                <select name="veebiekspert_module_excellent_vat[missing_vat]">
                                    <option value=""></option>
                                    <?php foreach ($excellentVats as $excellentVat): ?>
                                        <option value="<?php echo $excellentVat['code']; ?>"<?php if (isset($excellentVatSettings['missing_vat']) && $excellentVat['code'] == $excellentVatSettings['missing_vat']): ?> selected<?php endif; ?>><?php echo @esc_html($excellentVat['name'] . ' (' . $excellentVat['percent'] . '%)'); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                        </tr>
                        </tbody>
                    </table>


                    <table class="widefat fixed" style="margin-top: 20px;">
                        <thead>
                        <tr>
                            <th>Tarneviisi ID</th>
                            <th>Nimetus</th>
                            <th>Artikli kood</th>
                            <th>Konto (valikuline)</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($allShippingPackages as $package): ?>
                            <?php
                            if (empty($package->title)) {
                                continue;
                            }
                            $shippingArticle = '';
                            if (isset($excellentOptions['shipping_articles'][$package->id])) {
                                $shippingArticle = $excellentOptions['shipping_articles'][$package->id];
                            }
                            $shippingTax = '';
                            if (isset($excellentOptions['shipping_taxes'][$package->id])) {
                                $shippingTax = $excellentOptions['shipping_taxes'][$package->id];
                            }
                            ?>
                            <tr>
                                <td><?php echo $package->id; ?></td>
                                <td><?php echo esc_html($package->title); ?></td>
                                <td>
                                    <input type="text" name="veebiekspert_module_excellent_options[shipping_articles][<?php echo $package->id; ?>]" value="<?php echo esc_html($shippingArticle); ?>" />
                                </td>
                                <td>
                                    <select name="veebiekspert_module_excellent_options[shipping_taxes][<?php echo $package->id; ?>]">
                                        <option value="">Maksu järgi</option>
                                        <?php foreach ($excellentTaxes as $excellentTax): ?>
                                            <option value="<?php echo $excellentTax['id']; ?>"<?php if ($excellentTax['id'] == $shippingTax): ?> selected<?php endif; ?>><?php echo @esc_html($excellentTax['name'] . ' (' . $excellentTax['code'] . ')'); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>

                <?php else: ?>

                    Aktiveeri Woocommerce moodul, et maksude andmed seadistada

                <?php endif; ?>

            </div>

        </div>

        <?php
    }
}
