<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

if ( ! class_exists( 'Veebiekspert_Accouting_CompuCashSend' ) ) :

class CompuCash_productMapping {
 public $productId;
 public $externalProductId;
}

/*Product Group Id mapping*/
class CompuCash_productGroupMapping {
 public $productGId;
 public $externalProductGId;
}


/*Order row item*/
class CompuCash_RowItem 
{   
      public $name;
      public $unit;
      public $quantity;
      public $productID;
      public $productNo;
      public $barcode;
      public $salePrice;
      public $plannedPrice;
      public $vatRate;
      public $salePriceWAT;
      public $info;
}

/* Document Main */
class CompuCash_CcDocumentMain 
{
    public $document; 	
}

/*Cc Document*/
class CompuCash_CcDocument 
{
    public $documentType = 'ORDER';
	public $documentInfo;
    public $documentSums;
    public $payments;
	public $documentItems;
	public $buyer;
}

class CompuCash_CcDocumentInfo 
{
        public $documentNum = '';
        public $isAcceptedInvoice = 1;
	    public $docDate  = '';
        public $deliveryDate = '';
	    public $salepointID = '';
	    public $info = ''; 
}

class CompuCash_DocumentItems 
{
	public $rowItem;
}

class CompuCash_DocumentSums 
{   
      public $totalSum;
      public $rounding;
      public $wat;
      public $currency;
}

class CompuCash_PaymentItems 
{
	  public $paymentItem;
}

class CompuCash_Payment 
{   
    public $paymentType;
    public $amount;
    public $paymentTime;
    public $currency;
}

class CompuCash_Buyer 
{   
      public $name;
      public $deliveryAddress;
      public $buyerID;
      public $businessCode;
      public $contact;
}

class CompuCash_Contact 
{   
      public $phone;
      public $mail;
      public $fax;
      public $address;
}

class Veebiekspert_Accouting_CompuCashSend {
    
    protected $compuCash;
    
    public function __construct(Veebiekspert_Accouting_CompuCash $compuCash) {
        $this->compuCash = $compuCash;
    }
    
    public function generateCcOrder($order_id){
        $order = new WC_Order( $order_id ); 
        $order_data = $order->get_data(); 
        $order_currency = $order->get_currency();
        $order_total_tax = $order_data['total_tax']; 

        $ccDocumentMain = new CompuCash_CcDocumentMain();
        $ccDocument = new CompuCash_CcDocument();
        $documentSums = new CompuCash_DocumentSums();
        $documentItems = new CompuCash_DocumentItems();
        $ccDocumentInfo = new CompuCash_CcDocumentInfo();

        $ccDocumentInfo->documentNum = $order->get_order_number();
         
        //$order_date_created = $order_data['date_created']->date('Y-m-d H:i:s');
        $ccDocumentInfo->docDate = $order->get_date_created()->date('d.m.Y');
        $orderTotal = $order->get_total();
        $documentSums->totalSum = $orderTotal;
        $documentSums->rounding = 0;
        $documentSums->currency = $order_currency;
        $documentSums->wat = $orderTotal - $order_total_tax;

        $buyer = new CompuCash_Buyer();
            $order_billing_first_name = $order_data['billing']['first_name'];
            $order_billing_last_name = $order_data['billing']['last_name'];
            $order_billing_company = $order_data['billing']['company'];
            $order_billing_address_1 = $order_data['billing']['address_1'];
            $order_billing_address_2 = $order_data['billing']['address_2'];
            $order_billing_city = $order_data['billing']['city'];
            $order_billing_state = $order_data['billing']['state'];
            $order_billing_postcode = $order_data['billing']['postcode'];
            $order_billing_country = $order_data['billing']['country'];
            $order_billing_email = $order_data['billing']['email'];
            $order_billing_phone = $order_data['billing']['phone'];

        $buyer->name = $order_billing_first_name . ' ' . $order_billing_last_name;  

        $contact = new CompuCash_Contact();
        $contact->address =  $order_billing_address_1 . ' ' . $order_billing_address_2 . ' ' . $order_billing_city . ' '. $order_billing_state . ' ' . $order_billing_country;
        $contact->mail = $order_billing_email;
        $contact->phone = $order_billing_phone;
        $buyer -> contact = $contact;

        $rowItemsList = array();
        $line_items = $order->get_items();
        foreach ( $line_items as $item ) {

          $rowItem = new CompuCash_RowItem();   
            // This will be a product
          $product = $order->get_product_from_item( $item );

            if ($item['variation_id']) {
                $product = wc_get_product($item['variation_id']);
            }
            elseif ($item['product_id']) {
                $product = wc_get_product($item['product_id']);
            }
          
          if (!$product) {
              continue;
          }
          $rowItem -> name = $product -> get_name();  
            // This is the products SKU
          $sku = $product->get_sku();
            if (is_numeric($sku)){
                $rowItem -> productID = intval($sku) ;
            } else if (strpos($sku, '-') !== false) {
                $dashPos = strrpos($sku, '-');
                $extractedProductId = substr($sku, $dashPos + 1);
                $rowItem -> productID = $extractedProductId ; 
            } else {
                $rowItem -> productNo = $sku ;
            }

          // This is the qty purchased
          $qty = $item['qty'];
          $rowItem -> quantity = $qty;
          // Line item total cost including taxes and rounded
          //$total = $order->get_line_total( $item, true, true );
          //$total = $product->get_price();
          $rowItem->salePrice = $product -> get_price();

          // Line item subtotal (before discounts)
          $subtotal = $order->get_line_subtotal( $item, true, true );
          array_push($rowItemsList, $rowItem);
        }

        $shipping_product_id = 1;

        foreach( $order->get_items( 'shipping' ) as $item_id => $shipping_item_obj ){
            // Get the data in an unprotected array
            $shipping_item_data = $shipping_item_obj->get_data();
            
            $shipping_data_id           = $shipping_item_data['id'];
            $shipping_data_order_id     = $shipping_item_data['order_id'];
            $shipping_data_name         = $shipping_item_data['name'];
            $shipping_data_method_title = $shipping_item_data['method_title'];
            $shipping_data_method_id    = $shipping_item_data['method_id'];
            $shipping_data_total        = $shipping_item_data['total'];
            $shipping_data_total_tax    = $shipping_item_data['total_tax'];
            $shipping_data_taxes        = $shipping_item_data['taxes'];
            $rowItem = new CompuCash_RowItem();
            $rowItem -> name = $shipping_data_method_title; 
            $rowItem -> quantity = 1;
            $rowItem -> productNo = 'T0001' ;
            $rowItem -> productID = 93 ;
            $line_total_tax = $shipping_data_total_tax;
            $rowItem->salePrice = $shipping_data_total;
            array_push($rowItemsList, $rowItem);
        }
        $documentItems->rowItem = $rowItemsList;
        $ccDocument->documentItems = $documentItems;
        $ccDocument->documentSums = $documentSums;
        $ccDocument->buyer = $buyer;
        $ccDocument->documentInfo = $ccDocumentInfo;

        $paymentItem = new CompuCash_Payment();
        $paymentItem->amount = $orderTotal;
        $paymentItem->currency = $order_currency;
        $paymentItem->paymentType = 6;
        $paymentItemArray = ['payment' => array($paymentItem)];

        $ccDocument->payments=$paymentItemArray; 
        $ccDocumentMain->document = $ccDocument; 
        
        return $ccDocumentMain;        
    }
    
}


endif; 