<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

include_once( VE_ABS_PATH . 'accounting/compucash/send.php' );

if ( ! class_exists( 'Veebiekspert_Accouting_CompuCash' ) ) :


class Veebiekspert_Accouting_CompuCash {
    
    /**
     * API
     * 
     * @var Veebiekspert_API
     */
    protected $_api;
    
    protected $_api_key;
    
    protected $_params;
    
    protected $_name = 'compucash';
    
    protected $compucash;
    
    const SEND_INVOICE = 'eliides_compucash_send';
    
    /**
     * Consturctor
     * 
     * @param Veebiekspert_API $api
     */
    public function __construct(Veebiekspert_API $api) {
        
        $this->_api = $api;
        
        $this->compucash = new Veebiekspert_Accouting_CompuCashSend($this);
        
        $veebiekspert_active_module = get_option('veebiekspert_active_module');

        add_action( 'plugins_loaded', function() {
            if ( class_exists( 'WC_Integration' ) ) {
                include_once( VE_ABS_PATH . 'accounting/compucash/compucash-integration.php' );
                add_filter( 'woocommerce_integrations', function($integrations) {
                    $integrations[] = 'WC_Integration_Eliides_Compucash';
                    return $integrations;
                });
            }
        });
        
        if (!in_array('compucash', (array) $veebiekspert_active_module)) {
            return;
        }
        
        $this->_api_key = get_option('veebiekspert_module_compucash_api_key');
        $this->_params = get_option('veebiekspert_module_compucash_params', array());
        
        add_action('wp_ajax_' . self::SEND_INVOICE, array($this, 'send_invoice_ajax'));
        
        if ($this->_api_key) {
            
            add_action('product_cat_add_form_fields', array($this, 'add_category_field'));
            add_action('product_cat_edit_form_fields', array($this, 'add_category_field'));
            
            add_action('edited_product_cat', array($this, 'save_taxonomy_custom_meta'), 10, 1);
            add_action('create_product_cat', array($this, 'save_taxonomy_custom_meta'), 10, 1);
            
            add_filter('woocommerce_admin_order_actions', array($this, 'show_if_invoice_sent'), 10, 2);
            add_action('admin_footer', array($this, 'custom_bulk_admin_footer'));
            
            add_action('load-edit.php', array($this, 'bulk_action'));
            
            $trigger = eliides_arr_get($this->_params, ['invoice_trigger']);
            
            add_action($trigger, array($this, 'send_invoice'));
            
            if (isset($_GET['eliides_sync_compucash'])) {
                add_action('init', array($this, 'sync'));
            }
        }
        
    }
    
    public function sync() {
        $this->sync_products();
        exit;
    }
    
    public function save_taxonomy_custom_meta($term_id) {
        update_term_meta($term_id, 'compucash_category_id', sanitize_text_field($_POST['compucash_category_id']));
    }
    
    public function add_category_field($term) {
        $term_id = $term->term_id;
        $compuCatIds = (array) get_term_meta($term_id, 'compucash_category_id', true);
        
        $categories = $this->_api->sendRequest($this->_api_key, 'product', 'get-categories', array(
            'software' => $this->_name,
            'software_client_id' => eliides_arr_get($this->_params, ['client_id']),
            'software_client_secret' => eliides_arr_get($this->_params, ['client_secret']),
        ));
        
        if ($compucashCategories = Veebiekspert_Modules()->getCompuCash()->getCategories()):
        ?> 
        <tr class="form-field">
            <th scope="row" valign="top"><label>CompuCash kategooria</label></th>
            <td>
                <select name="compucash_category_id[]" multiple>
                    <?php foreach (eliides_arr_get($compucashCategories, ['data']) as $category): ?>
                    <option value="<?php echo eliides_arr_get($category, ['productGid']); ?>"<?php if (in_array(eliides_arr_get($category, ['productGid']), $compuCatIds)): ?> selected<?php endif; ?>><?php echo esc_html(eliides_arr_get($category, ['productGroupName'])); ?></option>
                    <?php endforeach; ?>
                </select>
            </td>
        </tr>
        <?php
        endif; 
    }
    
    public function sync_products() {
        $products = $this->getProducts();
        
        $catIdByName = array();
        foreach (eliides_arr_get($this->getCategories(), ['data'], []) as $compuCat) {
            $catIdByName[eliides_arr_get($compuCat, ['productGid'])] = eliides_arr_get($compuCat, ['productGroupName']);
        }
        
        $catByExternal = array();
        
        $categories = get_categories(array(
            'taxonomy' => 'product_cat',
            'show_count' => 0,
            'hide_empty' => 0,
        ));
        
        foreach ($categories as $category) {
            $compuCatIds = (array) get_term_meta($category->term_id, 'compucash_category_id', true);
            
            if (!empty($compuCatIds)) {
                foreach ($compuCatIds as $compuCatId) {
                    if (!isset($catIdByName[$compuCatId])) {
                        continue;
                    }
                    $catName = sanitize_text_field($catIdByName[$compuCatId]);
                    if (!isset($catByExternal[$catName])) {
                        $catByExternal[$catName] = array();
                    }
                    $catByExternal[$catName][] = $category->term_id;
                }
            }
        }
        
        foreach (eliides_arr_get($products, ['data'], []) as $product) {
            
			try {
				
				
				if (empty(eliides_arr_get($product, ['productNumber']))) {
					continue;
				}
				
				if (!$post_id = wc_get_product_id_by_sku(eliides_arr_get($product, ['productNumber']))) {
					
					if (isset($catByExternal[$product['productGroupName']])) {

						$post_id = wp_insert_post( array(
							'post_title' => eliides_arr_get($product, ['productName']),
							'post_content' => empty(eliides_arr_get($product, ['longDescription'])) ? null : $product['longDescription'],
							'post_status' => 'publish',
							'post_type' => "product",
						));
						
						
						update_post_meta( $post_id, '_eliides_importer', sanitize_text_field($this->_name));
						update_post_meta( $post_id, '_sku', sanitize_text_field($product['productNumber']));
						update_post_meta( $post_id, '_visibility', 'visible' );
						update_post_meta( $post_id, '_manage_stock', 'yes' );
						update_post_meta( $post_id, 'total_sales', '0' );
						update_post_meta( $post_id, '_downloadable', 'no' );

						wp_set_object_terms($post_id, $catByExternal[$product['productGroupName']], 'product_cat', true);
					}
				}
				
				if (empty($post_id)) {
				    continue;
				}
				
				
					
				$price = $product['saleprice'];
				
				update_post_meta( $post_id, '_backorders', 'yes' );
				
				update_post_meta( $post_id, '_regular_price', sanitize_text_field($price) );
				update_post_meta( $post_id, '_price', sanitize_text_field($price) );
				update_post_meta( $post_id, '_stock', sanitize_text_field($product['quantity']) );
				
				if ($product['quantity'] > 0) {
					update_post_meta( $post_id, '_stock_status', 'instock');
				}
				else {
					update_post_meta( $post_id, '_stock_status', 'onbackorder');
				}
            }
			catch (Exception $e) {

			}
        }
    }
    
    public function bulk_action() {
        $wp_list_table = _get_list_table( 'WP_Posts_List_Table' );
        $action        = $wp_list_table->current_action();
        
        if ($action !== 'eliide_compucash_send_bulk') {
            return false;
        }

        $post_ids = array_map( 'absint', (array) $_REQUEST['post'] );
        
        foreach ($post_ids as $order_id) {
            $this->send_invoice($order_id);
        }
    }
    
    public function custom_bulk_admin_footer() {
        global $post_type;
         if($post_type == 'shop_order') {
         ?>
         <script type="text/javascript">
         jQuery(document).ready(function() {
             jQuery('<option>').val('eliide_compucash_send_bulk').text('<?php echo esc_html(__('Saada arve CompuCash serverisse', ELIIDES_TD)); ?>').appendTo('select[name="action"]');
             jQuery('<option>').val('eliide_compucash_send_bulk').text('<?php echo esc_html(__('Saada arve CompuCash serverisse', ELIIDES_TD)); ?>').appendTo('select[name="action2"]');
         });
         </script>
         <?php
         }
    }
    
    public function send_invoice_ajax() {
        $order_id = absint($_GET['order_id']);
        
        $this->send_invoice($order_id);
        
        wp_safe_redirect(wp_get_referer() ? wp_get_referer() : admin_url('edit.php?post_type=shop_order') );
        exit;
    }
    
    public function show_if_invoice_sent($actions, $order) {
        
        if (!get_post_meta($order->get_id(), 'compucash_invoice_id', true)) {
            
            $paymentType = get_post_meta($order->get_id(), '_payment_method', true );
            
            $disabledPaymentMethods = (array) apply_filters('eliides_accounting_disabled_methods_' . self::SEND_INVOICE, array());
    
            if (!in_array($paymentType, $disabledPaymentMethods)) {
                $actions[self::SEND_INVOICE] = array(
                    'action' => self::SEND_INVOICE,
                    'url' => wp_nonce_url(admin_url('admin-ajax.php?action=' . self::SEND_INVOICE . '&order_id=' . $order->get_id()), 'eliides-compucash-send'),
                    'name' => __('Saada arve CompuCash serverisse', ELIIDES_TD)
                );
            }
        }
        return $actions;
    }
    
    public function send_invoice($order_id) {
        $order = wc_get_order($order_id);
        
        if (get_post_meta($order_id, 'compucash_invoice_id', true)) {
            return false;
        }
        
        $data = $this->compucash->generateCcOrder($order_id);
        
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'send-invoice', array(
            'software' => 'compucash',
            'software_client_id' => eliides_arr_get($this->_params, ['client_id']),
            'software_client_secret' => eliides_arr_get($this->_params, ['client_secret']),
            'invoice' => json_encode($data),
        ));
        
        if ($res['status'] > 0) {
            
            $order->add_order_note(sprintf(__('Arve saadeti raamatupidamistarkvarasse %s', ELIIDES_TD), 'CompuCash'));
            
            update_post_meta($order_id, 'compucash_invoice_id', eliides_sanitize_text_or_array_field($res['data']));
            
            return true;
        }
        return false;
        
        
    }
    
    
    public function getProducts() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-products', array(
            'software' => 'compucash',
            'software_client_id' => eliides_arr_get($this->_params, ['client_id']),
            'software_client_secret' => eliides_arr_get($this->_params, ['client_secret']),
        ));
		
        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }
    
    public function getVariableProducts() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-variable-products', array(
            'software' => 'compucash',
            'software_client_id' => eliides_arr_get($this->_params, ['client_id']),
            'software_client_secret' => eliides_arr_get($this->_params, ['client_secret']),
        ));
        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }
    
    public function getCategories() {
        $res = $this->_api->sendRequest($this->_api_key, 'accounting', 'get-product-categories', array(
            'software' => 'compucash',
            'software_client_id' => eliides_arr_get($this->_params, ['client_id']),
            'software_client_secret' => eliides_arr_get($this->_params, ['client_secret']),
        ));
        
        if ($res['status'] > 0) {
            return eliides_arr_get($res, 'data');
        }
        return false;
    }
    
}

endif; 